# SQreamDB MCP Server

A Model Context Protocol (MCP) server that enables Claude to interact with SQreamDB databases directly.

## Internal R&D Section
In order to create a release - Run:

`bash release.sh <TAG>`

The script will:

1. Creates a tag (will get exception if supplied tag exists).
2. Pack repository's content in tar.gz.
3. Upload tar to artifactory: http://artifactory.host-98.sq.l/artifactory/mcp_server/releases.
4. Create a release content On Git 'releases' for the new tag, while including the Artifactory's path.

## Prerequisites

- **Python 3.11 or higher** (recommended)
- Access to a SQreamDB instance
- Claude Desktop application

## Installation

### Automated Setup

Run the setup script with your SQreamDB connection parameters:

```bash
python setup_sqreamdb_mcp.py host=<hostname> port=<port> database=<database> username=<username> password=<password>
```

**Example:**
```bash
python setup_sqreamdb_mcp.py host=192.168.4.68 port=5000 database=master username=sqream password=sqream
```

This script will:
- Create a Python virtual environment
- Install all required dependencies
- Configure Claude Desktop to use the SQreamDB MCP server
- Set up the connection parameters

### Manual Setup

If you prefer to set up manually:

1. **Create virtual environment:**
   ```bash
   python -m venv sqreamdb_mcp_env
   source sqreamdb_mcp_env/bin/activate  # Linux/Mac
   # or
   sqreamdb_mcp_env\Scripts\activate     # Windows
   ```

2. **Install dependencies:**
   ```bash
   pip install -r requirements.txt
   ```

3. **Configure Claude Desktop:**
   Add the MCP server configuration to your Claude Desktop settings.

## Usage

1. **Restart Claude Desktop** after setup completion
2. **Start using SQreamDB queries** directly in Claude conversations
3. Claude can now:
   - Execute SQL queries against your SQreamDB
   - Access SQreamDB documentation and syntax
   - Help with database operations and optimization

## Connection Parameters

| Parameter | Description | Example |
|-----------|-------------|---------|
| `host` | SQreamDB server hostname or IP | `192.168.4.68` |
| `port` | SQreamDB/Server_picker server port | `5000` |
| `database` | Database name to connect to | `master` |
| `username` | SQreamDB username | `sqream` |
| `password` | SQreamDB password | `sqream` |
| `clustered` | set to true if server picker is used | `false` |

- Note: clustered is optional and should be used if server picker port is used as your port 
## Features

- **Direct SQL Execution**: Run queries against SQreamDB from Claude
- **Documentation Access**: Built-in access to SQreamDB syntax and functions
- **Query Optimization**: Get help with performance tuning
- **Schema Exploration**: Browse tables, columns, and database structure
- **Data Type Support**: Full support for SQreamDB data types and functions

## Troubleshooting

### Common Issues

1. **Python Version**: Ensure you're using Python 3.11 or higher
2. **Connection Issues**: Verify your SQreamDB server is accessible and credentials are correct
3. **Claude Desktop**: Make sure to restart Claude Desktop after setup

### Verification

To verify the setup worked correctly:
1. Open Claude Desktop
2. Ask Claude: "Can you connect to SQreamDB?"
3. Claude should be able to access SQreamDB documentation and execute queries

## Support

For issues or questions:
- Check the SQreamDB documentation
- Verify connection parameters
- Ensure all prerequisites are met

---

**Note**: This MCP server provides Claude with direct database access. Ensure appropriate security measures are in place for your SQreamDB instance.
