#!/bin/bash
############################################ run_with_sudo ######################################################################################
run_with_sudo () {
        if ! [ $(id -u) = 0 ]; then
   echo "##################################################################################"
   echo "Please run This script with sudo." 
   echo "##################################################################################"
   exit 1
fi
}
#########################################################################################################################
uninstall_sqloader_admin () {
sudo systemctl stop sqloader-admin
sq_admin_service_path=$(cat /usr/lib/systemd/system/sqloader-admin.service | grep 'WorkingDirectory'  |cut -d "=" -f2)
if [  -d $sq_admin_service_path ];then
  sudo rm -rf $sq_admin_service_path
  sudo rm -f /usr/lib/systemd/system/sqloader-admin.service
  sudo systemctl daemon-reload
  fi
}
uninstall_sqloader_service () {
  sq_service_path=$(cat /usr/lib/systemd/system/sqloader-service.service | grep 'WorkingDirectory'  |cut -d "=" -f2)
  sudo systemctl stop sqloader-service
  if [  -d $sq_service_path ];then
    sudo rm -rf $sq_service_path
    sudo rm -f /usr/lib/systemd/system/sqloader-service.service
    sudo systemctl daemon-reload
    fi
    }
#########################################################################################################################
SQloader_Admin_Service () {
today=$(date +"%Y-%m-%d-%s") 
clear 
echo "##################################################################################"
echo "Welcome to SQloader Admin-Service installation"
echo "##################################################################################"
echo "Please Enter JAVA_HOME PATH"
read JAVA_HOME
if  [ ! -f $JAVA_HOME/bin/java ];then
echo "No JAVA_HOME Found"
exit
fi
echo "##################################################################################"
echo "The default PATH to install SQloader Admin Service is /usr/local/sqloader-admin"
read -p "Do you want to change the default PATH ? (y/N) " yN
case $yN in
        y )
echo "Please enter PATH"
read WorkingDirectory
while [ -z "$WorkingDirectory" ]
do	printf 'Please enter the new PATH: '
read -r WorkingDirectory
[ -z "$WorkingDirectory" ] && echo 'PATH cannot be empty; try again.'
done
if [  -d $WorkingDirectory/sqloader-admin ];then
sudo mv $WorkingDirectory/sqloader-admin $WorkingDirectory/sqloader-admin_backup_$today
fi
sudo mkdir -p $WorkingDirectory/sqloader-admin/
sudo mkdir -p $WorkingDirectory/sqloader-admin/config
sudo mkdir -p $WorkingDirectory/sqloader-admin/bin
;;
* )
WorkingDirectory=/usr/local
if [  -d $WorkingDirectory/sqloader-admin ];then
sudo mv $WorkingDirectory/sqloader-admin $WorkingDirectory/sqloader-admin_backup_$today
fi
sudo mkdir -p $WorkingDirectory/sqloader-admin
sudo mkdir -p $WorkingDirectory/sqloader-admin/config
sudo mkdir -p $WorkingDirectory/sqloader-admin/bin
;;
esac
echo "##################################################################################"
echo "The default PATH to SQloader-Admin logs directory is /var/log/sqloader-admin/logs"
read -p "Do you want to change the default? (y/N) " yN
case $yN in
        y )
echo "Please enter the new PATH"
read LOG_DIR
while [ -z "$LOG_DIR" ]
do	printf 'Please enter the new PATH: '
read -r LOG_DIR
[ -z "$LOG_DIR" ] && echo 'PATH cannot be empty; try again.'
done
sudo mkdir -p $LOG_DIR/sqloader-admin
LOG_DIR=$LOG_DIR/sqloader-admin
;;
* )
sudo mkdir -p /var/log/sqloader-admin/
LOG_DIR=/var/log/sqloader-admin/
;;
esac
echo "##################################################################################"
echo "Please enter HZCLUSTERNAME"
read HZCLUSTERNAME
echo "##################################################################################"
read -p "SQloader-Admin default port is 7070 , Do you want to change the default port ? (y/N) " yN
case $yN in
        y )
echo "Please enter SQloader Admin Port"
read ADMINPORT
;;
        * )
ADMINPORT=7070
;;
esac        
echo "##################################################################################"
JAR=$(ls bin/ | grep -i 'admin')

########################################################################################

sudo cp bin/$JAR $WorkingDirectory/sqloader-admin
cat <<EOF | tee $WorkingDirectory/sqloader-admin/config/sqloader_admin.conf
JAVA_HOME=$JAVA_HOME
BINDIR=$WorkingDirectory/sqloader-admin
LOG_DIR=$LOG_DIR
JAR=$JAR
ADMINPORT=$ADMINPORT
HZCLUSTERNAME=$HZCLUSTERNAME
EOF
###################################################################################################################
cat <<EOF | sudo tee >> /usr/lib/systemd/system/sqloader-admin.service 
[Unit]
Description=SQream SQloader Admin Server
Documentation=http://docs.sqream.com/latest/manual/

[Service]
Type=simple

EnvironmentFile=${WorkingDirectory}/sqloader-admin/config/sqloader_admin.conf
WorkingDirectory=${WorkingDirectory}/sqloader-admin
ExecStartPre=/bin/bash -c 'source $WorkingDirectory/sqloader-admin/config/sqloader_admin.conf'
EOF
cat <<'EOT' | sudo tee >> /usr/lib/systemd/system/sqloader-admin.service
ExecStart=/bin/bash -c '${JAVA_HOME}/bin/java -jar -DLOG_DIR=${LOG_DIR} ${BINDIR}/${JAR} --server.port=${ADMINPORT} --hzClusterName=${HZCLUSTERNAME}'
ExecReload=/bin/kill -HUP $MAINPID
ExecStop=/bin/kill -15 $MAINPID
Restart=on-failure
RestartSec=10
StandardOutput=null
StandardError=null

[Install]
WantedBy=multi-user.target
EOT
######################################### Start Service ###########################################################
sudo systemctl daemon-reload
echo "##################################################################################"
echo "############# SQLoader-Admin Service installed successfuly #######################"
echo "##################################################################################"
echo "To Start SQLoader-Admin Service: sudo systemctl start sqloader-admin"
echo "To View SQLoader-Admin Service status: sudo systemctl status sqloader-admin"
echo "##################################################################################"
}
SQloader_Service () {
  today=$(date +"%Y-%m-%d-%s")
  clear
echo "##################################################################################"
echo "Welocome to SQloader service installation"
echo "##################################################################################"
echo "Please Enter JAVA_HOME Path"
read JAVA_HOME
if [ ! -f $JAVA_HOME/bin/java ];then
echo "No JAVA_HOME Found"
exit
fi
echo "##################################################################################"
echo "The Default PATH to install SQloader Service is /usr/local/sqloader"
read -p "Do you want to change the default? (y/N) " yN
case $yN in
        y )
echo "Please enter the new PATH"
read WorkingDirectory
while [ -z "$WorkingDirectory" ]
do	printf 'Please enter the new PATH: '
read -r WorkingDirectory
[ -z "$WorkingDirectory" ] && echo 'PATH cannot be empty; try again.'
done
if [  -d $WorkingDirectory/sqloader ];then
sudo mv $WorkingDirectory/sqloader $WorkingDirectory/sqloader_backup_$today
fi
sudo mkdir -p $WorkingDirectory/sqloader/
sudo mkdir -p $WorkingDirectory/sqloader/config
sudo mkdir -p $WorkingDirectory/sqloader/bin
;;
* )
WorkingDirectory=/usr/local
if [  -d $WorkingDirectory/sqloader ];then
sudo mv $WorkingDirectory/sqloader $WorkingDirectory/sqloader-backup_$today

fi
sudo mkdir -p $WorkingDirectory/sqloader/
sudo mkdir -p $WorkingDirectory/sqloader/config
sudo mkdir -p $WorkingDirectory/sqloader/bin
;;
esac
echo "##################################################################################"
echo "The default PATH to SQloader Service logs directory is /var/log/sqloader-service"
read -p "Do you want to change The default? (y/N) " yN
case $yN in
        y )
echo "Please enter the new PATH"        
read LOG_DIR
while [ -z "$LOG_DIR" ]
do	printf 'Please enter the new PATH: '
read -r LOG_DIR
[ -z "$LOG_DIR" ] && echo 'PATH cannot be empty; try again.'
done
sudo mkdir -p $LOG_DIR/sqloader-service
LOG_DIR=$LOG_DIR/sqloader-service
;;
* )
sudo mkdir -p /var/log/sqloader-service
LOG_DIR=/var/log/sqloader-service
;;
esac

echo "##################################################################################"
echo "Please enter SQloader Admin IP address"
read adminip
echo "##################################################################################"
echo "Please enter SQloader MEM size in GB"
read mem
echo "##################################################################################"
echo "Please enter HZCLUSTERNAME"
read HZCLUSTERNAME
echo "##################################################################################"
read -p "Default CONFDIR is $WorkingDirectory/sqloader/config , Do you want to change the default CONFDIR ? (y/N) " yN
case $yN in
    y )
echo "Please enter the new SQloader CONFDIR PATH"
read CONF_DIR
sudo mkdir -p $CONF_DIR/sqloader/config
CONFDIR=$CONF_DIR/sqloader/config
sudo cp config/sqream-mapping.json $CONFDIR
sudo cp config/reserved_words.txt  $CONFDIR

echo "Using CONFDIR at $CONFDIR"
sleep 2

;;
   * )
CONFDIR=$WorkingDirectory/sqloader/config
;;
esac
echo "##################################################################################"
read -p "Default SQloader Admin port is 7070 , Do you want to change the default port ? (y/N) " yN
case $yN in
        y )
echo "Please enter the new SQloader Admin port"
read ADMINPORT
;;
        * )
ADMINPORT=7070
;;
esac
echo "##################################################################################"
read -p "Default SQloader Service port is 6060 , Do you want to change the default port ? (y/N) " yN
case $yN in
        y )
echo "Please enter the new SQloader Service port"
read PORT
;;
        * )
PORT=6060
;;
esac        
echo "##################################################################################"
read -p "Default sqload-jdbc.properties is $CONFDIR, Do you want to change the default? (y/N) " yN
case $yN in
        y )
echo "Please enter the new sqload-jdbc.properties PATH"
read CONFDIR
sudo mkdir -p $CONFDIR/sqloader/config
if [  -d $CONFDIR/sqloader/config ];then
echo 'name=connect-jdbc
connectionStringSource=<source database connection string>
connectionStringSqream=<sqreamdb connection string>
connectionStringCatalog=<catalog connection string>

sourceDatabaseName=<source database name>
sourceSchema=<source schema name>
sourceTable=<source table name>

filter=1=1
count=true
limit=2000
threadCount=1

rowid=false
batchSize=500
fetchSize=100000
chunkSize=0
caseSensitive=false

truncate=true
drop=true
loadTypeName=full
cdcCatalogTable=SMSDW.CDC_TABLES
cdcTrackingTable=SMSDW.CDC_TRACKING
loadSummaryTable=SMSDW.SQLOAD_SUMMARY
cdcPrimaryKeyTable=SMSDW.CDC_TABLE_PRIMARY_KEYS
cdcDelete=true
usePartitions=false
lockCheck=false
lockTable=true
loadDttm=false
useDbmsLob=false
' > $CONFDIR/sqloader/config/sqload-jdbc.properties
echo "##################################################################################"
echo "sqload-jdbc.properties PATH is:"
echo "$CONFDIR/sqloader/config"
CONFDIR=$CONFDIR/sqloader/config
PROPERTIES_FILE=$CONFDIR/sqload-jdbc.properties
JAR=$(ls bin/ | grep -i 'service')
sudo cp bin/$JAR $WorkingDirectory/sqloader/bin/
sudo cp config/sqream-mapping.json $CONFDIR
sudo cp config/reserved_words.txt  $CONFDIR
fi
echo "##################################################################################"
;;
* )
CONFDIR=$WorkingDirectory/sqloader/config
echo "Using default sqload-jdbc.properties PATH"
echo "$CONFDIR"
echo "##################################################################################"
if [  -d $CONFDIR ];then
echo 'name=connect-jdbc
connectionStringSource=<source database connection string>
connectionStringSqream=<sqreamdb connection string>
connectionStringCatalog=<catalog connection string>

sourceDatabaseName=<source database name>
sourceSchema=<source schema name>
sourceTable=<source table name>

filter=1=1
count=true
limit=2000
threadCount=1

rowid=false
batchSize=500
fetchSize=100000
chunkSize=0
caseSensitive=false

truncate=true
drop=true
loadTypeName=full
cdcCatalogTable=SMSDW.CDC_TABLES
cdcTrackingTable=SMSDW.CDC_TRACKING
loadSummaryTable=SMSDW.SQLOAD_SUMMARY
cdcPrimaryKeyTable=SMSDW.CDC_TABLE_PRIMARY_KEYS
cdcDelete=true
usePartitions=false
lockCheck=false
lockTable=true
loadDttm=false
useDbmsLob=false
' > $CONFDIR/sqload-jdbc.properties
PROPERTIES_FILE=$CONFDIR/sqload-jdbc.properties
echo "##################################################################################"
echo "Using $CONFDIR/sqload-jdbc.properties"
echo "##################################################################################"
JAR=$(ls bin/ | grep -i 'service')
sudo cp bin/$JAR $WorkingDirectory/sqloader/bin/
sudo cp config/sqream-mapping.json $WorkingDirectory/sqloader/config
sudo cp config/reserved_words.txt  $WorkingDirectory/sqloader/config  
  sleep 2
  fi
  ;;
  esac

#####################################################
cat <<EOF | sudo tee >> $WorkingDirectory/sqloader/config/sqloader_service.conf
JAVA_HOME=$JAVA_HOME
BINDIR=$WorkingDirectory/sqloader/bin
LOG_DIR=$LOG_DIR
CONFDIR=$WorkingDirectory/sqloader/config
JAR=$JAR
PROPERTIES_FILE=$CONFDIR/sqload-jdbc.properties
PORT=$PORT
ADMINIP=$adminip
ADMINPORT=$ADMINPORT
MEM=$mem
HZCLUSTERNAME=$HZCLUSTERNAME
WORKINGDIRECTORY=$WorkingDirectory/sqloader
EOF
#########################################################################################
cat <<EOF | sudo tee > /usr/lib/systemd/system/sqloader-service.service 
Description=SQream SQloader Service service
Documentation=http://docs.sqream.com/latest/manual/

[Service]
Type=simple

EnvironmentFile=$WorkingDirectory/sqloader/config/sqloader_service.conf
WorkingDirectory=$WorkingDirectory/sqloader/
ExecStartPre=/bin/bash -c 'source $CONFDIR/sqloader_service.conf'
EOF
cat <<'EOT' | sudo tee >> /usr/lib/systemd/system/sqloader-service.service 
ExecStart=/bin/bash -c '${JAVA_HOME}/bin/java -jar -Xmx${MEM}g -DLOG_DIR=${LOG_DIR} -DDEFAULT_PROPERTIES=${PROPERTIES_FILE} ${BINDIR}/${JAR} --configDir=${CONFDIR} --server.port=${PORT} --spring.boot.admin.client.url=http://${ADMINIP}:${ADMINPORT} --hzClusterName=${HZCLUSTERNAME} --logging.file.name=${LOG_DIR}/SQLoader_service.log'
ExecReload=/bin/kill -HUP $MAINPID
ExecStop=/bin/kill -15 $MAINPID
Restart=on-failure
RestartSec=10

[Install]
WantedBy=multi-user.target
EOT
##########################################################################################
sudo systemctl daemon-reload
echo "##################################################################################"
echo "############# SQLoader Service installed successfuly #######################"
echo "##################################################################################"
echo "To Start SQLoader Service: sudo systemctl start sqloader-service"
echo "To View SQLoader Service status: sudo systemctl status sqloader-service"
echo "##################################################################################"
}
#################################################################################################################################
help () 
{
  echo "usage: $0 [OPTIONS]"
  echo "Options:"
  clear
  echo "###################################################################################################"
  echo "-h, --help              show this help message end exit"
  echo "---------------------------------------------------------------------------------------------------"
  echo "-admin,                 Install SQloader-Admin Service"
  echo "                        example: sudo ./sqloader-v1.2.sh -admin"
  echo "---------------------------------------------------------------------------------------------------"
  echo "-service,               Install SQloader Service only"
  echo "                        example: sudo ./sqloader-v1.2.sh -service "
  echo "---------------------------------------------------------------------------------------------------"
  echo "-unadmin,               To  uninstall SQloader-Admin Service"
  echo "---------------------------------------------------------------------------------------------------"
  echo "-unservice,             To  uninstall SQloader Service only"
  echo "###################################################################################################"
  exit
}
if [[ $# = 0 ]];then
help
fi
while [[ $# > 0 ]]
do
key="$1"
case $key in
        # Shows help
  -#|--help)
    help
  shift
  ;;

  -admin|--SQloader_Admin_Service)
     shift;
     run_with_sudo
     SQloader_Admin_Service
     shift;
  ;;
-service|--SQloader_Service)
    shift;
    run_with_sudo
    SQloader_Service
    shift
  ;;
  -unadmin|--Uninstall_SQloader_Admin_Service)
  shift;
  uninstall_sqloader_admin
  shift;;
  -unservice|--Uninstall_SQloader_Service)
  shift;
  uninstall_sqloader_service
  shift;;
*)
  echo "unrecognised option: $1"
  help
    ;;
esac
done


