/*
 * Decompiled with CFR 0.152.
 */
package com.sqream.sqloaderadminserver.controller;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.hazelcast.map.IMap;
import com.sqream.sqloader.common.service.HazelcastService;
import com.sqream.sqloaderadminserver.dto.RequestDataBody;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.GetMapping;

@Controller
public class HtmlController {
    private static final Logger log = LoggerFactory.getLogger(HtmlController.class);
    @Autowired
    HazelcastService hazelcastService;

    @GetMapping(value={"/activeRequests"})
    public String activeRequests(Model model) {
        ObjectMapper objectMapper = new ObjectMapper();
        ArrayList requestDataBody = new ArrayList();
        IMap requests = this.hazelcastService.getRequests();
        requests.values().forEach(r -> {
            String reqString = r.toString();
            try {
                requestDataBody.add((RequestDataBody)objectMapper.readValue(reqString, RequestDataBody.class));
            }
            catch (JsonProcessingException e) {
                throw new RuntimeException(e);
            }
        });
        log.debug(((Object)requestDataBody).toString());
        model.addAttribute("requestDataBody", requestDataBody);
        return "activeRequests";
    }
}

