/*
 * Decompiled with CFR 0.152.
 */
package com.sqream.sqloaderService.utils.sqreamutils;

import com.sqream.sqloaderService.dbhandler.SqreamDbHandler;
import com.sqream.sqloaderService.loaders.cleanup.CleanupStrategy;
import com.sqream.sqloaderService.loaders.cleanup.FullLoad4512Cleanup;
import com.sqream.sqloaderService.loaders.cleanup.FullLoadDefaultCleanup;
import com.sqream.sqloaderService.querycomposer.SqreamCompatibilityVersions.CompatibilityVersionsQueries;
import com.sqream.sqloaderService.querycomposer.SqreamCompatibilityVersions.DefaultVersionSyntax;
import com.sqream.sqloaderService.querycomposer.SqreamCompatibilityVersions.Version4512Syntax;
import com.sqream.sqloaderService.querycomposer.SqreamCompatibilityVersions.Version4515Syntax;
import org.apache.maven.artifact.versioning.ComparableVersion;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class SqreamVersionsFactory {
    private static final Logger log = LoggerFactory.getLogger(SqreamVersionsFactory.class);

    public CompatibilityVersionsQueries getQuerySyntaxByVersion(String sqreamVersion) {
        ComparableVersion comparableSqreamVersion = new ComparableVersion(sqreamVersion);
        if (comparableSqreamVersion.compareTo(new ComparableVersion("4.5.15")) >= 0) {
            return new Version4515Syntax();
        }
        if (comparableSqreamVersion.compareTo(new ComparableVersion("4.5.12")) >= 0) {
            return new Version4512Syntax();
        }
        return new DefaultVersionSyntax();
    }

    public CleanupStrategy getFullLoadCleanupStrategyByVersion(SqreamDbHandler sqreamDbHandler) {
        ComparableVersion comparableSqreamVersion = new ComparableVersion(sqreamDbHandler.getSqreamVersion());
        if (comparableSqreamVersion.compareTo(new ComparableVersion("4.5.12")) >= 0) {
            return new FullLoad4512Cleanup(sqreamDbHandler);
        }
        return new FullLoadDefaultCleanup(sqreamDbHandler);
    }
}

