/*
 * Decompiled with CFR 0.152.
 */
package com.sqream.sqloaderService.utils.sqreamutils;

import com.sqream.sqloaderService.dbhandler.connectors.JDBCConnector;
import com.sqream.sqloaderService.enums.QueryResultType;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class SqreamVersions {
    private static final Logger log = LoggerFactory.getLogger(SqreamVersions.class);
    Map<String, String> SqreamVersionsMap = new HashMap();
    private static final String pattern = "(?i)v(\\d+(\\.\\d+){0,2}).*";

    public String getVersionMatcher(String version) {
        Pattern regex = Pattern.compile(pattern);
        Matcher matcher = regex.matcher(version);
        if (matcher.find()) {
            return matcher.group(1);
        }
        if (version.contains("develop")) {
            log.warn("Detected branch develop, using latest syntax..");
            return "999.999.999";
        }
        log.warn("can't find version {}, probably branch, will use latest syntax", (Object)version);
        return "999.999.999";
    }

    public String getSqreamVersion(String connectionString, JDBCConnector jdbcConnector) throws SQLException {
        if (!this.SqreamVersionsMap.containsKey(connectionString)) {
            this.SqreamVersionsMap.put(connectionString, this.getSqreamVersionFromServer(jdbcConnector));
        }
        return (String)this.SqreamVersionsMap.get(connectionString);
    }

    private String getSqreamVersionFromServer(JDBCConnector jdbcConnector) throws SQLException {
        String versionTag = (String)jdbcConnector.executeCommand("select show_version()", QueryResultType.STRING);
        String version = this.getVersionMatcher(versionTag);
        log.debug("using SQream version {}", (Object)version);
        return version;
    }

    public Map<String, String> getSqreamVersionsMap() {
        return this.SqreamVersionsMap;
    }

    public void setSqreamVersionsMap(Map<String, String> SqreamVersionsMap) {
        this.SqreamVersionsMap = SqreamVersionsMap;
    }
}

