/*
 * Decompiled with CFR 0.152.
 */
package com.sqream.sqloaderService.utils.retry;

import com.sqream.sqloaderService.dbhandler.cdc.AbstractCatalogHandler;
import com.sqream.sqloaderService.utils.retry.ErrorHolder;
import java.sql.SQLException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.retry.RetryCallback;
import org.springframework.retry.RetryContext;
import org.springframework.retry.listener.RetryListenerSupport;
import org.springframework.stereotype.Component;

@Component
public class TimeoutRetryListenerSupport
extends RetryListenerSupport {
    private static final Logger log = LoggerFactory.getLogger(TimeoutRetryListenerSupport.class);
    @Autowired
    ErrorHolder errorHolder;

    public <T, E extends Throwable> void close(RetryContext context, RetryCallback<T, E> callback, Throwable throwable) {
        super.close(context, callback, throwable);
    }

    public <T, E extends Throwable> void onError(RetryContext context, RetryCallback<T, E> callback, Throwable throwable) {
        AbstractCatalogHandler catalogHandler = (AbstractCatalogHandler)context.getAttribute("catalogHandler");
        if (catalogHandler != null) {
            if (this.errorHolder.idleConnectionErrors().stream().anyMatch(throwable.getMessage()::contains)) {
                try {
                    log.info("Reset connection due to timeout");
                    catalogHandler.resetConnection();
                }
                catch (SQLException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        super.onError(context, callback, throwable);
    }

    public <T, E extends Throwable> boolean open(RetryContext context, RetryCallback<T, E> callback) {
        return super.open(context, callback);
    }
}

