/*
 * Decompiled with CFR 0.152.
 */
package com.sqream.sqloaderService.utils;

import com.sqream.sqloader.common.enums.DBType;
import com.sqream.sqloaderService.configuration.SQLoaderConfiguration;
import com.sqream.sqloaderService.exceptions.InvalidArgumentException;
import jakarta.annotation.PostConstruct;
import java.io.File;
import java.io.FileNotFoundException;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.Scanner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/*
 * Exception performing whole class analysis ignored.
 */
@Component
public class StrUtils {
    private static final Logger log = LoggerFactory.getLogger(StrUtils.class);
    @Autowired
    public SQLoaderConfiguration defaultConfig;
    List<String> reservedWordsList;

    @PostConstruct
    private void init() {
        String reservedPath;
        if (this.defaultConfig.getReservedWordPath() != null) {
            File reservedFile = Paths.get(this.defaultConfig.getReservedWordPath(), new String[0]).toFile();
            reservedPath = reservedFile.getPath();
            if (reservedFile.isDirectory()) {
                reservedPath = Paths.get(this.defaultConfig.getReservedWordPath(), this.defaultConfig.getReservedWordFileName()).toString();
            }
        } else {
            reservedPath = Paths.get(this.defaultConfig.getConfigDir(), this.defaultConfig.getReservedWordFileName()).toString();
        }
        this.setReservedWordsList(reservedPath);
    }

    public void setReservedWordsList(String reservedPath) {
        this.reservedWordsList = new ArrayList();
        File file = new File(reservedPath);
        try {
            Scanner scanner = new Scanner(file);
            boolean lineNum = false;
            while (scanner.hasNextLine()) {
                String line = scanner.nextLine();
                this.reservedWordsList.add(line);
            }
            scanner.close();
        }
        catch (FileNotFoundException e) {
            String errorMsg = "File " + reservedPath + " doesn't exist, check again the file path";
            throw new InvalidArgumentException(errorMsg);
        }
    }

    public static String removeNewLines(String s) {
        if (s != null) {
            return s.replace("\n", "");
        }
        return null;
    }

    public String getSqreamDatabaseName(String sqreamConnectionString) {
        String lastPart;
        String[] splitConnStr;
        if (sqreamConnectionString != null && (splitConnStr = sqreamConnectionString.split("/")).length != 0 && (splitConnStr = (lastPart = splitConnStr[splitConnStr.length - 1]).split(";")).length != 0) {
            return splitConnStr[0];
        }
        return null;
    }

    public boolean checkUnexpectedIdentifier(String word) {
        boolean retval = false;
        boolean is_numeric = Character.isDigit((word = word.toLowerCase()).charAt(0));
        if (is_numeric) {
            return true;
        }
        for (String reservedWord : this.reservedWordsList) {
            if ((reservedWord.length() != 1 || !word.contains(reservedWord)) && !word.equalsIgnoreCase(reservedWord)) continue;
            retval = true;
            break;
        }
        return retval;
    }

    public String formatName(String word, DBType dbType, boolean caseSensitive) {
        if (caseSensitive || dbType == DBType.SQREAM && this.checkUnexpectedIdentifier(word)) {
            return "\"" + word + "\"";
        }
        if (dbType == DBType.ORCL || dbType == DBType.SAP || dbType == DBType.SYBASE) {
            return word.toUpperCase();
        }
        if (dbType == DBType.UNKNOWN) {
            return word;
        }
        return word.toLowerCase();
    }

    public String formatColumnName(String word, DBType dbType, boolean caseSensitive, String loadDttmColumnName) {
        if (caseSensitive || dbType == DBType.SQREAM && this.checkUnexpectedIdentifier(word)) {
            if (dbType == DBType.SQREAM && this.isHardCodedColumnName(word, loadDttmColumnName)) {
                return word;
            }
            return "\"" + word + "\"";
        }
        if (dbType == DBType.ORCL || dbType == DBType.SAP || dbType == DBType.SYBASE) {
            return word.toUpperCase();
        }
        if (dbType == DBType.UNKNOWN) {
            return word;
        }
        return word.toLowerCase();
    }

    private boolean isHardCodedColumnName(String word, String loadDttmColumnName) {
        return word.equalsIgnoreCase(loadDttmColumnName) || word.equalsIgnoreCase("ORA_ROW_ID");
    }

    public static String formatDateTime2ForQuery(String dateTime2Value) {
        if (dateTime2Value != null) {
            dateTime2Value = dateTime2Value.replace('T', ' ');
            dateTime2Value = dateTime2Value.replace("Z", "");
            dateTime2Value = dateTime2Value.replace("+", " +");
            dateTime2Value = StrUtils.addSpaceBeforeMinusTimeZone((String)dateTime2Value);
        }
        return dateTime2Value;
    }

    private static String addSpaceBeforeMinusTimeZone(String input) {
        StringBuilder result = new StringBuilder(input);
        if (input.split("-").length > 3) {
            int count = 0;
            for (int i = 0; i < result.length(); ++i) {
                if (result.charAt(i) != '-' || ++count != 3) continue;
                result.replace(i, i + 1, " -");
                break;
            }
        }
        return result.toString();
    }
}

