/*
 * Decompiled with CFR 0.152.
 */
package com.sqream.sqloaderService.utils;

import com.sqream.sqloaderService.utils.LogUtils;
import jakarta.servlet.http.HttpServletRequest;
import java.net.InetAddress;
import java.net.UnknownHostException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class NetworkUtils {
    private static final Logger log = LoggerFactory.getLogger(NetworkUtils.class);

    public static String getHostIp() {
        try {
            return InetAddress.getLocalHost().getHostAddress();
        }
        catch (UnknownHostException e) {
            log.error("Couldn't get host IP, setting it to \"Unknown\", failure is: " + String.valueOf(e));
            return "Unknown";
        }
    }

    public static String getHostName() {
        try {
            return InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            log.error("Couldn't get host name, setting it to \"Unknown\", failure is: " + String.valueOf(e));
            return "Unknown";
        }
    }

    public static String getClientIp(String requestId, HttpServletRequest request) {
        String clientIp;
        try {
            String forwardedFor;
            clientIp = request.getRemoteAddr();
            if (clientIp.equals("127.0.0.1")) {
                clientIp = NetworkUtils.getHostIp();
            }
            if ((forwardedFor = request.getHeader("X-Forwarded-For")) != null && !forwardedFor.isEmpty()) {
                clientIp = forwardedFor.split(",")[0].trim();
            }
        }
        catch (Exception e) {
            log.warn("Failed to retrieve client IP for {}. Defaulting to 'Unknown'. Error: {}", (Object)requestId, (Object)LogUtils.exceptionFormat((String)e.getMessage()));
            clientIp = "Unknown";
        }
        return clientIp;
    }
}

