/*
 * Decompiled with CFR 0.152.
 */
package com.sqream.sqloaderService.utils;

import com.sqream.sqloaderService.dto.Params;
import com.sqream.sqloaderService.loaders.LoadRowDataExecuter;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ManagedThreads {
    private static final Logger log = LoggerFactory.getLogger(ManagedThreads.class);
    ExecutorService executor;

    public ManagedThreads(Params params) {
        this.executor = Executors.newFixedThreadPool(params.getThreadCount());
    }

    public Future<?> execute(LoadRowDataExecuter loadRowDataService) {
        return this.executor.submit((Runnable)loadRowDataService);
    }

    public void shutdownManagedThreads() {
        log.info("Shutting down managed threads");
        this.executor.shutdownNow();
        log.debug("Thread pool terminated");
    }
}

