/*
 * Decompiled with CFR 0.152.
 */
package com.sqream.sqloaderService.utils;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class LogUtils {
    private static final Logger log = LoggerFactory.getLogger(LogUtils.class);
    String logFilePath;

    public static String exceptionFormat(String s) {
        if (s != null) {
            return s.replace("\n", "\\n");
        }
        return null;
    }

    public void writeLogHeader(String s_content) {
        int lengthSpaceLeft;
        int lengthMain = 80;
        int lenthPre = 20;
        String s_char = "=";
        StringBuilder lineTop = new StringBuilder();
        StringBuilder lineContent = new StringBuilder();
        String leftChar = ">";
        String rightChar = "<";
        StringBuilder leftChars = new StringBuilder();
        StringBuilder rightChars = new StringBuilder();
        String endWord = "";
        lineTop.append(s_char.repeat(lengthMain));
        if (s_content == null || s_content.isEmpty()) {
            log.info(lineTop.toString());
            return;
        }
        int lengthContent = s_content.length();
        int lengthSpaceRight = lengthSpaceLeft = (lengthMain - lenthPre * 2 - lengthContent) / 2;
        if (lengthContent % 2 != 0) {
            lengthSpaceRight = lengthSpaceLeft + 1;
        }
        for (int i = 0; i < lenthPre; ++i) {
            leftChars.append(leftChar);
            rightChars.append(rightChar);
        }
        lineContent.append((CharSequence)leftChars);
        lineContent.append(" ".repeat(Math.max(0, lengthSpaceLeft)));
        lineContent.append(s_content);
        lineContent.append(" ".repeat(Math.max(0, lengthSpaceRight)));
        lineContent.append((CharSequence)rightChars);
        log.info(lineTop.toString());
        log.info(lineContent.toString());
        log.info(lineTop.toString());
    }

    public String getLogFilePath() {
        return this.logFilePath;
    }
}

