/*
 * Decompiled with CFR 0.152.
 */
package com.sqream.sqloaderService.utils;

import com.sqream.sqloaderService.dto.Params;
import com.sqream.sqloaderService.exceptions.InvalidArgumentException;
import com.sqream.sqloaderService.utils.LogUtils;
import com.sqream.sqloaderService.utils.StrUtils;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.List;
import java.util.Scanner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class FileUtils {
    private static final Logger log = LoggerFactory.getLogger(FileUtils.class);
    @Autowired
    StrUtils strUtils;

    public boolean isFileExist(String filePath) {
        File file = new File(filePath);
        return file.exists();
    }

    public List<String> getFileContent(String filePath, Params params) {
        Scanner myReader;
        ArrayList<String> strings = new ArrayList<String>();
        File file = new File(filePath);
        try {
            myReader = new Scanner(file);
        }
        catch (FileNotFoundException e) {
            throw new InvalidArgumentException(LogUtils.exceptionFormat((String)e.toString()), params);
        }
        while (myReader.hasNextLine()) {
            String data = myReader.nextLine();
            if (data.startsWith("#") || data.startsWith("/") || data.startsWith("-")) continue;
            strings.add(this.strUtils.formatColumnName(data, params.getSourceDbType(), params.getCaseSensitive().booleanValue(), params.getLoadDttmColumnName()));
        }
        myReader.close();
        return strings;
    }
}

