/*
 * Decompiled with CFR 0.152.
 */
package com.sqream.sqloaderService.typemapping;

import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.DataSerializable;
import com.sqream.sqloader.common.enums.DBType;
import com.sqream.sqloaderService.dto.ColumnData;
import com.sqream.sqloaderService.dto.CreationColumnData;
import com.sqream.sqloaderService.typemapping.DbTypeMapping;
import java.io.IOException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class TypeMappingService
implements DataSerializable {
    private static final Logger log = LoggerFactory.getLogger(TypeMappingService.class);
    private static final String DEFAULT_TYPE = "text";
    HashMap<String, List<DbTypeMapping>> dbTypeMappingMap;

    public Timestamp getDefaultTimestamp() {
        return new Timestamp(System.currentTimeMillis());
    }

    private List<DbTypeMapping> getMappingList(DBType srcDbType) {
        String srcDbName = this.getSrcDbName(srcDbType);
        return (List)this.dbTypeMappingMap.get(srcDbName.toLowerCase());
    }

    public DbTypeMapping getDataTypeByName(DBType srcDbType, String columnName, boolean caseSensitive) {
        List dbTypeMappings = this.getMappingList(srcDbType);
        for (DbTypeMapping dbTypeMapping : dbTypeMappings) {
            if (dbTypeMapping.names == null || (!caseSensitive || !dbTypeMapping.names.stream().anyMatch(colName -> colName.equals(columnName.replaceAll("\"", "")))) && (caseSensitive || !dbTypeMapping.names.stream().anyMatch(colName -> colName.equalsIgnoreCase(columnName)))) continue;
            return dbTypeMapping;
        }
        return null;
    }

    public DbTypeMapping getDataType(DBType srcDbType, String columnType) {
        List dbTypeMappings = this.getMappingList(srcDbType);
        for (DbTypeMapping dbTypeMapping : dbTypeMappings) {
            if (dbTypeMapping.names != null || !dbTypeMapping.type.stream().anyMatch(colType -> colType.equalsIgnoreCase(columnType))) continue;
            return dbTypeMapping;
        }
        return null;
    }

    public DbTypeMapping getDataType(DBType srcDbType, String columnType, boolean isPrecision) {
        List dbTypeMappings = this.getMappingList(srcDbType);
        for (DbTypeMapping dbTypeMapping : dbTypeMappings) {
            if (dbTypeMapping.names != null || !dbTypeMapping.type.stream().anyMatch(colType -> colType.equalsIgnoreCase(columnType)) || dbTypeMapping.prec != isPrecision) continue;
            return dbTypeMapping;
        }
        return this.getDataType(srcDbType, columnType);
    }

    public String getSqreamType(DBType srcDbType, ColumnData srcColumnData, boolean caseSensitive) {
        DbTypeMapping dbTypeMapping = null;
        String sourceFullType = this.getSourceType(srcColumnData);
        Object retval = null;
        dbTypeMapping = this.getDataTypeByName(srcDbType, srcColumnData.getColName(), caseSensitive);
        if (dbTypeMapping != null) {
            retval = dbTypeMapping.getSqream();
        }
        if (retval == null && sourceFullType != srcColumnData.getColType() && (dbTypeMapping = this.getDataType(srcDbType, sourceFullType)) != null) {
            retval = dbTypeMapping.getSqream();
        }
        if (dbTypeMapping == null) {
            dbTypeMapping = this.getDataType(srcDbType, srcColumnData.getColType(), srcColumnData.getColPrec() != null);
        }
        if (dbTypeMapping != null && retval == null) {
            if (!dbTypeMapping.isLength()) {
                retval = dbTypeMapping.getSqream();
            } else {
                if (srcDbType == DBType.ORCL && srcColumnData.getColType().equalsIgnoreCase("number") && srcColumnData.getColLen().equals("22")) {
                    if (srcColumnData.getColFrac() == null && srcColumnData.getColPrec() == null) {
                        retval = dbTypeMapping.getSqream();
                    } else if (srcColumnData.getColFrac().equals("0")) {
                        retval = srcColumnData.getColPrec() == null ? "numeric(38," + srcColumnData.getColFrac() + ")" : "numeric(" + srcColumnData.getColPrec() + "," + srcColumnData.getColFrac() + ")";
                    }
                }
                if (retval == null && (dbTypeMapping.isPrec() || srcColumnData.getColType().equals("number"))) {
                    retval = srcColumnData.getColFrac() != null ? (!srcColumnData.getColFrac().equals("0") ? (srcColumnData.isArray() ? dbTypeMapping.getSqream() + "(" + Math.min(Integer.parseInt(srcColumnData.getColPrec()), 38) + "," + srcColumnData.getColFrac() + ")[]" : dbTypeMapping.getSqream() + "(" + Math.min(Integer.parseInt(srcColumnData.getColPrec()), 38) + "," + srcColumnData.getColFrac() + ")") : (srcColumnData.isArray() ? dbTypeMapping.getSqream() + "[]" : dbTypeMapping.getSqream() + "(" + srcColumnData.getColPrec() + ")")) : "bigint";
                } else if (retval == null) {
                    retval = dbTypeMapping.getSqream() + "(" + srcColumnData.getColLen() + ")";
                    if (dbTypeMapping.getSqream().equals(DEFAULT_TYPE) && srcColumnData.getColLen().equals("-1")) {
                        retval = dbTypeMapping.getSqream();
                    }
                }
            }
        }
        if (retval == null) {
            retval = DEFAULT_TYPE;
        }
        if (!srcColumnData.isNullable()) {
            retval = (String)retval + " not null";
        }
        return retval;
    }

    private String getSourceType(ColumnData columnData) {
        StringBuilder colTypeFull = new StringBuilder(columnData.getColType());
        if (columnData.getColPrec() != null) {
            if (columnData.getColFrac() != null && !columnData.getColFrac().equals("0")) {
                colTypeFull.append("(" + columnData.getColPrec() + "," + columnData.getColFrac() + ")");
            } else {
                colTypeFull.append("(" + columnData.getColPrec() + ")");
            }
        } else if (columnData.getColPrec() == null) {
            if (columnData.getColFrac() != null && columnData.getColFrac().equals("0") && columnData.getColType().equalsIgnoreCase("number")) {
                colTypeFull.append("(38,0)");
            }
        } else if (columnData.getColLen() != null) {
            colTypeFull.append("(" + columnData.getColLen() + ")");
        }
        return colTypeFull.toString();
    }

    private String getSrcDbName(DBType srcDbType) {
        if (srcDbType == DBType.ORCL) {
            return "oracle";
        }
        if (srcDbType == DBType.POSTGRES) {
            return "postgresql";
        }
        return srcDbType.toString();
    }

    public String getJavaType(DBType srcDbType, ColumnData srcColumnData, boolean caseSensitive) {
        DbTypeMapping dbTypeMapping = this.getDataTypeByName(srcDbType, srcColumnData.getColName(), caseSensitive);
        if (dbTypeMapping == null) {
            String sourceFullType = this.getSourceType(srcColumnData);
            dbTypeMapping = this.getDataType(srcDbType, sourceFullType);
        }
        if (dbTypeMapping == null) {
            dbTypeMapping = this.getDataType(srcDbType, srcColumnData.getColType(), srcColumnData.getColPrec() != null);
        }
        if (dbTypeMapping == null) {
            return DEFAULT_TYPE;
        }
        return dbTypeMapping.java;
    }

    public List<CreationColumnData> getTargetColumnsType(DBType targetDbType, DBType sourceDbType, List<ColumnData> srcColumnDataList, boolean caseSensitive) {
        if (targetDbType == DBType.SQREAM) {
            ArrayList<CreationColumnData> sqreamColumns = new ArrayList<CreationColumnData>();
            log.info("Columns type mapping");
            for (ColumnData columnData : srcColumnDataList) {
                String colName = columnData.getColName();
                String sourceType = this.getSourceType(columnData);
                String sqreamType = this.getSqreamType(sourceDbType, columnData, caseSensitive);
                String javaType = this.getJavaType(sourceDbType, columnData, caseSensitive);
                log.info("{} {} --> {}", new Object[]{colName, sourceType, sqreamType});
                sqreamColumns.add(new CreationColumnData(colName, sqreamType, javaType, columnData.isNullable()));
            }
            return sqreamColumns;
        }
        return null;
    }

    public void writeData(ObjectDataOutput out) throws IOException {
        out.writeObject((Object)this.dbTypeMappingMap);
    }

    public void readData(ObjectDataInput in) throws IOException {
        this.dbTypeMappingMap = (HashMap)in.readObject();
    }

    public void setDbTypeMappingMap(HashMap<String, List<DbTypeMapping>> dbTypeMappingMap) {
        this.dbTypeMappingMap = dbTypeMappingMap;
    }

    public HashMap<String, List<DbTypeMapping>> getDbTypeMappingMap() {
        return this.dbTypeMappingMap;
    }
}

