/*
 * Decompiled with CFR 0.152.
 */
package com.sqream.sqloaderService.typemapping;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.sqream.sqloaderService.configuration.SQLoaderConfiguration;
import com.sqream.sqloaderService.typemapping.DbTypeMapping;
import com.sqream.sqloaderService.typemapping.TypeMappingPostConstruct;
import jakarta.annotation.PostConstruct;
import java.io.File;
import java.io.IOException;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class TypeMappingPostConstruct {
    private static final Logger log = LoggerFactory.getLogger(TypeMappingPostConstruct.class);
    @Autowired
    ObjectMapper mapper;
    @Autowired
    SQLoaderConfiguration defaultConfig;
    static HashMap<String, List<DbTypeMapping>> dbTypeMappingMap;

    @PostConstruct
    public void init() throws IOException {
        1 typeRef = new /* Unavailable Anonymous Inner Class!! */;
        if (this.defaultConfig.getTypeMappingPath() != null) {
            dbTypeMappingMap = (HashMap)this.mapper.readValue(new File(this.defaultConfig.getTypeMappingPath()), (TypeReference)typeRef);
            File mapFile = Paths.get(this.defaultConfig.getTypeMappingPath(), new String[0]).toFile();
            if (mapFile.isDirectory()) {
                dbTypeMappingMap = (HashMap)this.mapper.readValue(new File(Paths.get(this.defaultConfig.getTypeMappingPath(), this.defaultConfig.getTypeMappingFileName()).toString()), (TypeReference)typeRef);
            }
        } else {
            dbTypeMappingMap = (HashMap)this.mapper.readValue(new File(Paths.get(this.defaultConfig.getConfigDir(), this.defaultConfig.getTypeMappingFileName()).toString()), (TypeReference)typeRef);
        }
        log.info("Parsing sqream-mapping file finished successfully");
    }

    public static HashMap<String, List<DbTypeMapping>> getDbTypeMappingMap() {
        return dbTypeMappingMap;
    }
}

