/*
 * Decompiled with CFR 0.152.
 */
package com.sqream.sqloaderService.service;

import com.hazelcast.cluster.Member;
import com.sqream.sqloader.common.dto.RequestData;
import com.sqream.sqloader.common.enums.LoadType;
import com.sqream.sqloader.common.service.HazelcastService;
import com.sqream.sqloader.common.utils.CommonStrUtils;
import com.sqream.sqloaderService.ParamsValidation;
import com.sqream.sqloaderService.client.CancelResponse;
import com.sqream.sqloaderService.client.KillTask;
import com.sqream.sqloaderService.client.LoadResponse;
import com.sqream.sqloaderService.client.SyncLoadResponse;
import com.sqream.sqloaderService.dbhandler.DbHandlerFactory;
import com.sqream.sqloaderService.dbhandler.SourceDbHandler;
import com.sqream.sqloaderService.dbhandler.SqreamDbHandler;
import com.sqream.sqloaderService.dbhandler.cdc.AbstractCatalogHandler;
import com.sqream.sqloaderService.dto.Params;
import com.sqream.sqloaderService.enums.ExitCode;
import com.sqream.sqloaderService.enums.RequestPhase;
import com.sqream.sqloaderService.enums.RequestStatus;
import com.sqream.sqloaderService.loaders.Loader;
import com.sqream.sqloaderService.loaders.LoaderFactory;
import com.sqream.sqloaderService.logging.LogManager;
import com.sqream.sqloaderService.service.SqloaderHazelcastService;
import com.sqream.sqloaderService.utils.ExitCodeUtils;
import com.sqream.sqloaderService.utils.LogUtils;
import com.sqream.sqloaderService.utils.NetworkUtils;
import jakarta.annotation.PostConstruct;
import jakarta.servlet.http.HttpServletRequest;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.context.event.ApplicationReadyEvent;
import org.springframework.context.event.EventListener;
import org.springframework.scheduling.annotation.Async;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Service;

@Service
public class SqloaderService {
    private static final Logger log = LoggerFactory.getLogger(SqloaderService.class);
    @Autowired
    ParamsValidation paramsValidation;
    @Autowired
    DbHandlerFactory dbHandlerFactory;
    @Autowired
    LoaderFactory loaderFactory;
    AtomicInteger requestCount = new AtomicInteger(1);
    @Autowired
    HazelcastService hazelcastService;
    @Autowired
    SqloaderHazelcastService sqloaderHazelcastService;
    @Value(value="${server.port}")
    String port;
    String instance;

    @EventListener(value={ApplicationReadyEvent.class})
    public void init() {
        this.instance = "http://" + NetworkUtils.getHostIp() + ":" + this.port;
        if (!this.sqloaderHazelcastService.getInstances().containsKey((Object)this.instance) && this.sqloaderHazelcastService.getInstances().get((Object)this.instance) == null) {
            this.sqloaderHazelcastService.getInstances().put((Object)this.instance, new PriorityBlockingQueue());
        }
        log.info("SQLoader Register to {}", (Object)this.instance);
    }

    public LoadResponse load(Params params, HttpServletRequest request) throws Exception {
        HashMap<String, String> response = this.prepareRequest(params, request);
        if (response != null) {
            return LoadResponse.builder().loadResponse((Map)response).build();
        }
        response = new HashMap<String, String>();
        response.put("request_id", params.getRequestId());
        if (params.getClustered().booleanValue()) {
            try {
                this.sqloaderHazelcastService.getBlockingQueue().add((Object)params);
                response.put("status", (String)RequestPhase.IN_QUEUE);
            }
            catch (IllegalStateException e) {
                if (e.getMessage().equals("Queue is full!")) {
                    response.put("status", (String)RequestPhase.IGNORED);
                    log.warn("Request {} has been ignored because the queue is full.", (Object)params.getRequestId());
                }
            }
        } else {
            response.put("status", (String)RequestPhase.LOADING);
            new Thread(() -> this.loadingImpl(params)).start();
        }
        return LoadResponse.builder().loadResponse(response).build();
    }

    public SyncLoadResponse syncLoad(Params params, HttpServletRequest request) {
        Map response = this.prepareRequest(params, request);
        if (response != null) {
            return SyncLoadResponse.builder().syncLoadResponse(response).build();
        }
        response = this.loadingImpl(params);
        return SyncLoadResponse.builder().syncLoadResponse(response).build();
    }

    @PostConstruct
    @Scheduled(fixedRate=250L)
    @Async
    public void loading() throws InterruptedException {
        if (!this.sqloaderHazelcastService.getBlockingQueue().isEmpty()) {
            Params params = (Params)this.sqloaderHazelcastService.getBlockingQueue().take();
            LogManager.init((String)params.getRequestId(), (String)RequestPhase.IN_QUEUE.name());
            if (this.sqloaderHazelcastService.getCancelledRequests().contains((Object)params.getRequestId())) {
                log.info("Finished request - Status: {}, Status code: {}", (Object)RequestStatus.CANCELLED.name(), (Object)ExitCode.CANCELLED);
                this.sqloaderHazelcastService.getCancelledRequests().remove((Object)params.getRequestId());
                return;
            }
            this.sqloaderHazelcastService.enqueueParam(this.instance, params);
            try {
                this.loadingImpl(params);
            }
            finally {
                this.sqloaderHazelcastService.dequeueParam(this.instance, params);
            }
        }
    }

    private String generateRequestId() {
        String serviceInstanceHash = this.hazelcastService.getCluster().getLocalMember().getUuid().toString();
        return "request-" + this.requestCount.getAndIncrement() + "-" + Integer.toHexString(serviceInstanceHash.hashCode());
    }

    public CancelResponse cancelRequest(String requestId) throws Exception {
        log.info("Sent cancel request on {}", (Object)requestId);
        HashMap<String, String> response = new HashMap<String, String>();
        response.put("request_id", requestId);
        this.sqloaderHazelcastService.getCancelledRequests().add((Object)requestId);
        if (this.hazelcastService.getRequests().containsKey((Object)requestId)) {
            RequestData requestData = (RequestData)this.hazelcastService.getRequests().get((Object)requestId);
            Member hzMember = requestData.getHzMember();
            String threadRequestName = requestData.getThreadRequestName();
            Member currentMember = this.hazelcastService.getCluster().getLocalMember();
            if (hzMember.getUuid().equals(currentMember.getUuid())) {
                log.info("interrupted request {}, thread name is {}", (Object)requestId, (Object)threadRequestName);
                new KillTask(threadRequestName).run();
                response.put("status", RequestStatus.CANCELLED.name());
            } else {
                log.info("sent kill request {} to instance {}", (Object)requestId, (Object)requestData.getAcquiredHost());
                this.hazelcastService.executeOnMember((Runnable)new KillTask(threadRequestName), hzMember);
                response.put("status", RequestStatus.CANCELLED.name());
            }
        } else {
            log.info("request in the queue, marked as cancelled");
            response.put("status", "Request still in the queue, request will be removed.");
        }
        return CancelResponse.builder().cancelResponse(response).build();
    }

    public Map<String, Object> prepareRequest(Params params, HttpServletRequest request) {
        params.setRequestId(this.generateRequestId());
        params.setClientIp(NetworkUtils.getClientIp((String)params.getRequestId(), (HttpServletRequest)request));
        try {
            this.paramsValidation.setAndValidateParams(params);
        }
        catch (Exception e) {
            log.error("Request Id {} had an exception during request preparation: {}", (Object)params.getRequestId(), (Object)LogUtils.exceptionFormat((String)e.getMessage()));
            HashMap<String, Object> response = new HashMap<String, Object>();
            response.put("request_id", params.getRequestId());
            response.put("status", ExitCodeUtils.getRealStatus((int)params.getValidationCode()));
            response.put("status_code", params.getValidationCode());
            return response;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, Object> loadingImpl(Params params) {
        HashMap<String, Object> response = new HashMap<String, Object>();
        LogManager.init((String)params.getRequestId(), (String)RequestPhase.PREPARATION.name());
        response.put("request_id", params.getRequestId());
        RequestData existsRequestData = this.isRequestExist(params);
        if (existsRequestData != null) {
            response.put("status", RequestPhase.IGNORED);
            String errorMsg = "Request id " + params.getRequestId() + " has been rejected because a similar request of type FULL is already running on host " + existsRequestData.getAcquiredHost() + ", request id is " + existsRequestData.getRequestId() + ", SQream table name is " + existsRequestData.getSqreamTableNameFull() + ", connection string is " + CommonStrUtils.maskConnectionString((String)existsRequestData.getConnectionStringSqream()) + ", load status is " + existsRequestData.getStatusPhase() + ". Please wait until the existed request is over. You can use getActiveLoads request to get information for all running requests";
            log.error(errorMsg);
            return response;
        }
        String acquireHost = NetworkUtils.getHostIp() + ":" + this.port;
        params.setAcquiredHost(acquireHost);
        RequestData requestData = RequestData.builder().requestId(params.getRequestId()).statusPhase(RequestPhase.PREPARATION.name()).statusCode(Integer.valueOf(ExitCode.FAILED)).summaryRecorded(Boolean.valueOf(false)).finalStatus(ExitCodeUtils.getRealStatus((int)1)).loadStartTime(Long.valueOf(System.currentTimeMillis())).loadFinishTime(Long.valueOf(0L)).elapsedSourceTime(new ArrayList()).elapsedTargetTime(new ArrayList()).totalIngestedRowCount(new AtomicInteger(0)).sqreamTableNameFull(params.getSqreamTableNameFull()).connectionStringSqream(params.getConnectionStringSqream()).loadType(params.getLoadType()).requestedHost(params.getRequestedHost()).acquiredHost(acquireHost).hzMember(this.hazelcastService.getCluster().getLocalMember()).sqreamRequestHash(params.getSqreamRequestHash()).threadRequestName(Thread.currentThread().getName()).build();
        this.hazelcastService.getRequests().put((Object)params.getRequestId(), (Object)requestData);
        log.info("==> Got loading request from source table {}.{} to target table {}", new Object[]{params.getSourceSchema(), params.getSourceTable(), params.getSqreamTableNameFull()});
        log.info(params.toString());
        try (SourceDbHandler sourceDbHandler = this.dbHandlerFactory.createSourceDbHandler(params);
             SqreamDbHandler sqreamDbHandler = this.dbHandlerFactory.createSqreamDbHandler(params);
             AbstractCatalogHandler catalogHandler = this.dbHandlerFactory.createCatalogHandler(sourceDbHandler, sqreamDbHandler, params);){
            this.handleLoad(sourceDbHandler, sqreamDbHandler, catalogHandler, params);
        }
        catch (Exception e) {
            log.error("An error occurred when initializing objects {}", (Object)LogUtils.exceptionFormat((String)e.getMessage()));
        }
        finally {
            requestData = (RequestData)this.hazelcastService.getRequests().get((Object)params.getRequestId());
            this.hazelcastService.getRequests().remove((Object)params.getRequestId());
            response.put("status", requestData.getFinalStatus());
            response.put("status_code", requestData.getStatusCode());
            log.info("Finished request - Status: {}, Status code: {}", response.get("status"), response.get("status_code"));
        }
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleLoad(SourceDbHandler sourceDbHandler, SqreamDbHandler sqreamDbHandler, AbstractCatalogHandler catalogHandler, Params params) throws SQLException {
        Loader loader = null;
        try {
            loader = this.loaderFactory.createLoader(sourceDbHandler, sqreamDbHandler, params, catalogHandler);
            loader.validate();
            loader.init();
            loader.loadToSqream();
        }
        catch (Exception e) {
            try {
                log.error("An error occurred {}", (Object)LogUtils.exceptionFormat((String)e.getMessage()));
            }
            catch (Throwable throwable) {
                this.finalizeSqloader(loader);
                throw throwable;
            }
            this.finalizeSqloader(loader);
        }
        this.finalizeSqloader(loader);
    }

    private void finalizeSqloader(Loader loader) {
        try {
            if (loader != null) {
                loader.finalizeSqloader();
            }
        }
        catch (Exception e) {
            log.error("An error occurred during SQLoader finalization {}", (Object)LogUtils.exceptionFormat((String)e.getMessage()));
        }
        finally {
            loader = null;
        }
    }

    private RequestData isRequestExist(Params params) {
        Collection requests = this.hazelcastService.getRequests().values();
        if (!requests.isEmpty()) {
            for (RequestData request : requests) {
                try {
                    if (!params.getSqreamRequestHash().equals(request.getSqreamRequestHash()) || !params.getLoadType().equals((Object)LoadType.FULL)) continue;
                    return request;
                }
                catch (Exception e) {
                    log.info("error on request {}. error is: {}", (Object)request, (Object)LogUtils.exceptionFormat((String)e.getMessage()));
                }
            }
        }
        return null;
    }
}

