/*
 * Decompiled with CFR 0.152.
 */
package com.sqream.sqloaderService.service;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.actuate.health.Health;
import org.springframework.boot.actuate.health.HealthIndicator;
import org.springframework.http.ResponseEntity;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.web.client.RestTemplate;

public class SqloaderHealthIndicator
implements HealthIndicator {
    private static final Logger log = LoggerFactory.getLogger(SqloaderHealthIndicator.class);
    private final String serviceUrl;
    private final RestTemplate restTemplate;

    public SqloaderHealthIndicator(String serviceUrl, RestTemplate restTemplate) {
        this.serviceUrl = serviceUrl;
        this.restTemplate = restTemplate;
    }

    public Health getHealth(boolean includeDetails) {
        return super.getHealth(includeDetails);
    }

    public Health health() {
        try {
            String healthEndpoint = this.serviceUrl + "/actuator/health";
            ResponseEntity response = this.restTemplate.getForEntity(healthEndpoint, String.class, new Object[0]);
            ObjectMapper mapper = new ObjectMapper();
            JsonNode root = mapper.readTree((String)response.getBody());
            if (root != null && root.get("status").toString().equals("DOWN")) {
                return Health.down().withDetail("Reason", (Object)"Health check failed").build();
            }
            return Health.up().build();
        }
        catch (HttpClientErrorException ex) {
            return Health.down((Exception)((Object)ex)).withDetail("Reason", (Object)"Service is not reachable").build();
        }
        catch (Exception ex) {
            return Health.down((Exception)ex).build();
        }
    }

    public static Health getLoaderHealth(String serviceUrl) {
        SqloaderHealthIndicator healthIndicator = new SqloaderHealthIndicator(serviceUrl, new RestTemplate());
        return healthIndicator.getHealth(false);
    }
}

