/*
 * Decompiled with CFR 0.152.
 */
package com.sqream.sqloaderService.service;

import com.hazelcast.collection.IList;
import com.hazelcast.collection.IQueue;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.map.IMap;
import com.sqream.sqloaderService.dto.Params;
import jakarta.annotation.PostConstruct;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.function.Consumer;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SqloaderHazelcastService {
    @Autowired
    HazelcastInstance hazelcastInstance;
    private IQueue<Params> blockingQueue;
    private IList<String> cancelledRequests;
    private final ConcurrentHashMap<String, Object> keyLocks = new ConcurrentHashMap();

    public IMap<String, PriorityBlockingQueue<Params>> getInstances() {
        return this.hazelcastInstance.getMap("instances");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeQueueOperation(String instanceKey, Consumer<PriorityBlockingQueue<Params>> operation) {
        Object lock;
        Object object = lock = this.keyLocks.computeIfAbsent(instanceKey, k -> new Object());
        synchronized (object) {
            PriorityBlockingQueue queue = (PriorityBlockingQueue)this.getInstances().get((Object)instanceKey);
            operation.accept(queue);
        }
    }

    public void enqueueParam(String instanceKey, Params params) {
        this.executeQueueOperation(instanceKey, queue -> {
            queue.add(params);
            this.getInstances().put((Object)instanceKey, queue);
        });
    }

    public void dequeueParam(String instanceKey, Params params) {
        this.executeQueueOperation(instanceKey, queue -> {
            boolean isExist = queue.remove(params);
            if (isExist) {
                this.getInstances().put((Object)instanceKey, queue);
            }
        });
    }

    @PostConstruct
    public void init() {
        this.blockingQueue = this.hazelcastInstance.getQueue("blockingQueue");
        this.cancelledRequests = this.hazelcastInstance.getList("cancelledList");
    }

    public HazelcastInstance getHazelcastInstance() {
        return this.hazelcastInstance;
    }

    public IQueue<Params> getBlockingQueue() {
        return this.blockingQueue;
    }

    public IList<String> getCancelledRequests() {
        return this.cancelledRequests;
    }

    public ConcurrentHashMap<String, Object> getKeyLocks() {
        return this.keyLocks;
    }
}

