/*
 * Decompiled with CFR 0.152.
 */
package com.sqream.sqloaderService.querycomposer;

import com.sqream.sqloader.common.enums.DBType;
import com.sqream.sqloaderService.dto.ColumnData;
import com.sqream.sqloaderService.dto.PrimaryKeyData;
import com.sqream.sqloaderService.dto.SelectColumnData;
import com.sqream.sqloaderService.querycomposer.AbstractQueryComposer;
import com.sqream.sqloaderService.utils.sqreamutils.SqreamVersionsFactory;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public final class SqreamQueryComposer
extends AbstractQueryComposer {
    @Autowired
    SqreamVersionsFactory sqreamVersionsFactory;

    public SqreamQueryComposer() {
        super(DBType.SQREAM);
    }

    public String composeInsertSummaryRecord(Map<String, String> loadSummaryMap, String loadSummaryTable) {
        StringBuilder columnNames = new StringBuilder();
        StringBuilder columnValues = new StringBuilder();
        int size = loadSummaryMap.entrySet().size();
        int index = 0;
        for (Map.Entry<String, String> entry : loadSummaryMap.entrySet()) {
            columnNames.append(entry.getKey());
            if (index < size - 1) {
                columnNames.append(",");
            }
            if (entry.getValue() == null) {
                columnValues.append((String)null);
            } else if (this.isSummaryColumnTypeIsTimestamp(entry.getKey())) {
                columnValues.append("CAST('").append(entry.getValue()).append("' AS DATETIME)");
            } else {
                columnValues.append("$$").append(entry.getValue()).append("$$");
            }
            if (index < size - 1) {
                columnValues.append(",");
            }
            ++index;
        }
        return String.format("insert into %s (%s) values (%s)", loadSummaryTable, columnNames, columnValues);
    }

    public String composeSelectBetweenRange(SelectColumnData selectColumnData, String selectColumnList) {
        return String.format("SELECT %s FROM (SELECT *, ROW_NUMBER() OVER (ORDER BY %s) AS Num FROM %s) X WHERE x.Num BETWEEN %s AND %s", selectColumnList, selectColumnData.getColumnFoSplit(), selectColumnData.getTableFullName(), selectColumnData.getTableSplitData().getMin(), selectColumnData.getTableSplitData().getMax());
    }

    public String getColumnNameForSelect(String columnName, String loadDttmColumnName) {
        if (columnName.equalsIgnoreCase(loadDttmColumnName)) {
            return "'" + String.valueOf(this.typeMappingService.getDefaultTimestamp()) + "'::datetime as " + loadDttmColumnName;
        }
        return columnName;
    }

    public String composeColumnListQuery(String schemaName, String tableName, List<String> configColumnList, String sqreamVersion) {
        return this.sqreamVersionsFactory.getQuerySyntaxByVersion(sqreamVersion).composeColumnListQuery(this.reformatForTableMetadata(schemaName), this.reformatForTableMetadata(tableName), configColumnList);
    }

    public String composeIsTableExistQuery(String schemaName, String tableName, String sqreamVersion) {
        return this.sqreamVersionsFactory.getQuerySyntaxByVersion(sqreamVersion).isTableExist(this.reformatForTableMetadata(schemaName), this.reformatForTableMetadata(tableName));
    }

    public String composeIsTableExistQuery(String databaseName, String schemaName, String tableName, String sqreamVersion) {
        return this.sqreamVersionsFactory.getQuerySyntaxByVersion(sqreamVersion).isTableExist(databaseName, this.reformatForTableMetadata(schemaName), this.reformatForTableMetadata(tableName));
    }

    public String composeIsViewExistQuery(String schemaName, String tableName, String sqreamVersion) {
        return this.sqreamVersionsFactory.getQuerySyntaxByVersion(sqreamVersion).IsViewExist(this.reformatForTableMetadata(schemaName), this.reformatForTableMetadata(tableName));
    }

    public String composeIsViewExistQuery(String databaseName, String schemaName, String tableName, String sqreamVersion) {
        return this.sqreamVersionsFactory.getQuerySyntaxByVersion(sqreamVersion).IsViewExist(databaseName, this.reformatForTableMetadata(schemaName), this.reformatForTableMetadata(tableName));
    }

    public String composeMetadataQuery(String tableFullName) {
        return "select * from " + tableFullName + " where 1=0";
    }

    public String composeGetViewDdl(String schemaName, String tableName) {
        return "select get_view_ddl('" + schemaName + "." + tableName + "')";
    }

    public String composeSwapTables(String schemaName, String firstTableName, String secondTableName) {
        return "select swap_table_names('" + this.reformatForTableMetadata(schemaName) + "', '" + this.reformatForTableMetadata(firstTableName) + "', '" + this.reformatForTableMetadata(secondTableName) + "')";
    }

    public String composeCleanupChucksQuery(String schemaName, String tableName) {
        return "select cleanup_chunks('" + schemaName.toLowerCase() + "','" + tableName.toLowerCase() + "')";
    }

    public String composeCleanupExtentsQuery(String schemaName, String tableName) {
        return "select cleanup_extents('" + schemaName.toLowerCase() + "','" + tableName.toLowerCase() + "')";
    }

    public String composeSelectAccordingDttmFilter(List<PrimaryKeyData> primaryKeyList, List<ColumnData> columnDataList, String srcTableNameFull, String sourceTableNameCdcFull, String lastDttm, String maxDttm, boolean loadDttm, String loadDttmColumnName) {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public String composeCdcDeleteStatement(List<PrimaryKeyData> primaryKeys, String dmlType, String sqreamTableNameFull, String sqreamTableNameStgFull, String isNullFunction) {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public String composeSelectFromCdcToStg(List<PrimaryKeyData> primaryKeyList, List<ColumnData> columnDataList, String srcTableNameFull, String sourceTableNameCdcFull, String latestDttm, String maxDttm, String loadDttmColumnName) {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public String composeMaxValueQuery(String s_lastValue, String sourceTableNameFull, String incrColumnName, String incrColumnType, String filter) {
        String cmdSelect = "select max(" + incrColumnName + ") from " + sourceTableNameFull + " where (" + filter + ")";
        if (s_lastValue != null) {
            cmdSelect = "select max(" + incrColumnName + ") from " + sourceTableNameFull + " where " + incrColumnName + " >'" + s_lastValue + "' and (" + filter + ")";
        }
        return cmdSelect;
    }

    public String composeInsertTrackingQuery(String trackingTableName, String trackingColumnName, String incrColumnType, String srcDbType, String schemaName, String tableName, String tableFullName, String trackingLastValue, String filter) {
        StringBuilder sb = new StringBuilder();
        sb.append("insert into ");
        sb.append(trackingTableName);
        sb.append(" (db_name,schema_name,table_name,table_name_full,").append(trackingColumnName).append(",filter) values (");
        sb.append("'").append(srcDbType).append("','").append(schemaName).append("','").append(tableName).append("','").append(tableFullName).append("','").append(trackingLastValue).append("','").append(filter).append("')");
        return sb.toString();
    }

    public String compoUpdateTrackingQuery(String cdcTrackingTableName, String trackingColumnName, String trackingValue, String sourceDbName, String srcTableFullName, String incrColumnType) {
        String cmdUpdate = String.format("update %s set %s='%s' where db_name='%s' and table_name_full='%s'", cdcTrackingTableName, trackingColumnName, trackingValue, sourceDbName, srcTableFullName);
        return cmdUpdate;
    }

    public String compoUpdateTrackingQueryIncludeFilter(String cdcTrackingTableName, String trackingColumnName, String trackingValue, String sourceDbName, String srcTableFullName, String incrColumnType, String filter) {
        String cmdUpdate = String.format("update %s set %s='%s', filter='%s' where db_name='%s' and table_name_full='%s'", cdcTrackingTableName, trackingColumnName, trackingValue, filter, sourceDbName, srcTableFullName);
        return cmdUpdate;
    }

    public String compoAlterQueryColumns(Map<String, String> missingKeysMap, String tableName) {
        StringBuilder sb = new StringBuilder("ALTER TABLE ");
        sb.append(tableName).append(' ');
        Iterator<Map.Entry<String, String>> it = missingKeysMap.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<String, String> e = it.next();
            sb.append("ADD COLUMN ").append(e.getKey()).append(' ').append(e.getValue());
            if (!it.hasNext()) continue;
            sb.append(", ");
        }
        sb.append(';');
        return sb.toString();
    }

    public String getIncrementalQueryFilter(String incrColumnName, String incrColumnType, String minVal, String maxVal, String filter) {
        return switch (incrColumnType) {
            case "datetime", "datetime2" -> incrColumnName + " > '" + minVal + "' and " + incrColumnName + " <= '" + maxVal + "' and (" + filter + ")";
            case "timestamp" -> incrColumnName + " > TO_TIMESTAMP('" + minVal + "', 'YYYY-MM-DD HH24:MI:SS.FF') and " + incrColumnName + " <= TO_TIMESTAMP('" + maxVal + "', 'YYYY-MM-DD HH24:MI:SS.FF') and (" + filter + ")";
            case "int" -> incrColumnName + " > " + minVal + " and " + incrColumnName + " <= " + maxVal + " and (" + filter + ")";
            default -> "";
        };
    }

    public String getColumnNameForSelect(String alias, ColumnData columnData, String loadDttmColumnName) {
        String columnName = columnData.getColName();
        if (columnName.equalsIgnoreCase(loadDttmColumnName)) {
            return "'" + String.valueOf(this.typeMappingService.getDefaultTimestamp()) + "'::datetime as " + loadDttmColumnName;
        }
        return columnData.getColName();
    }
}

