/*
 * Decompiled with CFR 0.152.
 */
package com.sqream.sqloaderService.querycomposer;

import com.sqream.sqloader.common.enums.DBType;
import com.sqream.sqloaderService.dto.ColumnData;
import com.sqream.sqloaderService.dto.PrimaryKeyData;
import com.sqream.sqloaderService.dto.SelectColumnData;
import com.sqream.sqloaderService.querycomposer.AbstractQueryComposer;
import java.util.List;
import java.util.Map;
import org.springframework.stereotype.Component;

@Component
public final class SapQueryComposer
extends AbstractQueryComposer {
    public SapQueryComposer() {
        super(DBType.SAP);
    }

    public String composeInsertSummaryRecord(Map<String, String> loadSummaryMap, String loadSummaryTable) {
        StringBuilder columnNames = new StringBuilder();
        StringBuilder columnValues = new StringBuilder();
        int size = loadSummaryMap.entrySet().size();
        int index = 0;
        for (Map.Entry<String, String> entry : loadSummaryMap.entrySet()) {
            columnNames.append(entry.getKey());
            if (index < size - 1) {
                columnNames.append(",");
            }
            if (entry.getValue() == null) {
                columnValues.append((String)null);
            } else if (this.isSummaryColumnTypeIsTimestamp(entry.getKey())) {
                columnValues.append("TIMESTAMP '").append(entry.getValue()).append("'");
            } else {
                columnValues.append("'").append(entry.getValue()).append("'");
            }
            if (index < size - 1) {
                columnValues.append(",");
            }
            ++index;
        }
        return String.format("insert into %s (%s) values (%s)", loadSummaryTable, columnNames, columnValues);
    }

    public String composeColumnListQuery(String schemaName, String tableName, List<String> configColumnList, String sqreamVersion) {
        String formattedSchemaName = this.reformatForTableMetadata(schemaName);
        String formattedTableName = this.reformatForTableMetadata(tableName);
        StringBuilder sb = new StringBuilder();
        sb.append("select column_name as col_name,data_type_name as col_type,length as col_length, length as col_prec, scale as col_frac, is_nullable as is_nullable from sys.table_columns where schema_name='%s' and table_name='%s' ");
        if (configColumnList != null) {
            sb.append(" and column_name in (");
            for (int i = 0; i < configColumnList.size(); ++i) {
                sb.append("'");
                sb.append(configColumnList.get(i));
                sb.append("'");
                if (i >= configColumnList.size() - 1) continue;
                sb.append(", ");
            }
            sb.append(")");
        }
        sb.append(" order by position");
        return String.format(sb.toString(), formattedSchemaName, formattedTableName, configColumnList);
    }

    public String composeSelectBetweenRange(SelectColumnData selectColumnData, String selectColumnList) {
        return String.format("SELECT %s FROM (SELECT *, ROW_NUMBER() OVER (ORDER BY %s) AS Num FROM %s) X WHERE x.Num BETWEEN %s AND %s", selectColumnList, selectColumnData.getColumnFoSplit(), selectColumnData.getTableFullName(), selectColumnData.getTableSplitData().getMin(), selectColumnData.getTableSplitData().getMax());
    }

    public String getColumnNameForSelect(String columnName, String loadDttmColumnName) {
        if (columnName.equalsIgnoreCase(loadDttmColumnName)) {
            return "TO_TIMESTAMP('" + String.valueOf(this.typeMappingService.getDefaultTimestamp()) + "', 'YYYY-MM-DD HH24:MI:SS.FF3') as " + loadDttmColumnName;
        }
        return columnName;
    }

    public String composeIsTableExistQuery(String schemaName, String tableName, String sqreamVersion) {
        String formattedSchemaName = this.reformatForTableMetadata(schemaName);
        String formattedTableName = this.reformatForTableMetadata(tableName);
        return "SELECT COUNT(*) FROM SYS.TABLES WHERE SCHEMA_NAME = '" + formattedSchemaName + "' AND TABLE_NAME = '" + formattedTableName + "'";
    }

    public String composeIsViewExistQuery(String schemaName, String tableName, String sqreamVersion) {
        String formattedSchemaName = this.reformatForTableMetadata(schemaName);
        String formattedTableName = this.reformatForTableMetadata(tableName);
        return "SELECT COUNT(*) FROM SYS.VIEWS WHERE SCHEMA_NAME = '" + formattedSchemaName + "' AND VIEW_NAME = '" + formattedTableName + "'";
    }

    public String composeSelectAccordingDttmFilter(List<PrimaryKeyData> primaryKeyList, List<ColumnData> columnDataList, String srcTableNameFull, String sourceTableNameCdcFull, String lastDttm, String maxDttm, boolean loadDttm, String loadDttmColumnName) {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public String composeCdcDeleteStatement(List<PrimaryKeyData> primaryKeys, String dmlType, String sqreamTableNameFull, String sqreamTableNameStgFull, String isNullFunction) {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public String composeSelectFromCdcToStg(List<PrimaryKeyData> primaryKeyList, List<ColumnData> columnDataList, String srcTableNameFull, String sourceTableNameCdcFull, String latestDttm, String maxDttm, String loadDttmColumnName) {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public String composeSelectFromIncQuery(String srcTableName, String incColumnName, String incrColumnType, List<ColumnData> columnDataList, String minVal, String maxVal, boolean rowid, boolean loadDttm, String loadDttmColumnName, String filter) {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public String compoAlterQueryColumns(Map<String, String> missingKeysMap, String tableName) {
        throw new UnsupportedOperationException("Not implemented yet");
    }
}

