/*
 * Decompiled with CFR 0.152.
 */
package com.sqream.sqloaderService.querycomposer;

import com.sqream.sqloader.common.enums.DBType;
import com.sqream.sqloaderService.dto.ColumnData;
import com.sqream.sqloaderService.dto.PrimaryKeyData;
import com.sqream.sqloaderService.dto.SelectColumnData;
import com.sqream.sqloaderService.querycomposer.AbstractQueryComposer;
import java.util.List;
import java.util.Map;
import org.springframework.stereotype.Component;

@Component
public final class PostgresQueryComposer
extends AbstractQueryComposer {
    public PostgresQueryComposer() {
        super(DBType.POSTGRES);
    }

    public String composeColumnListQuery(String schemaName, String tableName, List<String> configColumnList, String sqreamVersion) {
        String formattedSchemaName = this.reformatForTableMetadata(schemaName);
        String formattedTableName = this.reformatForTableMetadata(tableName);
        StringBuilder sb = new StringBuilder();
        sb.append("SELECT COLUMN_NAME as col_name, udt_name as col_type, CHARACTER_MAXIMUM_LENGTH as col_length, NUMERIC_PRECISION col_prec, NUMERIC_SCALE as col_frac, is_nullable FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_SCHEMA ='%s' and TABLE_NAME = '%s' ");
        if (configColumnList != null) {
            sb.append(" and column_name in (");
            for (int i = 0; i < configColumnList.size(); ++i) {
                sb.append("'");
                sb.append(configColumnList.get(i));
                sb.append("'");
                if (i >= configColumnList.size() - 1) continue;
                sb.append(", ");
            }
            sb.append(")");
        }
        sb.append(" ORDER BY ORDINAL_POSITION ");
        return String.format(sb.toString(), formattedSchemaName, formattedTableName);
    }

    public String composeSelectBetweenRange(SelectColumnData selectColumnData, String selectColumnList) {
        return String.format("SELECT %s FROM (SELECT *, ROW_NUMBER() OVER (ORDER BY %s) AS Num FROM %s) X WHERE x.Num BETWEEN %s AND %s", selectColumnList, selectColumnData.getColumnFoSplit(), selectColumnData.getTableFullName(), selectColumnData.getTableSplitData().getMin(), selectColumnData.getTableSplitData().getMax());
    }

    public String getColumnNameForSelect(String columnName, String loadDttmColumnName) {
        if (columnName.equalsIgnoreCase(loadDttmColumnName)) {
            return "timestamp '" + String.valueOf(this.typeMappingService.getDefaultTimestamp()) + "' as " + loadDttmColumnName;
        }
        return columnName;
    }

    public String composeIsTableExistQuery(String schemaName, String tableName, String sqreamVersion) {
        return "SELECT COUNT(*) FROM information_schema.tables WHERE table_name = '" + this.reformatForTableMetadata(tableName) + "' AND table_schema='" + this.reformatForTableMetadata(schemaName) + "'";
    }

    public String composeIsViewExistQuery(String schemaName, String tableName, String sqreamVersion) {
        return "SELECT COUNT(*) FROM information_schema.views WHERE table_name = '" + this.reformatForTableMetadata(tableName) + "' AND table_schema='" + this.reformatForTableMetadata(schemaName) + "'";
    }

    public String getColumnNameForSelect(String alias, ColumnData columnData, String loadDttmColumnName) {
        String columnWithAlias;
        String columnName = columnData.getColName();
        String string = columnWithAlias = alias == null ? columnName : alias + "." + columnName;
        if (columnData.getColAlias() != null && columnName.equalsIgnoreCase("updated_dttm")) {
            return columnWithAlias + " as PGSQL_UPDATED_DTTM";
        }
        if (columnName.equalsIgnoreCase(loadDttmColumnName)) {
            return "TO_TIMESTAMP('" + String.valueOf(this.typeMappingService.getDefaultTimestamp()) + "', 'YYYY-MM-DD HH24:MI:SS.US') as " + loadDttmColumnName;
        }
        return columnWithAlias;
    }

    public String composeSelectAccordingDttmFilter(List<PrimaryKeyData> primaryKeyList, List<ColumnData> columnDataList, String srcTableNameFull, String sourceTableNameCdcFull, String lastDttm, String maxDttm, boolean loadDttm, String loadDttmColumnName) {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public String composeCdcDeleteStatement(List<PrimaryKeyData> primaryKeys, String dmlType, String sqreamTableNameFull, String sqreamTableNameStgFull, String isNullFunction) {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public String composeSelectFromCdcToStg(List<PrimaryKeyData> primaryKeyList, List<ColumnData> columnDataList, String srcTableNameFull, String sourceTableNameCdcFull, String latestDttm, String maxDttm, String loadDttmColumnName) {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public String composeMaxValueQuery(String s_lastValue, String sourceTableNameFull, String incrColumnName, String incrColumnType, String filter) {
        String cmdSelect = "select max(" + incrColumnName + ") from " + sourceTableNameFull + "where (" + filter + ")";
        if (s_lastValue != null) {
            cmdSelect = "select max(" + incrColumnName + ") from " + sourceTableNameFull + " where " + incrColumnName + " >'" + s_lastValue + "' and (" + filter + ")";
            if (incrColumnType.equals("timestamp")) {
                cmdSelect = "select max(" + incrColumnName + ") from " + sourceTableNameFull + " where " + incrColumnName + " > '" + s_lastValue + "' and (" + filter + ")";
            } else if (incrColumnType.equals("datetime")) {
                cmdSelect = "select max(" + incrColumnName + ") from " + sourceTableNameFull + " where " + incrColumnName + " > '" + s_lastValue + "' and (" + filter + ")";
            }
        } else if (incrColumnType.equals("timestamp")) {
            cmdSelect = "select max(" + incrColumnName + ") from " + sourceTableNameFull + "where (" + filter + ")";
        } else if (incrColumnType.equals("datetime")) {
            cmdSelect = "select max(" + incrColumnName + ") from " + sourceTableNameFull + "where (" + filter + ")";
        }
        return cmdSelect;
    }

    public String composeLastValueFromTracking(String trackColumnName, String cdcTrackingTable, String sourceDbName, String sourceTableNameFull, String incrColumnType) {
        return "select " + trackColumnName + " from " + cdcTrackingTable + " where db_name='" + sourceDbName + "' and table_name_full='" + sourceTableNameFull + "'";
    }

    public String compoUpdateTrackingQuery(String cdcTrackingTableName, String trackingColumnName, String trackingValue, String sourceDbName, String srcTableFullName, String incrColumnType) {
        return String.format("update %s set %s='%s' where db_name='%s' and table_name_full='%s'", cdcTrackingTableName, trackingColumnName, trackingValue, sourceDbName, srcTableFullName);
    }

    public String compoUpdateTrackingQueryIncludeFilter(String cdcTrackingTableName, String trackingColumnName, String trackingValue, String sourceDbName, String srcTableFullName, String incrColumnType, String filter) {
        return String.format("update %s set %s='%s', filter='%s' where db_name='%s' and table_name_full='%s'", cdcTrackingTableName, trackingColumnName, trackingValue, filter, sourceDbName, srcTableFullName);
    }

    public String composeInsertTrackingQuery(String trackingTableName, String trackingColumnName, String incrColumnType, String srcDbType, String schemaName, String tableName, String tableFullName, String trackingLastValue, String filter) {
        return "insert into " + trackingTableName + " (db_name,schema_name,table_name,table_name_full," + trackingColumnName + ", filter) values ('" + srcDbType + "','" + schemaName + "','" + tableName + "','" + tableFullName + "','" + trackingLastValue + "','" + filter + "')";
    }

    public String getIncrementalQueryFilter(String incrColumnName, String incrColumnType, String minVal, String maxVal, String filter) {
        return incrColumnName + " > '" + minVal + "' and " + incrColumnName + " <= '" + maxVal + "' and (" + filter + ")";
    }

    public String compoAlterQueryColumns(Map<String, String> missingKeysMap, String tableName) {
        throw new UnsupportedOperationException("Not implemented yet");
    }
}

