/*
 * Decompiled with CFR 0.152.
 */
package com.sqream.sqloaderService.querycomposer;

import com.sqream.sqloader.common.enums.DBType;
import com.sqream.sqloaderService.dto.ColumnData;
import com.sqream.sqloaderService.dto.PrimaryKeyData;
import com.sqream.sqloaderService.dto.SelectColumnData;
import com.sqream.sqloaderService.querycomposer.AbstractQueryComposer;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.stereotype.Component;

@Component
public final class OracleQueryComposer
extends AbstractQueryComposer {
    private static final String catalogTable4Columns = "all_tab_columns";
    private static final String catalogTable4Partitions = "all_tab_partitions";

    public OracleQueryComposer() {
        super(DBType.ORCL);
    }

    public String composeInsertSummaryRecord(Map<String, String> loadSummaryMap, String loadSummaryTable) {
        StringBuilder columnNames = new StringBuilder();
        StringBuilder columnValues = new StringBuilder();
        int size = loadSummaryMap.entrySet().size();
        int index = 0;
        for (Map.Entry<String, String> entry : loadSummaryMap.entrySet()) {
            columnNames.append(entry.getKey());
            if (index < size - 1) {
                columnNames.append(",");
            }
            if (entry.getValue() == null) {
                columnValues.append((String)null);
            } else if (this.isSummaryColumnTypeIsTimestamp(entry.getKey())) {
                columnValues.append("TO_TIMESTAMP('").append(entry.getValue()).append("', 'YYYY-MM-DD HH24:MI:SS.FF')");
            } else {
                columnValues.append("q'$").append(entry.getValue()).append("$'");
            }
            if (index < size - 1) {
                columnValues.append(",");
            }
            ++index;
        }
        return "insert into " + loadSummaryTable + "(" + String.valueOf(columnNames) + ") values (" + String.valueOf(columnValues) + ")";
    }

    public String composeRegularSelect(SelectColumnData selectColumnData, String selectColumnList) {
        StringBuilder selectQueryBuilder = new StringBuilder();
        selectQueryBuilder.append(String.format("select %s from %s where %s", selectColumnList, selectColumnData.getTableFullName(), selectColumnData.getFilter()));
        if (selectColumnData.getLimit() > 0) {
            selectQueryBuilder.append(" and rownum <= ").append(selectColumnData.getLimit());
        }
        return selectQueryBuilder.toString();
    }

    public String composeCountQuery(String tableFullName, String filter) {
        return "SELECT COUNT(*) FROM " + tableFullName + " WHERE " + filter;
    }

    public String composePartitionListQuery(String schemaName, String tableName) {
        return "select PARTITION_NAME from all_tab_partitions where TABLE_OWNER = upper('" + schemaName + "') and TABLE_NAME = upper('" + tableName + "') order by PARTITION_NAME";
    }

    public String composeColumnListQuery(String schemaName, String tableName, List<String> configColumnList, String sqreamVersion) {
        String formattedSchemaName = schemaName.replace("\"", "");
        String formattedTableName = tableName.replace("\"", "");
        StringBuilder stb = new StringBuilder();
        stb.append("select column_name as col_name,data_type as col_type,data_length as col_length, data_precision as col_prec, data_scale as col_frac, nullable as is_nullable from all_tab_columns where owner='%s' and table_name='%s'");
        if (configColumnList != null) {
            stb.append(" and column_name in (");
            for (int i = 0; i < configColumnList.size(); ++i) {
                stb.append("'");
                stb.append(configColumnList.get(i));
                stb.append("'");
                if (i >= configColumnList.size() - 1) continue;
                stb.append(", ");
            }
            stb.append(")");
        }
        stb.append(" order by column_id");
        String sqlString = stb.toString();
        return String.format(sqlString, formattedSchemaName, formattedTableName);
    }

    public String composeGetMinMaxRowsQuery(int threadCount, String schemaName, String tableName) {
        String queryGetMinMaxRows = "select sys.dbms_rowid.rowid_create(1, d.oid, c.fid1, c.bid1, 0) as MIN_ROWID, sys.dbms_rowid.rowid_create(1, d.oid, c.fid2, c.bid2, 9999) as MAX_ROWID  from   (     select       distinct b.rn,       first_value(a.fid) over (         partition by b.rn         order by           a.fid,           a.bid rows between unbounded preceding           and unbounded following       ) fid1,       last_value(a.fid) over (         partition by b.rn         order by           a.fid,           a.bid rows between unbounded preceding           and unbounded following       ) fid2,       first_value(         decode(           sign(range2 - range1),           1,           a.bid +((b.rn - a.range1) * a.chunks1),           a.bid         )       ) over (         partition by b.rn         order by           a.fid,           a.bid rows between unbounded preceding           and unbounded following       ) bid1,       last_value(         decode(           sign(range2 - range1),           1,           a.bid +((b.rn - a.range1 + 1) * a.chunks1) -1,           (a.bid + a.blocks -1)         )       ) over (         partition by b.rn         order by           a.fid,           a.bid rows between unbounded preceding           and unbounded following       ) bid2     from       (         select           fid,           bid,           blocks,           chunks1,           trunc((sum2 - blocks + 1 -0.1) / chunks1) range1,           trunc((sum2 -0.1) / chunks1) range2         from           (             select               relative_fno fid,               block_id bid,               blocks,               sum(bytes) over () sum1,               trunc((sum(bytes) over ()) / %d) chunks1,               sum(bytes) over (                 order by                   relative_fno,                   block_id               ) sum2             from               dba_extents             where               segment_name = upper('%s')               and owner = upper('%s')           )         where           sum1 > %d       ) a,       (         select           rownum -1 rn         from           dual connect by level <= %d       ) b     where       b.rn between a.range1       and a.range2   ) c,   (     select       max(data_object_id) oid     from       dba_objects     where       object_name = upper('%s')       and owner = upper('%s')       and data_object_id is not null   ) d";
        return String.format(queryGetMinMaxRows, threadCount, tableName, schemaName, threadCount, threadCount, tableName, schemaName);
    }

    public String composeSelectBetweenRange(SelectColumnData selectColumnData, String selectColumnList) {
        StringBuilder selectQueryBuilder = new StringBuilder();
        selectQueryBuilder.append(String.format("select %s from %s where rowid between '%s' and '%s' ", selectColumnList, selectColumnData.getTableFullName(), selectColumnData.getTableSplitData().getMin(), selectColumnData.getTableSplitData().getMax()));
        if (selectColumnData.getLimit() > 0) {
            selectQueryBuilder.append("and rownum <= ").append(selectColumnData.getLimit());
        }
        selectQueryBuilder.append(" and ").append(selectColumnData.getFilter());
        return selectQueryBuilder.toString();
    }

    public String composeSelectPerPartition(SelectColumnData selectColumnData, String selectColumnList) {
        StringBuilder selectQueryBuilder = new StringBuilder();
        selectQueryBuilder.append(String.format("select %s from %s partition (\"%s\") where %s ", selectColumnList, selectColumnData.getTableFullName(), selectColumnData.getPartitionName(), selectColumnData.getFilter()));
        if (selectColumnData.getLimit() > 0) {
            selectQueryBuilder.append("and rownum <= ").append(selectColumnData.getLimit());
        }
        return selectQueryBuilder.toString();
    }

    public String getColumnNameForSelect(String columnName, String loadDttmColumnName) {
        if (columnName.equalsIgnoreCase("ora_row_id")) {
            return "RAWTOHEX(rowid) as ORA_ROW_ID";
        }
        if (columnName.equalsIgnoreCase(loadDttmColumnName)) {
            return "TO_TIMESTAMP('" + String.valueOf(this.typeMappingService.getDefaultTimestamp()) + "', 'YYYY-MM-DD HH24:MI:SS.FF') as " + loadDttmColumnName;
        }
        return columnName;
    }

    public String composeIsTableExistQuery(String schemaName, String tableName, String sqreamVersion) {
        return "SELECT COUNT(*) FROM all_tables WHERE table_name = '" + tableName.replace("\"", "") + "' AND owner='" + schemaName.replace("\"", "") + "'";
    }

    public String composeIsViewExistQuery(String schemaName, String tableName, String sqreamVersion) {
        return "SELECT COUNT(*) FROM all_views WHERE view_name = '" + tableName.replace("\"", "") + "' AND owner='" + schemaName.replace("\"", "") + "'";
    }

    public String getColumnNameForSelect(String alias, ColumnData columnData, String loadDttmColumnName) {
        String columnWithAlias;
        String columnName = columnData.getColName();
        String string = columnWithAlias = alias == null ? columnName : alias + "." + columnName;
        if (columnData.getColAlias() != null) {
            if (columnName.equalsIgnoreCase("type")) {
                return columnWithAlias + " as ORA_DML_TYPE";
            }
            if (columnName.equalsIgnoreCase("updated_dttm")) {
                return columnWithAlias + " as ORA_UPDATED_DTTM";
            }
            if (columnName.equalsIgnoreCase("rowid") || columnName.equalsIgnoreCase("row_id")) {
                Object rowIdWithAlias = alias == null ? "rowid" : alias + ".rowid";
                return "RAWTOHEX(" + (String)rowIdWithAlias + ") as ORA_ROW_ID";
            }
        }
        if (columnName.equalsIgnoreCase(loadDttmColumnName)) {
            return "TO_TIMESTAMP('" + String.valueOf(this.typeMappingService.getDefaultTimestamp()) + "', 'YYYY-MM-DD HH24:MI:SS.FF') as " + loadDttmColumnName;
        }
        if (columnData.getColType().equalsIgnoreCase("raw") || columnData.getColType().equalsIgnoreCase("rowid") || columnData.getColType().equalsIgnoreCase("urowid")) {
            return "RAWTOHEX(" + columnName + ") AS " + columnName;
        }
        return columnWithAlias;
    }

    public String composeInsertMaxDttmQuery(String cdcTrackingTable, DBType catalogDbType, String srcDbName, String schemaName, String tableName, String srcTableFullName, String maxUpdatedDttm) {
        return String.format("INSERT INTO %s (db_name, schema_name, table_name, table_name_full, last_updated_dttm) VALUES ('%s', '%s', '%s', '%s', TO_DATE('%s', 'YYYY-MM-DD HH24:MI:SS'))", cdcTrackingTable, srcDbName, schemaName, tableName, srcTableFullName, maxUpdatedDttm);
    }

    public String composeUpdateLastDttmQuery(String cdcTrackingTableName, String maxUpdatedDttm, DBType catalogDbType, String srcDbName, String srcTableFullName) {
        return String.format("UPDATE %s SET last_updated_dttm=TO_DATE('%s', 'YYYY-MM-DD HH24:MI:SS') WHERE db_name='%s' AND table_name_full='%s'", cdcTrackingTableName, maxUpdatedDttm, srcDbName, srcTableFullName);
    }

    public String composeSelectAccordingDttmFilter(List<PrimaryKeyData> primaryKeyList, List<ColumnData> columnDataList, String srcTableNameFull, String sourceTableNameCdcFull, String lastDttm, String maxDttm, boolean loadDttm, String loadDttmColumnName) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getSelectListString(columnDataList, loadDttmColumnName));
        sb.append(" from ( SELECT ctc.*,ct.ROWID AS X FROM ( select * from ");
        sb.append(sourceTableNameCdcFull);
        sb.append(" WHERE TYPE='D'");
        sb.append(" and UPDATED_DTTM > TO_DATE('").append(lastDttm).append("', 'YYYY-MM-DD HH24:MI:SS')");
        sb.append(" and UPDATED_DTTM <= TO_DATE('").append(maxDttm).append("', 'YYYY-MM-DD HH24:MI:SS')");
        sb.append(") ctc left outer join ").append(srcTableNameFull).append(" ct ON ");
        String joinKeys = this.getCdcJoinStatement4PrimaryKeys(primaryKeyList, "ctc", "ct", "NVL");
        sb.append(joinKeys);
        sb.append(") A WHERE X is null ");
        return sb.toString();
    }

    public String composeCdcDeleteStatement(List<PrimaryKeyData> primaryKeys, String dmlType, String sqreamTableNameFull, String sqreamTableNameStgFull, String isNullFunction) {
        String s_joinKeys = this.getCdcJoinStatement4PrimaryKeys(primaryKeys, "T", "S", isNullFunction);
        String whereClause = dmlType.equals("IU") ? String.format(" WHERE %s AND S.ora_dml_type in ('U','I')", s_joinKeys) : String.format(" WHERE %s AND S.ora_dml_type='%s'", s_joinKeys, dmlType);
        return String.format("delete FROM %s T where EXISTS (SELECT 1 FROM %s S %s)", sqreamTableNameFull, sqreamTableNameStgFull, whereClause);
    }

    public String composeSelectFromCdcToStg(List<PrimaryKeyData> primaryKeyList, List<ColumnData> columnDataList, String srcTableNameFull, String sourceTableNameCdcFull, String latestDttm, String maxDttm, String loadDttmColumnName) {
        String aliasSource = "c";
        String aliasTracking = "t";
        String s_joinKeys = this.getCdcJoinStatement4PrimaryKeys(primaryKeyList, aliasTracking, aliasSource, "NVL");
        String primaryKeys = primaryKeyList.stream().map(PrimaryKeyData::getColumnName).collect(Collectors.joining(", "));
        StringBuilder sb = new StringBuilder();
        sb.append("SELECT ");
        for (int i = 0; i < columnDataList.size(); ++i) {
            String columnNameForSelect = columnDataList.get(i).getColName().equalsIgnoreCase("type") || columnDataList.get(i).getColName().equalsIgnoreCase("updated_dttm") ? this.getColumnNameForSelect(aliasSource, columnDataList.get(i), loadDttmColumnName) : this.getColumnNameForSelect(aliasTracking, columnDataList.get(i), loadDttmColumnName);
            sb.append(columnNameForSelect);
            if (i >= columnDataList.size() - 1) continue;
            sb.append(",");
        }
        sb.append(" FROM ").append(srcTableNameFull).append(" ").append(aliasTracking).append(",");
        sb.append("(SELECT ").append(primaryKeys).append(",TYPE,MAX(UPDATED_DTTM) AS UPDATED_DTTM FROM ").append(sourceTableNameCdcFull).append(" ");
        sb.append(" WHERE UPDATED_DTTM > TO_DATE('").append(latestDttm).append("', 'YYYY-MM-DD HH24:MI:SS') ");
        sb.append(" AND UPDATED_DTTM <= TO_DATE('").append(maxDttm).append("', 'YYYY-MM-DD HH24:MI:SS') AND TYPE IN ('I','U')");
        sb.append(" GROUP BY ").append(primaryKeys).append(",TYPE) ").append(aliasSource);
        sb.append(" WHERE ").append(s_joinKeys);
        return sb.toString();
    }

    public String compoAlterQueryColumns(Map<String, String> missingKeysMap, String tableName) {
        throw new UnsupportedOperationException("Not implemented yet");
    }
}

