/*
 * Decompiled with CFR 0.152.
 */
package com.sqream.sqloaderService.querycomposer;

import com.sqream.sqloader.common.enums.DBType;
import com.sqream.sqloaderService.configuration.BeanUtil;
import com.sqream.sqloaderService.enums.ExitCode;
import com.sqream.sqloaderService.exceptions.SqloadInitException;
import com.sqream.sqloaderService.querycomposer.AbstractQueryComposer;
import com.sqream.sqloaderService.querycomposer.MssqlQueryComposer;
import com.sqream.sqloaderService.querycomposer.OracleQueryComposer;
import com.sqream.sqloaderService.querycomposer.PostgresQueryComposer;
import com.sqream.sqloaderService.querycomposer.SapQueryComposer;
import com.sqream.sqloaderService.querycomposer.SqreamQueryComposer;
import com.sqream.sqloaderService.querycomposer.SybaseQueryComposer;
import com.sqream.sqloaderService.querycomposer.TeradataQueryComposer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class CatalogQueryComposerFactory {
    private static final Logger log = LoggerFactory.getLogger(CatalogQueryComposerFactory.class);

    public AbstractQueryComposer getCatalogQueryComposer(DBType catalogDbType, String requestId) throws SqloadInitException {
        if (catalogDbType == DBType.ORCL) {
            return (AbstractQueryComposer)BeanUtil.getBean(OracleQueryComposer.class);
        }
        if (catalogDbType == DBType.POSTGRES) {
            return (AbstractQueryComposer)BeanUtil.getBean(PostgresQueryComposer.class);
        }
        if (catalogDbType == DBType.MSSQL) {
            return (AbstractQueryComposer)BeanUtil.getBean(MssqlQueryComposer.class);
        }
        if (catalogDbType == DBType.SAP) {
            return (AbstractQueryComposer)BeanUtil.getBean(SapQueryComposer.class);
        }
        if (catalogDbType == DBType.TERADATA) {
            return (AbstractQueryComposer)BeanUtil.getBean(TeradataQueryComposer.class);
        }
        if (catalogDbType == DBType.SYBASE) {
            return (AbstractQueryComposer)BeanUtil.getBean(SybaseQueryComposer.class);
        }
        if (catalogDbType == DBType.SQREAM) {
            return (AbstractQueryComposer)BeanUtil.getBean(SqreamQueryComposer.class);
        }
        throw new SqloadInitException("Catalog DB is not supported. The supported Catalog DB are: {SQREAM, ORACLE, POSTGRES, MSSQL, SAP, TERADATA, SYBASE}", ExitCode.NOT_SUPPORTED_DB, requestId);
    }
}

