/*
 * Decompiled with CFR 0.152.
 */
package com.sqream.sqloaderService.querycomposer;

import com.sqream.sqloader.common.enums.DBType;
import com.sqream.sqloaderService.dto.ColumnData;
import com.sqream.sqloaderService.dto.CreationColumnData;
import com.sqream.sqloaderService.dto.PrimaryKeyData;
import com.sqream.sqloaderService.dto.SelectColumnData;
import com.sqream.sqloaderService.querycomposer.CdcQueryComposer;
import com.sqream.sqloaderService.querycomposer.IncQueryComposer;
import com.sqream.sqloaderService.querycomposer.StdQueryComposer;
import com.sqream.sqloaderService.typemapping.TypeMappingService;
import com.sqream.sqloaderService.utils.StrUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class AbstractQueryComposer
implements StdQueryComposer,
CdcQueryComposer,
IncQueryComposer {
    private static final Logger log = LoggerFactory.getLogger(AbstractQueryComposer.class);
    @Autowired
    public StrUtils strUtils;
    @Autowired
    TypeMappingService typeMappingService;
    protected final DBType dbType;

    protected AbstractQueryComposer(DBType dbType) {
        this.dbType = dbType;
    }

    public static String composeIsCatalogTableQuery(String tableName, List<String> columnList, String filter) {
        StringBuilder sb = new StringBuilder();
        sb.append("select ");
        if (columnList == null || columnList.isEmpty()) {
            sb.append("*");
        } else {
            for (int i = 0; i < columnList.size(); ++i) {
                sb.append(columnList.get(i));
                if (i >= columnList.size() - 1) continue;
                sb.append(",");
            }
        }
        sb.append(" from ").append(tableName);
        if (filter != null) {
            sb.append(" where ").append(filter);
        }
        return sb.toString();
    }

    public String reformatForTableMetadata(String component) {
        return component.replace("\"", "");
    }

    public String composeUpdateStatusLoad(String cdcCatalogTableName, int loadStatus, String sourceDbName, String srcTableFullName) {
        return String.format("update %s set status_load='%s' where db_name='%s' and table_name_full='%s'", cdcCatalogTableName, loadStatus, sourceDbName, srcTableFullName);
    }

    public String composeInsertSummaryRecord(Map<String, String> loadSummaryMap, String loadSummaryTable) {
        StringBuilder columnNames = new StringBuilder();
        StringBuilder columnValues = new StringBuilder();
        int size = loadSummaryMap.entrySet().size();
        int index = 0;
        for (Map.Entry<String, String> entry : loadSummaryMap.entrySet()) {
            columnNames.append(entry.getKey());
            if (index < size - 1) {
                columnNames.append(",");
            }
            if (entry.getValue() == null) {
                columnValues.append((String)null);
            } else if (this.isSummaryColumnTypeIsTimestamp(entry.getKey())) {
                columnValues.append("TO_TIMESTAMP('").append(entry.getValue()).append("', 'YYYY-MM-DD HH24:MI:SS.US')");
            } else {
                columnValues.append("$$").append(entry.getValue()).append("$$");
            }
            if (index < size - 1) {
                columnValues.append(",");
            }
            ++index;
        }
        return String.format("insert into %s (%s) values (%s)", loadSummaryTable, columnNames, columnValues);
    }

    public boolean isSummaryColumnTypeIsTimestamp(String columnName) {
        return columnName.equalsIgnoreCase("start_time") || columnName.equalsIgnoreCase("finish_time") || columnName.equalsIgnoreCase("updated_dttm_from") || columnName.equalsIgnoreCase("updated_dttm_to") || columnName.equalsIgnoreCase("last_val_ts");
    }

    public String composeCreateTableQuery(String tableFullName, List<CreationColumnData> columns, boolean replace) {
        StringBuilder createTableQuery = new StringBuilder();
        createTableQuery.append("create");
        if (replace) {
            createTableQuery.append(" or replace ");
        }
        createTableQuery.append(" table ").append(tableFullName).append(" (");
        int columnSize = columns.size();
        for (int i = 0; i < columnSize; ++i) {
            CreationColumnData columnData = columns.get(i);
            createTableQuery.append(columnData.getColName()).append(" ").append(columnData.getSqreamColumnType());
            if (i >= columnSize - 1) continue;
            createTableQuery.append(",");
        }
        createTableQuery.append(")");
        return createTableQuery.toString();
    }

    public String composeRowCountQuery(String tableFullName, String filter) {
        return "SELECT COUNT(*) FROM " + tableFullName + " WHERE " + filter;
    }

    public abstract String composeColumnListQuery(String var1, String var2, List<String> var3, String var4);

    public String composeDropTable(String tableFullName) {
        return "drop table if exists " + tableFullName;
    }

    public String composeTruncateTable(String tableFullName) {
        return "truncate table " + tableFullName;
    }

    public String composeSelectQuery(SelectColumnData selectColumnData, String loadDttmColumnName) {
        StringBuilder selectColumnsBuilder = new StringBuilder();
        List columnList = selectColumnData.getColumnList();
        if (columnList == null || columnList.isEmpty()) {
            selectColumnsBuilder.append("*");
        } else {
            for (int i = 0; i < columnList.size(); ++i) {
                String colNameForSelect = this.getColumnNameForSelect((String)columnList.get(i), loadDttmColumnName);
                selectColumnsBuilder.append(colNameForSelect);
                if (i >= columnList.size() - 1) continue;
                selectColumnsBuilder.append(",");
            }
        }
        String selectQuery = null;
        selectQuery = selectColumnData.getPartitionName() != null ? this.composeSelectPerPartition(selectColumnData, selectColumnsBuilder.toString()) : (selectColumnData.getTableSplitData() != null ? this.composeSelectBetweenRange(selectColumnData, selectColumnsBuilder.toString()) : this.composeRegularSelect(selectColumnData, selectColumnsBuilder.toString()));
        return selectQuery;
    }

    public abstract String getColumnNameForSelect(String var1, String var2);

    public String getColumnNameForSelect(String alias, ColumnData columnData, String loadDttmColumnName) {
        return columnData.getColName();
    }

    public String composeRegularSelect(SelectColumnData selectColumnData, String selectColumnList) {
        StringBuilder selectQueryBuilder = new StringBuilder();
        selectQueryBuilder.append(String.format("select %s from %s where %s", selectColumnList, selectColumnData.getTableFullName(), selectColumnData.getFilter()));
        if (selectColumnData.getLimit() > 0) {
            selectQueryBuilder.append(" limit " + selectColumnData.getLimit());
        }
        return selectQueryBuilder.toString();
    }

    public String composeSelectPerPartition(SelectColumnData selectColumnData, String selectColumnList) {
        return null;
    }

    public String composeSelectBetweenRange(SelectColumnData selectColumnData, String selectColumnList) {
        return null;
    }

    public String composeCreateViewQuery(String viewTableName, String selectQuery) {
        return "CREATE VIEW " + viewTableName + " AS " + selectQuery;
    }

    public String composeDropViewQuery(String viewTableName) {
        return "DROP VIEW IF EXISTS " + viewTableName;
    }

    public abstract String composeIsTableExistQuery(String var1, String var2, String var3);

    public String composeIsTableExistQuery(String tableFullName, boolean caseSensitive, String sqreamVersion) {
        String schemaName = this.strUtils.formatName(tableFullName.split("\\.")[0], this.dbType, caseSensitive);
        String tableName = this.strUtils.formatName(tableFullName.split("\\.")[1], this.dbType, caseSensitive);
        return this.composeIsTableExistQuery(schemaName, tableName, sqreamVersion);
    }

    public String composeIsTableExistQuery(String databaseName, String schemaName, String tableName, String version) {
        return "Not Supported";
    }

    public abstract String composeIsViewExistQuery(String var1, String var2, String var3);

    public String composeIsViewExistQuery(String databaseName, String schemaName, String tableName, String version) {
        return "Not Supported";
    }

    public String composeMetadataQuery(String tableFullName) {
        return "Not Supported";
    }

    public String composePartitionListQuery(String schemaName, String tableName) {
        return "Not Supported";
    }

    public String composeGetMinMaxRowsQuery(int threadCount, String schemaName, String tableName) {
        return "Not Supported";
    }

    public String composeCountQuery(String tableFullName, String filter) {
        return "Not Supported";
    }

    public String composeCleanupChucksQuery(String schemaName, String tableName) {
        return "Not Supported";
    }

    public String composeCleanupExtentsQuery(String schemaName, String tableName) {
        return "Not Supported";
    }

    public String composeSwapTables(String schemaName, String tableName1, String tableName2) {
        return "Not Supported";
    }

    public String composeCreateAsSelect(String sourceTable, String targetTable) {
        return "create table " + targetTable + " as (select top 1 * from " + sourceTable + " where 1=0)";
    }

    public String composeGetViewDdl(String schemaName, String viewFullName) {
        return "Not Supported";
    }

    public String composeAlterTableName(String sourceTable, String targetTable) {
        return "ALTER TABLE " + sourceTable + " RENAME TO " + targetTable;
    }

    public String composeSelectQuery(String tableName, List<ColumnData> columnList, String filter, String loadDttmColumnName) {
        StringBuilder sb = new StringBuilder();
        sb.append("select ");
        if (columnList == null || columnList.isEmpty()) {
            sb.append("*");
        } else {
            for (int i = 0; i < columnList.size(); ++i) {
                sb.append(this.getColumnNameForSelect(null, columnList.get(i), loadDttmColumnName));
                if (i >= columnList.size() - 1) continue;
                sb.append(",");
            }
        }
        sb.append(" from ").append(tableName);
        if (filter != null) {
            sb.append(" where ").append(filter);
        }
        return sb.toString();
    }

    public String getSelectListString(List<ColumnData> columnDataList, String loadDttmColumnName) {
        if (columnDataList == null || columnDataList.isEmpty()) {
            return "SELECT *";
        }
        StringBuilder sb = new StringBuilder();
        sb.append("select ");
        for (int i = 0; i < columnDataList.size(); ++i) {
            sb.append(this.getColumnNameForSelect(null, columnDataList.get(i), loadDttmColumnName));
            if (i >= columnDataList.size() - 1) continue;
            sb.append(",");
        }
        return sb.toString();
    }

    public String composeSelectQueryForPrimaryKeys(String primaryKeyTable, String srcDbName, String srcFullTableName, String loadDttmColumnName) {
        ArrayList emptyColumnList = new ArrayList();
        String filter = String.format("DB_NAME='%s' and table_name_full='%s'", srcDbName, srcFullTableName);
        return this.composeSelectQuery(primaryKeyTable, emptyColumnList, filter, loadDttmColumnName);
    }

    public String composeInsertMaxDttmQuery(String cdcTrackingTable, DBType catalogDbType, String srcDbName, String schemaName, String tableName, String srcTableFullName, String maxUpdatedDttm) {
        return String.format("INSERT INTO %s (db_name, schema_name, table_name, table_name_full, last_updated_dttm) VALUES ('%s', '%s', '%s', '%s', '%s')", cdcTrackingTable, srcDbName, schemaName, tableName, srcTableFullName, maxUpdatedDttm);
    }

    public String composeUpdateLastDttmQuery(String cdcTrackingTableName, String maxUpdatedDttm, DBType catalogDbType, String srcDbName, String srcTableFullName) {
        return String.format("UPDATE %s SET last_updated_dttm='%s' WHERE db_name='%s' AND table_name_full='%s'", cdcTrackingTableName, maxUpdatedDttm, srcDbName, srcTableFullName);
    }

    public abstract String composeSelectAccordingDttmFilter(List<PrimaryKeyData> var1, List<ColumnData> var2, String var3, String var4, String var5, String var6, boolean var7, String var8);

    public abstract String composeCdcDeleteStatement(List<PrimaryKeyData> var1, String var2, String var3, String var4, String var5);

    public String composeSelectDeltaCount(String sourceTableNameCdcFull, String lastDttm, String maxDttm) {
        return String.format("SELECT COUNT(1) FROM %s WHERE UPDATED_DTTM > TO_DATE('%s', 'YYYY-MM-DD HH24:MI:SS') AND UPDATED_DTTM <= TO_DATE('%s', 'YYYY-MM-DD HH24:MI:SS')", sourceTableNameCdcFull, lastDttm, maxDttm);
    }

    public abstract String composeSelectFromCdcToStg(List<PrimaryKeyData> var1, List<ColumnData> var2, String var3, String var4, String var5, String var6, String var7);

    public String composeLastDttmValidationQuery(String sourceTableNameCdcFull, String lastUpdatedDttm) {
        return String.format("SELECT COUNT(1) FROM %s WHERE UPDATED_DTTM = TO_DATE('%s', 'YYYY-MM-DD HH24:MI:SS')", sourceTableNameCdcFull, lastUpdatedDttm);
    }

    public String composeSelectLatestDttmQuery(String cdcTrackingTable, String sourceDbName, String fullTableName) {
        return String.format("SELECT last_updated_dttm FROM %s WHERE db_name='%s' AND table_name_full='%s'", cdcTrackingTable, sourceDbName, fullTableName);
    }

    public String composeSelectMaxDttmQuery(String tableNameCdc, String latestDttmOnSqream) {
        if (latestDttmOnSqream == null) {
            return String.format("select max(updated_dttm) from %s", tableNameCdc);
        }
        return String.format("select max(updated_dttm) from %s where updated_dttm > TO_DATE('%s', 'YYYY-MM-DD HH24:MI:SS')", tableNameCdc, latestDttmOnSqream);
    }

    public String composeInsertFromStgToSqream(List<String> columnList, String sqreamTableNameFull, String sqreamTableStgNameFull) {
        StringBuilder insertCmd = new StringBuilder();
        insertCmd.append("INSERT INTO ").append(sqreamTableNameFull).append(" select ");
        String columns = String.join((CharSequence)",", columnList);
        insertCmd.append(columns);
        insertCmd.append(" from ").append(sqreamTableStgNameFull);
        return insertCmd.toString();
    }

    public String composeInsertFromStgToSqream(List<String> columnList, String sqreamTableNameFull, String sqreamTableStgNameFull, String dmlType) {
        StringBuilder insertCmd = new StringBuilder();
        insertCmd.append("INSERT INTO ").append(sqreamTableNameFull).append(" select ");
        String columns = String.join((CharSequence)",", columnList);
        insertCmd.append(columns);
        insertCmd.append(" from ").append(sqreamTableStgNameFull).append(" where ora_dml_type in ('").append(dmlType).append("')");
        return insertCmd.toString();
    }

    public String getCdcJoinStatement4PrimaryKeys(List<PrimaryKeyData> primaryKeys, String alias1, String alias2, String isNullFunction) {
        StringBuilder sb = new StringBuilder();
        for (PrimaryKeyData primaryKeyData : primaryKeys) {
            String nullValue;
            String columnName = primaryKeyData.getColumnName();
            String nullable = primaryKeyData.getNullable();
            if (isNullFunction.equals("ISNULL")) {
                nullable = "1";
            }
            switch (primaryKeyData.getJavaType()) {
                case "date": 
                case "datetime": {
                    nullValue = "'1900-01-01'";
                    if (isNullFunction.equals("NVL")) {
                        nullValue = "TO_DATE('1900-01-01 00:00:00','YYYY-MM-DD HH24:MI:SS')";
                    }
                }
                case "timestamp": {
                    nullValue = "'1900-01-01'";
                    if (!isNullFunction.equals("NVL")) break;
                    nullValue = "TO_TIMESTAMP('1900-01-01 00:00:00','YYYY-MM-DD HH24:MI:SS')";
                    break;
                }
                case "bigdecimal": 
                case "int": 
                case "boolean": {
                    nullValue = "0";
                    break;
                }
                default: {
                    nullValue = "'0'";
                }
            }
            if (isNullFunction.equals("NVL") && nullable.equals("1")) {
                sb.append("(").append(alias1).append(".").append(columnName).append("=").append(alias2).append(".").append(columnName).append(" or (").append(alias1).append(".").append(columnName).append(" is null and ").append(alias2).append(".").append(columnName).append(" is null)) and ");
                continue;
            }
            if (isNullFunction.equals("ISNULL")) {
                sb.append(isNullFunction).append("(").append(alias1).append(".").append(columnName).append(",").append(nullValue).append(")=").append(isNullFunction).append("(").append(alias2).append(".").append(columnName).append(",").append(nullValue).append(") and ");
                continue;
            }
            sb.append(alias1).append(".").append(columnName).append("=").append(alias2).append(".").append(columnName).append(" and ");
        }
        return sb.substring(0, sb.length() - 4);
    }

    public String composeMaxValueQuery(String s_lastValue, String sourceTableNameFull, String incrColumnName, String incrColumnType, String filter) {
        String cmdSelect = "select max(" + incrColumnName + ") from " + sourceTableNameFull + " where (" + filter + ")";
        if (s_lastValue != null) {
            cmdSelect = "select max(" + incrColumnName + ") from " + sourceTableNameFull + " where " + incrColumnName + " >'" + s_lastValue + "' and (" + filter + ")";
            if (incrColumnType.equals("timestamp")) {
                cmdSelect = "select to_char(max(" + incrColumnName + "),'YYYY-MM-DD HH24:MI:SS.FF') from " + sourceTableNameFull + " where " + incrColumnName + " >to_timestamp('" + s_lastValue + "','YYYY-MM-DD HH24:MI:SS.FF') and (" + filter + ")";
            } else if (incrColumnType.equals("datetime")) {
                cmdSelect = "select to_char(max(" + incrColumnName + "),'YYYY-MM-DD HH24:MI:SS') from " + sourceTableNameFull + " where " + incrColumnName + " >to_date('" + s_lastValue + "','YYYY-MM-DD HH24:MI:SS') and (" + filter + ")";
            }
        } else if (incrColumnType.equals("timestamp")) {
            cmdSelect = "select to_char(max(" + incrColumnName + "),'YYYY-MM-DD HH24:MI:SS.FF') from " + sourceTableNameFull + " where (" + filter + ")";
        } else if (incrColumnType.equals("datetime")) {
            cmdSelect = "select to_char(max(" + incrColumnName + "),'YYYY-MM-DD HH24:MI:SS') from " + sourceTableNameFull + " where (" + filter + ")";
        }
        return cmdSelect;
    }

    public String composeLastValueFromTracking(String trackColumnName, String cdcTrackingTable, String sourceDbName, String sourceTableNameFull, String incrColumnType) {
        if (incrColumnType.equalsIgnoreCase("timestamp")) {
            trackColumnName = "to_char(" + (String)trackColumnName + ",'YYYY-MM-DD HH24:MI:SS.FF')";
        }
        return "select " + (String)trackColumnName + " from " + cdcTrackingTable + " where db_name='" + sourceDbName + "' and table_name_full='" + sourceTableNameFull + "'";
    }

    public String getFilterFromTracking(String trackColumnName, String cdcTrackingTable, String sourceDbName, String sourceTableNameFull, String incrColumnType) {
        return "select filter from " + cdcTrackingTable + " where db_name='" + sourceDbName + "' and table_name_full='" + sourceTableNameFull + "'";
    }

    public String composeIncDeleteQuery(String sqreamTableNameFull, String sqreamTableNameStgFull, List<PrimaryKeyData> primaryKeys, String isNullFunction) {
        String retval = "delete FROM " + sqreamTableNameFull + " T where ";
        retval = retval + "EXISTS (SELECT 1 FROM " + sqreamTableNameStgFull + " S ";
        String s_joinKeys = this.getIncJoinStatement4PrimaryKeys(primaryKeys, "T", "S", isNullFunction);
        retval = retval + " WHERE " + s_joinKeys + ")";
        return retval;
    }

    public String getIncJoinStatement4PrimaryKeys(List<PrimaryKeyData> primaryKeys, String alias1, String alias2, String isNullFunction) {
        StringBuilder sb = new StringBuilder();
        for (PrimaryKeyData primaryKeyData : primaryKeys) {
            String columnName = primaryKeyData.getColumnName();
            String nullValue = switch (primaryKeyData.getJavaType()) {
                case "date", "datetime", "timestamp", "offsetDateTime" -> "'1900-01-01'";
                case "bigdecimal", "int", "boolean" -> "0";
                default -> "'0'";
            };
            sb.append(isNullFunction).append("(").append(alias1).append(".").append(columnName).append(",").append(nullValue).append(")=").append(isNullFunction).append("(").append(alias2).append(".").append(columnName).append(",").append(nullValue).append(") and ");
        }
        return sb.substring(0, sb.length() - 4);
    }

    public String compoUpdateTrackingQuery(String cdcTrackingTableName, String trackingColumnName, String trackingValue, String sourceDbName, String srcTableFullName, String incrColumnType) {
        String cmdUpdate = "datetime".equals(incrColumnType) ? String.format("update %s set %s=TO_DATE('%s','YYYY-MM-DD HH24:MI:SS') where db_name='%s' and table_name_full='%s'", cdcTrackingTableName, trackingColumnName, trackingValue, sourceDbName, srcTableFullName) : ("timestamp".equals(incrColumnType) ? String.format("update %s set %s=TO_TIMESTAMP('%s','YYYY-MM-DD HH24:MI:SS.FF') where db_name='%s' and table_name_full='%s'", cdcTrackingTableName, trackingColumnName, trackingValue, sourceDbName, srcTableFullName) : String.format("update %s set %s='%s' where db_name='%s' and table_name_full='%s'", cdcTrackingTableName, trackingColumnName, trackingValue, sourceDbName, srcTableFullName));
        return cmdUpdate;
    }

    public String compoUpdateTrackingQueryIncludeFilter(String cdcTrackingTableName, String trackingColumnName, String trackingValue, String sourceDbName, String srcTableFullName, String incrColumnType, String filter) {
        String cmdUpdate = "datetime".equals(incrColumnType) ? String.format("update %s set %s=TO_DATE('%s','YYYY-MM-DD HH24:MI:SS'), filter='%s' where db_name='%s' and table_name_full='%s'", cdcTrackingTableName, trackingColumnName, trackingValue, filter, sourceDbName, srcTableFullName) : ("timestamp".equals(incrColumnType) ? String.format("update %s set %s=TO_TIMESTAMP('%s','YYYY-MM-DD HH24:MI:SS.FF'), filter='%s' where db_name='%s' and table_name_full='%s'", cdcTrackingTableName, trackingColumnName, trackingValue, filter, sourceDbName, srcTableFullName) : String.format("update %s set %s='%s', filter='%s' where db_name='%s' and table_name_full='%s'", cdcTrackingTableName, trackingColumnName, trackingValue, filter, sourceDbName, srcTableFullName));
        return cmdUpdate;
    }

    public String composeInsertTrackingQuery(String trackingTableName, String trackingColumnName, String incrColumnType, String srcDbType, String schemaName, String tableName, String tableFullName, String trackingLastValue, String filter) {
        StringBuilder sb = new StringBuilder();
        sb.append("insert into ");
        sb.append(trackingTableName);
        sb.append(" (db_name,schema_name,table_name,table_name_full,").append(trackingColumnName).append(",filter) values (");
        if (incrColumnType.equals("datetime")) {
            sb.append("'").append(srcDbType).append("','").append(schemaName).append("','").append(tableName).append("','").append(tableFullName).append("',TO_DATE('").append(trackingLastValue).append("','YYYY-MM-DD HH24:MI:SS'),'" + filter + "')");
        } else if (incrColumnType.equals("timestamp")) {
            sb.append("'").append(srcDbType).append("','").append(schemaName).append("','").append(tableName).append("','").append(tableFullName).append("',TO_TIMESTAMP('").append(trackingLastValue).append("','YYYY-MM-DD HH24:MI:SS.FF'),'" + filter + "')");
        } else {
            sb.append("'").append(srcDbType).append("','").append(schemaName).append("','").append(tableName).append("','").append(tableFullName).append("','").append(trackingLastValue).append("','" + filter + "')");
        }
        return sb.toString();
    }

    public String composeSelectFromIncQuery(String srcTableName, String incColumnName, String incrColumnType, List<ColumnData> columnDataList, String minVal, String maxVal, boolean rowid, boolean loadDttm, String loadDttmColumnName, String filter) {
        if (columnDataList != null && rowid) {
            columnDataList.add(new ColumnData("rowid", "text", null, null, null, true, "rowid_from_inc", false));
        }
        String selectList = this.getSelectListString(columnDataList, loadDttmColumnName);
        String retvalQuery = selectList + " FROM " + srcTableName + " WHERE ";
        retvalQuery = retvalQuery + this.getIncrementalQueryFilter(incColumnName, incrColumnType, minVal, maxVal, filter);
        return retvalQuery;
    }

    public String getIncrementalQueryFilter(String incrColumnName, String incrColumnType, String minVal, String maxVal, String filter) {
        return switch (incrColumnType) {
            case "datetime" -> incrColumnName + " > TO_DATE('" + minVal + "', 'YYYY-MM-DD HH24:MI:SS') and " + incrColumnName + " <= TO_DATE('" + maxVal + "', 'YYYY-MM-DD HH24:MI:SS') and (" + filter + ")";
            case "timestamp" -> incrColumnName + " > TO_TIMESTAMP('" + minVal + "', 'YYYY-MM-DD HH24:MI:SS.FF') and " + incrColumnName + " <= TO_TIMESTAMP('" + maxVal + "', 'YYYY-MM-DD HH24:MI:SS.FF') and (" + filter + ")";
            case "int" -> incrColumnName + " > " + minVal + " and " + incrColumnName + " <= " + maxVal + " and (" + filter + ")";
            default -> "";
        };
    }

    public abstract String compoAlterQueryColumns(Map<String, String> var1, String var2);
}

