/*
 * Decompiled with CFR 0.152.
 */
package com.sqream.sqloaderService.monitor;

import com.sun.management.OperatingSystemMXBean;
import jakarta.annotation.PostConstruct;
import java.lang.management.ManagementFactory;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadPoolExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.interceptor.AsyncUncaughtExceptionHandler;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.scheduling.annotation.AsyncConfigurer;
import org.springframework.scheduling.annotation.EnableAsync;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.stereotype.Component;

@EnableAsync
@Component
public class ThreadPoolMonitor
implements AsyncConfigurer {
    private static final Logger log = LoggerFactory.getLogger(ThreadPoolMonitor.class);
    public static final ThreadPoolTaskExecutor executor = new ThreadPoolTaskExecutor();
    OperatingSystemMXBean osBean = (OperatingSystemMXBean)ManagementFactory.getOperatingSystemMXBean();
    @Value(value="${maxCpuUtilization:#{90}}")
    public int maxCpuUtilization;
    @Value(value="${utilizationScalingFactor:#{1}}")
    public Integer utilizationScalingFactor;
    @Value(value="${enabledAutoCpuUtilization:#{false}}")
    public Boolean enabledAutoCpuUtilization;
    @Value(value="${cpuThreshold:#{15}}")
    public int cpuThreshold;
    @Value(value="${memoryThreshold:#{5}}")
    public int memoryThreshold;
    int availableProcessors;

    @PostConstruct
    public void init() throws Exception {
        log.info("Auto Cpu Utilization is {}", (Object)(this.enabledAutoCpuUtilization != false ? "enabled" : "disable"));
        this.availableProcessors = this.getAvailableProcessors();
        int maxPoolSize = this.calculateInitialMaxPoolSize();
        int queueCapacity = this.calculateInitialCapacity();
        int corePoolSize = this.calculateInitialCorePoolSize();
        log.info("Init executor [QueueCapacity={}, CorePoolSize={}, MaxPoolSize={}]", new Object[]{queueCapacity, corePoolSize, maxPoolSize});
        executor.setThreadNamePrefix("AsyncLoadRequest-");
        executor.setQueueCapacity(queueCapacity);
        executor.setCorePoolSize(corePoolSize);
        executor.setMaxPoolSize(maxPoolSize);
        executor.setRejectedExecutionHandler((RejectedExecutionHandler)new ThreadPoolExecutor.DiscardPolicy());
        executor.initialize();
    }

    public Executor getAsyncExecutor() {
        return executor;
    }

    public AsyncUncaughtExceptionHandler getAsyncUncaughtExceptionHandler() {
        return (ex, method, params) -> log.error("Method {} threw an Exception with message : {}", (Object)method, (Object)ex.getMessage());
    }

    public double getCpuUtilization() {
        return this.osBean.getCpuLoad() * 100.0;
    }

    public int calculateMaxPoolSize(double cpuUtilization, int availableProcessors) {
        log.trace("cpuUtilization={}, availableProcessors={}", (Object)cpuUtilization, (Object)availableProcessors);
        return (int)Math.ceil((long)availableProcessors * Math.round((double)this.maxCpuUtilization / cpuUtilization));
    }

    public int calculateInitialCorePoolSize() {
        return this.availableProcessors;
    }

    public int calculateInitialCapacity() {
        return this.availableProcessors * 2;
    }

    public int calculateInitialMaxPoolSize() {
        if (this.enabledAutoCpuUtilization.booleanValue()) {
            return this.calculateMaxPoolSize(this.getCpuUtilization(), this.availableProcessors);
        }
        log.info("Cpu utilization scaling factor configured to {}", (Object)this.utilizationScalingFactor);
        return this.availableProcessors * this.utilizationScalingFactor;
    }

    private int getAvailableProcessors() {
        return Runtime.getRuntime().availableProcessors();
    }
}

