/*
 * Decompiled with CFR 0.152.
 */
package com.sqream.sqloaderService.monitor;

import com.hazelcast.map.IMap;
import com.sqream.sqloader.common.dto.RequestData;
import com.sqream.sqloader.common.enums.LoadType;
import com.sqream.sqloader.common.service.HazelcastService;
import com.sqream.sqloader.common.utils.CommonStrUtils;
import com.sqream.sqloaderService.dbhandler.SourceDbHandler;
import com.sqream.sqloaderService.dbhandler.cdc.AbstractCatalogHandler;
import com.sqream.sqloaderService.dto.Params;
import com.sqream.sqloaderService.enums.ExitCode;
import com.sqream.sqloaderService.enums.RequestPhase;
import com.sqream.sqloaderService.enums.RequestStatus;
import com.sqream.sqloaderService.service.SqloaderHazelcastService;
import com.sqream.sqloaderService.service.SqloaderHealthIndicator;
import com.sqream.sqloaderService.utils.LogUtils;
import com.sqream.sqloaderService.utils.NetworkUtils;
import com.sqream.sqloaderService.utils.retry.RetryCallbackExecutor;
import jakarta.annotation.PostConstruct;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.PriorityBlockingQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.retry.annotation.Retryable;
import org.springframework.retry.support.RetryTemplate;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Service;

@Service
public class MonitorService {
    private static final Logger log = LoggerFactory.getLogger(MonitorService.class);
    @Autowired
    LogUtils logUtils;
    @Autowired
    HazelcastService hazelcastService;
    @Autowired
    SqloaderHazelcastService sqloaderHazelcastService;
    @Autowired
    RetryTemplate retryTemplate;
    @Autowired
    RetryCallbackExecutor retryCallbackExecutor;
    @Value(value="${server.port}")
    String port;
    String myInstance;
    private static SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
    private static SimpleDateFormat ldf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private static SimpleDateFormat odf = new SimpleDateFormat("yyyyMMddHHmmss");
    private static SimpleDateFormat odff = new SimpleDateFormat("yyyyMMddHHmmss_SSS");
    private static SimpleDateFormat df = new SimpleDateFormat("yyyyMMdd");

    public MonitorService() {
        this.myInstance = "http://" + NetworkUtils.getHostIp() + ":" + this.port;
    }

    @PostConstruct
    @Scheduled(initialDelay=5000L, fixedDelay=5000L)
    public void recoveryInstances() {
        IMap instances = this.sqloaderHazelcastService.getInstances();
        for (Map.Entry instance : instances) {
            if (this.itsMe(instance) || this.isEmptyTasks(instance) || !this.isDown(instance)) continue;
            if (((PriorityBlockingQueue)instance.getValue()).size() > 1) {
                log.info("Recovery instance {} there are {} tasks to be executed", instance.getKey(), (Object)((PriorityBlockingQueue)instance.getValue()).size());
            } else {
                log.info("Recovery instance {} there is {} task to be executed", instance.getKey(), (Object)((PriorityBlockingQueue)instance.getValue()).size());
            }
            PriorityBlockingQueue instanceRunnerQueue = (PriorityBlockingQueue)instance.getValue();
            this.sqloaderHazelcastService.getInstances().remove(instance.getKey());
            while (!instanceRunnerQueue.isEmpty()) {
                Params p = (Params)instanceRunnerQueue.poll();
                if (p.getLoadType() != LoadType.FULL) {
                    p.setLockCheck(Boolean.valueOf(false));
                }
                RequestData requestData = (RequestData)this.hazelcastService.getRequests().get((Object)p.getRequestId());
                this.hazelcastService.getRequests().remove((Object)p.getRequestId());
                if ((p.getLoadType() != LoadType.FULL || p.getDrop().booleanValue() || p.getTruncate().booleanValue()) && !requestData.getStatusPhase().equals(String.valueOf(RequestPhase.FINALIZE)) && !requestData.getStatusPhase().equals(String.valueOf(RequestPhase.DONE))) {
                    this.sqloaderHazelcastService.getBlockingQueue().add((Object)p);
                    continue;
                }
                log.warn("Task {} will not rerun on another service due to potential data corruption risk.", (Object)p.getRequestId());
            }
        }
    }

    private boolean isDown(Map.Entry<String, PriorityBlockingQueue<Params>> instance) {
        return SqloaderHealthIndicator.getLoaderHealth((String)instance.getKey()).getStatus().toString().equals("DOWN");
    }

    private boolean isEmptyTasks(Map.Entry<String, PriorityBlockingQueue<Params>> instance) {
        return instance.getValue().isEmpty();
    }

    private boolean itsMe(Map.Entry<String, PriorityBlockingQueue<Params>> instance) {
        return instance.getKey().equals(this.myInstance);
    }

    @Retryable(value={SQLException.class})
    public void addRecordToSummaryTable(AbstractCatalogHandler catalogHandler, SourceDbHandler sourceDbHandler, Params params, String requestId) throws SQLException {
        RequestData requestData = (RequestData)this.hazelcastService.getRequests().get((Object)requestId);
        if (this.sqloaderHazelcastService.getCancelledRequests().contains((Object)params.getRequestId())) {
            requestData.setStatusCode(Integer.valueOf(ExitCode.CANCELLED));
            requestData.setFinalStatus(RequestStatus.CANCELLED.name());
            this.hazelcastService.getRequests().put((Object)requestId, (Object)requestData);
            this.sqloaderHazelcastService.getCancelledRequests().remove((Object)params.getRequestId());
        }
        try {
            Map loadSummaryMap = this.getLoadSummaryMap(sourceDbHandler, params, requestData, catalogHandler);
            catalogHandler.insertMonitorRecordToSummaryTable(loadSummaryMap);
            requestData.setSummaryRecorded(Boolean.valueOf(true));
            this.hazelcastService.getRequests().put((Object)requestId, (Object)requestData);
            log.info("Log summary table updated successfully!");
        }
        catch (SQLException e) {
            String errorMsg = "Didn't succeed to insert summary row to summary table. Error message from DB: " + LogUtils.exceptionFormat((String)e.getMessage());
            log.error(errorMsg);
            throw e;
        }
    }

    private Map<String, String> getLoadSummaryMap(SourceDbHandler sourceDbHandler, Params params, RequestData requestData, AbstractCatalogHandler catalogHandler) {
        HashMap<String, String> loadSummary = new HashMap<String, String>();
        loadSummary.put("sqloader_version", params.getProjectVersion());
        loadSummary.put("request_id", params.getRequestId());
        loadSummary.put("client_ip", params.getClientIp());
        loadSummary.put("requested_host", params.getRequestedHost());
        loadSummary.put("acquired_host", params.getAcquiredHost());
        loadSummary.put("db_name", sourceDbHandler.getConfigSourceDbName());
        loadSummary.put("schema_name", sourceDbHandler.getTableConfigData().getSchemaName());
        loadSummary.put("table_name", sourceDbHandler.getTableConfigData().getTableName());
        loadSummary.put("table_name_full", sourceDbHandler.getFullTableName());
        loadSummary.put("load_type", params.getLoadType().name());
        loadSummary.put("start_time", ldf.format(requestData.getLoadStartTime()));
        loadSummary.put("finish_time", ldf.format(requestData.getLoadFinishTime()));
        loadSummary.put("elapsed_ms", String.valueOf(requestData.getLoadFinishTime() - requestData.getLoadStartTime()));
        loadSummary.put("elapsed_sec", String.valueOf((requestData.getLoadFinishTime() - requestData.getLoadStartTime()) / 1000L));
        long elapsed_source_ms = !requestData.getElapsedSourceTime().isEmpty() ? (Long)Collections.max(requestData.getElapsedSourceTime()) : 0L;
        long elapsed_target_ms = !requestData.getElapsedTargetTime().isEmpty() ? (Long)Collections.max(requestData.getElapsedTargetTime()) : 0L;
        loadSummary.put("elapsed_source_ms", String.valueOf(elapsed_source_ms));
        loadSummary.put("elapsed_source_sec", String.valueOf(elapsed_source_ms / 1000L));
        loadSummary.put("elapsed_target_ms", String.valueOf(elapsed_target_ms));
        loadSummary.put("elapsed_target_sec", String.valueOf(elapsed_target_ms / 1000L));
        loadSummary.put("row_count", String.valueOf(requestData.getTotalIngestedRowCount()));
        loadSummary.put("sql_filter", params.getFilter());
        loadSummary.put("PARTITION_COUNT", String.valueOf(sourceDbHandler.getPartitionCount()));
        loadSummary.put("thread_count", String.valueOf(sourceDbHandler.getThreadCount()));
        loadSummary.put("status_code", String.valueOf(requestData.getStatusCode()));
        loadSummary.put("status", requestData.getFinalStatus());
        loadSummary.put("log_file", this.logUtils.getLogFilePath());
        loadSummary.put("db_url", CommonStrUtils.maskConnectionString((String)sourceDbHandler.getConnectionString()));
        loadSummary.put("target_db_url", CommonStrUtils.maskConnectionString((String)params.getConnectionStringSqream()));
        loadSummary.put("partition", null);
        loadSummary.put("stmt_type", null);
        return catalogHandler.fillSummaryValues(loadSummary);
    }

    public void saveToMonitor(AbstractCatalogHandler catalogHandler, SourceDbHandler sourceDbHandler, Params params, String requestId) throws SQLException {
        this.retryCallbackExecutor.execute("catalogHandler", (Object)catalogHandler, args -> this.addRecordToSummaryTable(catalogHandler, sourceDbHandler, params, requestId), new Object[0]);
    }

    public void setLogUtils(LogUtils logUtils) {
        this.logUtils = logUtils;
    }

    public void setHazelcastService(HazelcastService hazelcastService) {
        this.hazelcastService = hazelcastService;
    }

    public void setSqloaderHazelcastService(SqloaderHazelcastService sqloaderHazelcastService) {
        this.sqloaderHazelcastService = sqloaderHazelcastService;
    }

    public void setRetryTemplate(RetryTemplate retryTemplate) {
        this.retryTemplate = retryTemplate;
    }

    public void setRetryCallbackExecutor(RetryCallbackExecutor retryCallbackExecutor) {
        this.retryCallbackExecutor = retryCallbackExecutor;
    }

    public void setPort(String port) {
        this.port = port;
    }

    public void setMyInstance(String myInstance) {
        this.myInstance = myInstance;
    }

    public LogUtils getLogUtils() {
        return this.logUtils;
    }

    public HazelcastService getHazelcastService() {
        return this.hazelcastService;
    }

    public SqloaderHazelcastService getSqloaderHazelcastService() {
        return this.sqloaderHazelcastService;
    }

    public RetryTemplate getRetryTemplate() {
        return this.retryTemplate;
    }

    public RetryCallbackExecutor getRetryCallbackExecutor() {
        return this.retryCallbackExecutor;
    }

    public String getPort() {
        return this.port;
    }

    public String getMyInstance() {
        return this.myInstance;
    }
}

