/*
 * Decompiled with CFR 0.152.
 */
package com.sqream.sqloaderService.monitor;

import com.sqream.sqloaderService.monitor.ThreadPoolMonitor;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Scheduled;

public class MonitorAndAdjustThreadPool {
    private static final Logger log = LoggerFactory.getLogger(MonitorAndAdjustThreadPool.class);
    @Autowired
    ThreadPoolMonitor threadPoolMonitor;
    List<Double> cpuUtilizationList = new ArrayList();

    @Scheduled(fixedDelay=30L, initialDelay=30L, timeUnit=TimeUnit.SECONDS)
    public void monitorCpuUtilization() {
        double cpu = this.threadPoolMonitor.getCpuUtilization();
        if (!Double.isNaN(cpu)) {
            this.cpuUtilizationList.add(cpu);
        }
    }

    @Scheduled(fixedDelay=5L, initialDelay=5L, timeUnit=TimeUnit.MINUTES)
    public void AdjustCpuUtilization() {
        log.info("cpuUtilizationList={}", (Object)this.cpuUtilizationList.toString());
        double cpuUtilizationAvg = Math.round(this.cpuUtilizationList.stream().mapToDouble(value -> value).summaryStatistics().getAverage());
        log.info("cpuUtilizationAvg={}", (Object)cpuUtilizationAvg);
        int newMaxPoolSize = this.threadPoolMonitor.calculateMaxPoolSize(cpuUtilizationAvg, this.threadPoolMonitor.availableProcessors);
        double freeMemory = (double)(Runtime.getRuntime().maxMemory() - Runtime.getRuntime().totalMemory()) / 1.073741824E9;
        log.info("FreeMemory={}", (Object)freeMemory);
        log.info("newMaxPoolSize={}", (Object)newMaxPoolSize);
        log.info("executor.getMaxPoolSize()={}", (Object)ThreadPoolMonitor.executor.getMaxPoolSize());
        if (Math.abs(newMaxPoolSize - ThreadPoolMonitor.executor.getMaxPoolSize()) > this.threadPoolMonitor.cpuThreshold && freeMemory > (double)this.threadPoolMonitor.memoryThreshold) {
            ThreadPoolMonitor.executor.setMaxPoolSize(newMaxPoolSize);
            log.info("Adjusted max pool size to: {}, cpu load usage avg: {}", (Object)newMaxPoolSize, (Object)cpuUtilizationAvg);
        }
    }
}

