/*
 * Decompiled with CFR 0.152.
 */
package com.sqream.sqloaderService.logging;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.sqream.sqloaderService.enums.RequestPhase;
import com.sqream.sqloaderService.logging.LogManager;
import com.sqream.sqloaderService.logging.LoggingService;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class LoggingServiceImpl
implements LoggingService {
    private static final Logger log = LoggerFactory.getLogger(LoggingServiceImpl.class);

    public void logRequest(HttpServletRequest httpServletRequest, Object body) throws JsonProcessingException {
        StringBuilder stringBuilder = new StringBuilder();
        Map parameters = this.buildParametersMap(httpServletRequest);
        if (httpServletRequest.getRequestURI().contains("load")) {
            LogManager.init((String)"", (String)RequestPhase.LOADING_REQUEST.name());
        }
        if (httpServletRequest.getRequestURI().contains("filterLogs")) {
            LogManager.init((String)"", (String)RequestPhase.FILTER_LOG_REQUEST.name());
        }
        stringBuilder.append("==> REQUEST ");
        stringBuilder.append("method=[").append(httpServletRequest.getMethod()).append("] ");
        stringBuilder.append("path=[").append(httpServletRequest.getRequestURI()).append("] ");
        stringBuilder.append("headers=[").append(this.buildHeadersMap(httpServletRequest)).append("] ");
        if (!parameters.isEmpty()) {
            stringBuilder.append("parameters=[").append(parameters).append("] ");
        }
        if (body != null) {
            ObjectMapper mapper = new ObjectMapper();
            mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
            String bodyString = mapper.writeValueAsString(body);
            stringBuilder.append("body=[" + bodyString + "]");
        }
        log.debug(stringBuilder.toString());
    }

    public void logResponse(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Object body) {
        StringBuilder stringBuilder = new StringBuilder();
        httpServletResponse.getStatus();
        stringBuilder.append("<== RESPONSE ");
        stringBuilder.append("method=[").append(httpServletRequest.getMethod()).append("] ");
        stringBuilder.append("path=[").append(httpServletRequest.getRequestURI()).append("] ");
        stringBuilder.append("responseHeaders=[").append(this.buildHeadersMap(httpServletResponse)).append("] ");
        stringBuilder.append("responseBody=[").append(body).append("] ");
        stringBuilder.append("status=[").append(httpServletResponse.getStatus()).append("] ");
        log.debug(stringBuilder.toString());
        LogManager.clear();
    }

    private Map<String, String> buildParametersMap(HttpServletRequest httpServletRequest) {
        HashMap<String, String> resultMap = new HashMap<String, String>();
        Enumeration parameterNames = httpServletRequest.getParameterNames();
        while (parameterNames.hasMoreElements()) {
            String key = (String)parameterNames.nextElement();
            String value = httpServletRequest.getParameter(key);
            resultMap.put(key, value);
        }
        return resultMap;
    }

    private Map<String, String> buildHeadersMap(HttpServletRequest request) {
        HashMap<String, String> map = new HashMap<String, String>();
        Enumeration headerNames = request.getHeaderNames();
        while (headerNames.hasMoreElements()) {
            String key = (String)headerNames.nextElement();
            String value = request.getHeader(key);
            map.put(key, value);
        }
        return map;
    }

    private Map<String, String> buildHeadersMap(HttpServletResponse response) {
        HashMap<String, String> map = new HashMap<String, String>();
        Collection headerNames = response.getHeaderNames();
        for (String header : headerNames) {
            map.put(header, response.getHeader(header));
        }
        return map;
    }
}

