/*
 * Decompiled with CFR 0.152.
 */
package com.sqream.sqloaderService.logging;

import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.core.Appender;
import ch.qos.logback.core.FileAppender;
import com.sqream.sqloaderService.ParamsValidation;
import com.sqream.sqloaderService.dto.LogFilterRequest;
import com.sqream.sqloaderService.utils.LogUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class LogFilterService {
    private static final Logger log = LoggerFactory.getLogger(LogFilterService.class);
    @Autowired
    ParamsValidation paramsValidation;

    public void filterLogs(LogFilterRequest request) throws IOException {
        String requestId = "[" + request.getRequestId() + "]";
        String outputFile = request.getOutputFilePath();
        Path path = Paths.get(outputFile, new String[0]);
        this.paramsValidation.validateDirectory(String.valueOf(path.getParent()));
        LoggerContext loggerContext = (LoggerContext)LoggerFactory.getILoggerFactory();
        ch.qos.logback.classic.Logger rootLogger = loggerContext.getLogger("ROOT");
        Iterator it = rootLogger.iteratorForAppenders();
        while (it.hasNext()) {
            Appender appender = (Appender)it.next();
            if (!(appender instanceof FileAppender)) continue;
            FileAppender fileAppender = (FileAppender)appender;
            try {
                String activeLogFilePath = fileAppender.getFile();
                String logsDirectory = Paths.get(activeLogFilePath, new String[0]).toAbsolutePath().getParent().toString();
                File dir = new File(logsDirectory);
                File[] directoryFiles = (File[])Arrays.stream(Objects.requireNonNull(dir.listFiles())).sorted((file1, file2) -> file1.getName().compareTo(file2.getName())).toArray(File[]::new);
                if (!dir.isDirectory() || directoryFiles == null) continue;
                for (File logFile : directoryFiles) {
                    boolean done = LogFilterService.filterAndSaveLogs((String)logFile.getPath(), (String)requestId, (String)outputFile);
                    if (!done) continue;
                    return;
                }
            }
            catch (IOException e) {
                log.error("An error occurred while filter logs for request {}, {}", (Object)requestId, (Object)LogUtils.exceptionFormat((String)e.getMessage()));
                throw e;
            }
        }
    }

    private static boolean filterAndSaveLogs(String logFilePath, String requestId, String outputFile) throws IOException {
        try (BufferedReader reader = new BufferedReader(new FileReader(logFilePath));
             FileWriter writer = new FileWriter(outputFile);){
            String line;
            while ((line = reader.readLine()) != null) {
                if (!line.contains(requestId)) continue;
                writer.write(line + "\n");
                if (!line.contains("Finished request - Status:")) continue;
                boolean bl = true;
                return bl;
            }
        }
        return false;
    }
}

