/*
 * Decompiled with CFR 0.152.
 */
package com.sqream.sqloaderService.logging;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.sqream.sqloaderService.logging.LoggingService;
import jakarta.servlet.http.HttpServletRequest;
import java.lang.reflect.Type;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.MethodParameter;
import org.springframework.http.HttpInputMessage;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.servlet.mvc.method.annotation.RequestBodyAdviceAdapter;

@ControllerAdvice
public class CustomRequestBodyAdviceAdapter
extends RequestBodyAdviceAdapter {
    @Autowired
    LoggingService loggingService;
    @Autowired
    HttpServletRequest httpServletRequest;

    public boolean supports(MethodParameter methodParameter, Type targetType, Class<? extends HttpMessageConverter<?>> converterType) {
        return true;
    }

    public Object afterBodyRead(Object body, HttpInputMessage inputMessage, MethodParameter parameter, Type targetType, Class<? extends HttpMessageConverter<?>> converterType) {
        try {
            this.loggingService.logRequest(this.httpServletRequest, body);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
        return super.afterBodyRead(body, inputMessage, parameter, targetType, converterType);
    }
}

