/*
 * Decompiled with CFR 0.152.
 */
package com.sqream.sqloaderService.loaders.cleanup;

import com.sqream.sqloaderService.configuration.BeanUtil;
import com.sqream.sqloaderService.dbhandler.SqreamDbHandler;
import com.sqream.sqloaderService.dto.Params;
import com.sqream.sqloaderService.loaders.cleanup.CleanupStrategy;
import com.sqream.sqloaderService.utils.LogUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FullLoadDefaultCleanup
implements CleanupStrategy {
    private static final Logger log = LoggerFactory.getLogger(FullLoadDefaultCleanup.class);
    LogUtils logUtils;
    SqreamDbHandler sqreamDbHandler;

    public FullLoadDefaultCleanup(SqreamDbHandler sqreamDbHandler) {
        this.sqreamDbHandler = sqreamDbHandler;
        this.logUtils = (LogUtils)BeanUtil.getBean(LogUtils.class);
    }

    public void cleanup(Params params) {
        try {
            this.logUtils.writeLogHeader("ALTER TEMP TABLE NAME TO FINAL TABLE");
            log.info("Alter final table name if exists to final old");
            this.sqreamDbHandler.dropView(params.getSqreamTableNameFull());
            if (params.getDrop().booleanValue()) {
                this.sqreamDbHandler.dropTable(params.getSqreamTableNameFullOld());
                this.sqreamDbHandler.dropView(params.getSqreamTableNameFullOld());
            }
            boolean shouldDropOld = this.sqreamDbHandler.tryAlterTable(params.getSqreamTableNameFull(), params.getSqreamTableNameFullOld());
            log.info("Alter temp table name to final table name");
            this.sqreamDbHandler.alterTable(this.sqreamDbHandler.getFullTableName(), params.getSqreamTableNameFull());
            if (shouldDropOld) {
                log.info("Drop old final table if exists");
                this.sqreamDbHandler.dropTable(params.getSqreamTableNameFullOld());
            }
        }
        catch (Exception e) {
            log.error("Didn't succeed to finalize full load. Error message from DB: {}", (Object)LogUtils.exceptionFormat((String)e.getMessage()));
        }
    }
}

