/*
 * Decompiled with CFR 0.152.
 */
package com.sqream.sqloaderService.loaders.cleanup;

import com.sqream.sqloaderService.configuration.BeanUtil;
import com.sqream.sqloaderService.dbhandler.SqreamDbHandler;
import com.sqream.sqloaderService.dto.Params;
import com.sqream.sqloaderService.loaders.cleanup.CleanupStrategy;
import com.sqream.sqloaderService.utils.LogUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FullLoad4512Cleanup
implements CleanupStrategy {
    private static final Logger log = LoggerFactory.getLogger(FullLoad4512Cleanup.class);
    LogUtils logUtils;
    SqreamDbHandler sqreamDbHandler;

    public FullLoad4512Cleanup(SqreamDbHandler sqreamDbHandler) {
        this.sqreamDbHandler = sqreamDbHandler;
        this.logUtils = (LogUtils)BeanUtil.getBean(LogUtils.class);
    }

    public void cleanup(Params params) {
        this.logUtils.writeLogHeader("ALTER TEMP TABLE NAME TO FINAL TABLE");
        if (this.sqreamDbHandler.isTableExist(params.getSqreamSchema(), params.getSqreamTable())) {
            this.swapTables(params);
        } else if (this.sqreamDbHandler.isViewExist(params.getSqreamSchema(), params.getSqreamTable())) {
            this.handleView(params);
        } else {
            log.info(params.getSqreamTableNameFull() + " does not exists as table or as view, altering temp table to final table");
            this.sqreamDbHandler.alterTable(this.sqreamDbHandler.getFullTableName(), params.getSqreamTableNameFull());
        }
    }

    private void swapTables(Params params) {
        log.info(params.getSqreamTableNameFull() + " exists as a table. swapping the temp table with it");
        this.sqreamDbHandler.swapTables(params.getSqreamSchema(), params.getSqreamTable(), params.getSqreamTableTemp());
        log.info("Tables swapped successfully, dropping the temp table..");
        this.sqreamDbHandler.dropTable(params.getSqreamTableNameFullTemp());
    }

    private void handleView(Params params) {
        log.info(params.getSqreamTableNameFull() + " exists as a view. altering it to old");
        if (params.getDrop().booleanValue()) {
            if (this.sqreamDbHandler.isTableExist(params.getSqreamSchema(), params.getSqreamTableOld())) {
                log.info(params.getSqreamTableNameFullOld() + " exists as a table. dropping it before altering " + params.getSqreamTableNameFull() + " to old");
                this.sqreamDbHandler.dropTable(params.getSqreamTableNameFullOld());
            } else if (this.sqreamDbHandler.isViewExist(params.getSqreamSchema(), params.getSqreamTableOld())) {
                log.info(params.getSqreamTableNameFullOld() + " exists as a view. dropping it before altering " + params.getSqreamTableNameFull() + " to old");
                this.sqreamDbHandler.dropView(params.getSqreamTableNameFullOld());
            }
        }
        this.sqreamDbHandler.alterView(params.getSqreamTableNameFull(), params.getSqreamSchema(), params.getSqreamTable(), params.getSqreamTableOld());
        log.info("Altering temp table to final table");
        this.sqreamDbHandler.alterTable(this.sqreamDbHandler.getFullTableName(), params.getSqreamTableNameFull());
        log.info("Drop old view");
        this.sqreamDbHandler.dropView(params.getSqreamTableNameFullOld());
    }
}

