/*
 * Decompiled with CFR 0.152.
 */
package com.sqream.sqloaderService.loaders;

import com.sqream.sqloader.common.enums.LoadType;
import com.sqream.sqloaderService.dbhandler.SourceDbHandler;
import com.sqream.sqloaderService.dbhandler.SqreamDbHandler;
import com.sqream.sqloaderService.dbhandler.cdc.AbstractCatalogHandler;
import com.sqream.sqloaderService.dto.Params;
import com.sqream.sqloaderService.exceptions.SqloadInitException;
import com.sqream.sqloaderService.loaders.CdcLoader;
import com.sqream.sqloaderService.loaders.FullLoader;
import com.sqream.sqloaderService.loaders.IncLoader;
import com.sqream.sqloaderService.loaders.Loader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class LoaderFactory {
    private static final Logger log = LoggerFactory.getLogger(LoaderFactory.class);

    public Loader createLoader(SourceDbHandler sourceDbHandler, SqreamDbHandler sqreamDbHandler, Params params, AbstractCatalogHandler catalogHandler) throws SqloadInitException {
        if (params.getLoadType() == LoadType.FULL) {
            return new FullLoader(sourceDbHandler, sqreamDbHandler, params, catalogHandler);
        }
        if (params.getLoadType() == LoadType.INC) {
            return new IncLoader(sourceDbHandler, sqreamDbHandler, params, catalogHandler);
        }
        if (params.getLoadType() == LoadType.CDC) {
            return new CdcLoader(sourceDbHandler, sqreamDbHandler, params, catalogHandler);
        }
        throw new SqloadInitException("Requested load type is not supported. The supported load types are: {" + String.valueOf(LoadType.FULL) + "," + String.valueOf(LoadType.INC) + "," + String.valueOf(LoadType.CDC) + "}", params.getRequestId());
    }
}

