/*
 * Decompiled with CFR 0.152.
 */
package com.sqream.sqloaderService.loaders;

import com.sqream.sqloader.common.dto.RequestData;
import com.sqream.sqloader.common.enums.DBType;
import com.sqream.sqloader.common.service.HazelcastService;
import com.sqream.sqloaderService.configuration.BeanUtil;
import com.sqream.sqloaderService.configuration.JdbcConnectorFactory;
import com.sqream.sqloaderService.dbhandler.connectors.JDBCConnector;
import com.sqream.sqloaderService.dto.ColumnData;
import com.sqream.sqloaderService.enums.ExitCode;
import com.sqream.sqloaderService.enums.RequestPhase;
import com.sqream.sqloaderService.logging.LogManager;
import com.sqream.sqloaderService.typeconverters.TypeConverter;
import com.sqream.sqloaderService.typeconverters.TypeConverterMap;
import com.sqream.sqloaderService.typemapping.TypeMappingService;
import com.sqream.sqloaderService.utils.LogUtils;
import com.sqream.sqloaderService.utils.StrUtils;
import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoadRowDataExecuter
implements Runnable {
    private static final Logger log = LoggerFactory.getLogger(LoadRowDataExecuter.class);
    private final TypeConverterMap typeConverterMap;
    private static final double SECONDS_PER_MINUTE = 60.0;
    private static final SimpleDateFormat ldf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private final List<ColumnData> srcColumnData;
    private final DBType srcDbType;
    private final Map<String, String> targetColumnTypes;
    private final int batchSize;
    TypeMappingService typeMappingService;
    StrUtils strUtils;
    LogUtils logUtils;
    JdbcConnectorFactory jdbcConnectorFactory;
    private final List<String> selectQueriesToRun;
    private final List<String> parititonList;
    private final String sourceJdbcUrl;
    private final String sqreamJdbcUrl;
    String tableFullName;
    private final int fetchSize;
    private final boolean useDbmsLob;
    private final boolean caseSensitive;
    long elapsed;
    long elapsedSource;
    long elapsedTarget;
    int recordCounter;
    int ingestedRecordCount;
    String requestId;
    HazelcastService hazelcastService;
    String loadDttmColumnName;

    public LoadRowDataExecuter(List<ColumnData> srcColumnData, String sourceJdbcUrl, String sqreamJdbcUrl, List<String> queriesForSingleThread, int fetchSize, int batchSize, boolean useDbmsLoab, DBType srcDbType, String tableFullName, List<String> partitionList, Map<String, String> targetColumnTypes, boolean caseSensitive, TypeMappingService typeMapping, String loadDttmColumnName, String requestId) {
        this.srcDbType = srcDbType;
        this.srcColumnData = srcColumnData;
        this.sourceJdbcUrl = sourceJdbcUrl;
        this.sqreamJdbcUrl = sqreamJdbcUrl;
        this.selectQueriesToRun = queriesForSingleThread;
        this.fetchSize = fetchSize;
        this.batchSize = batchSize;
        this.useDbmsLob = useDbmsLoab;
        this.tableFullName = tableFullName;
        this.parititonList = partitionList;
        this.targetColumnTypes = targetColumnTypes;
        this.requestId = requestId;
        this.caseSensitive = caseSensitive;
        this.typeMappingService = typeMapping;
        this.loadDttmColumnName = loadDttmColumnName;
        this.hazelcastService = (HazelcastService)BeanUtil.getBean(HazelcastService.class);
        this.jdbcConnectorFactory = (JdbcConnectorFactory)BeanUtil.getBean(JdbcConnectorFactory.class);
        this.strUtils = (StrUtils)BeanUtil.getBean(StrUtils.class);
        this.logUtils = (LogUtils)BeanUtil.getBean(LogUtils.class);
        this.typeConverterMap = (TypeConverterMap)BeanUtil.getBean(TypeConverterMap.class);
        this.recordCounter = 0;
        this.ingestedRecordCount = 0;
        this.elapsedSource = 0L;
        this.elapsedTarget = 0L;
    }

    @Override
    public void run() {
        RequestData requestData = (RequestData)this.hazelcastService.getRequests().get((Object)this.requestId);
        requestData.setStatusPhase(String.valueOf(RequestPhase.LOADING));
        this.hazelcastService.getRequests().put((Object)this.requestId, (Object)requestData);
        LogManager.init((String)requestData.getRequestId(), (String)requestData.getStatusPhase());
        boolean isSucceed = true;
        for (int i = 0; i < this.selectQueriesToRun.size(); ++i) {
            try (JDBCConnector sourceJdbcConnector = this.jdbcConnectorFactory.createJdbcConnector(this.sourceJdbcUrl, "QUERY-SRC", this.requestId);
                 JDBCConnector sqreamJdbcConnector = this.jdbcConnectorFactory.createJdbcConnector(this.sqreamJdbcUrl, "QUERY-SQ", this.requestId);){
                sourceJdbcConnector.connect();
                sqreamJdbcConnector.connect();
                String selectQuery = (String)this.selectQueriesToRun.get(i);
                log.info("Select query from source DB: {}", (Object)selectQuery);
                String partitionName = this.parititonList != null && !this.parititonList.isEmpty() ? (String)this.parititonList.get(i) : null;
                this.copy(selectQuery, this.tableFullName, sourceJdbcConnector.getConnection(), sqreamJdbcConnector.getConnection(), partitionName);
                log.info("Query {} is copied successfully", (Object)selectQuery);
                continue;
            }
            catch (Error | Exception e) {
                log.error("An error occurred while copying: {}", (Object)LogUtils.exceptionFormat((String)e.getMessage()));
                isSucceed = false;
                throw e;
            }
            finally {
                requestData = (RequestData)this.hazelcastService.getRequests().get((Object)this.requestId);
                if (isSucceed) {
                    requestData.setStatusCode(Integer.valueOf(ExitCode.SUCCEEDED));
                }
                this.hazelcastService.getRequests().put((Object)this.requestId, (Object)requestData);
            }
        }
    }

    private double getRowsIngestedPerMinute(double elapsedMin) {
        double rowsIngestedPerMinute = elapsedMin == 0.0 ? (double)(this.ingestedRecordCount * 60) : (double)this.ingestedRecordCount / elapsedMin;
        return rowsIngestedPerMinute;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copy(String selectQuery, String tableFullName, Connection from, Connection to, String partitionName) throws SQLException, IOException {
        boolean batchExecuted = false;
        double elapsedMin = 0.0;
        this.recordCounter = 0;
        this.ingestedRecordCount = 0;
        Statement targetStmt = null;
        try {
            long sourceStart = System.currentTimeMillis();
            try (PreparedStatement sourceStmt = from.prepareStatement(selectQuery);){
                sourceStmt.setFetchSize(this.fetchSize);
                try (ResultSet resSrc = sourceStmt.executeQuery();){
                    double rowsIngestedPerMinute;
                    long startTimeLoad = System.currentTimeMillis();
                    ResultSetMetaData meta = resSrc.getMetaData();
                    List columns = this.getColumnsForInsert(meta);
                    this.elapsedSource += System.currentTimeMillis() - sourceStart;
                    this.formatColumnNames(columns, DBType.SQREAM, this.loadDttmColumnName);
                    String insertWithPlaceholdersQuery = "INSERT INTO " + tableFullName + " (" + String.join((CharSequence)", ", columns) + ") VALUES (" + columns.stream().map(c -> "?").collect(Collectors.joining(", ")) + ")";
                    log.info("Query template for ingestion: {}", (Object)insertWithPlaceholdersQuery);
                    long targetStart = System.currentTimeMillis();
                    targetStmt = to.prepareStatement(insertWithPlaceholdersQuery);
                    this.elapsedTarget += System.currentTimeMillis() - targetStart;
                    List typeConverterList = this.createTypeConverterList(meta);
                    while (resSrc.next()) {
                        batchExecuted = false;
                        sourceStart = targetStart = System.currentTimeMillis();
                        for (int colNum = 1; colNum <= meta.getColumnCount(); ++colNum) {
                            this.setObjectToSqream((PreparedStatement)targetStmt, resSrc, colNum, (TypeConverter)typeConverterList.get(colNum - 1), from);
                        }
                        this.elapsedSource += System.currentTimeMillis() - sourceStart;
                        targetStmt.addBatch();
                        this.elapsedTarget += System.currentTimeMillis() - targetStart;
                        ++this.recordCounter;
                        ++this.ingestedRecordCount;
                        if (this.recordCounter != this.batchSize && !resSrc.isAfterLast()) continue;
                        this.recordCounter = 0;
                        targetStart = System.currentTimeMillis();
                        targetStmt.executeBatch();
                        batchExecuted = true;
                        if (!targetStmt.isClosed()) {
                            targetStmt.close();
                        }
                        targetStmt = to.prepareStatement(insertWithPlaceholdersQuery);
                        this.elapsedTarget += System.currentTimeMillis() - targetStart;
                        this.elapsed = (System.currentTimeMillis() - startTimeLoad) / 1000L;
                        elapsedMin = (double)this.elapsed / 60.0;
                        rowsIngestedPerMinute = this.getRowsIngestedPerMinute(elapsedMin);
                        this.printSummary(partitionName, tableFullName, this.ingestedRecordCount, this.elapsed, rowsIngestedPerMinute);
                    }
                    if (!batchExecuted) {
                        rowsIngestedPerMinute = this.getRowsIngestedPerMinute(elapsedMin);
                        targetStart = System.currentTimeMillis();
                        targetStmt.executeBatch();
                        targetStmt.close();
                        this.elapsedTarget += System.currentTimeMillis() - targetStart;
                        this.printSummary(partitionName, tableFullName, this.ingestedRecordCount, this.elapsed, rowsIngestedPerMinute);
                    }
                    RequestData requestData = (RequestData)this.hazelcastService.getRequests().get((Object)this.requestId);
                    requestData.getElapsedSourceTime().add(this.elapsedSource);
                    requestData.getElapsedTargetTime().add(this.elapsedTarget);
                    requestData.getTotalIngestedRowCount().getAndAdd(this.ingestedRecordCount);
                    this.hazelcastService.getRequests().put((Object)this.requestId, (Object)requestData);
                }
                catch (Exception e) {
                    if (targetStmt != null) {
                        targetStmt.cancel();
                        targetStmt.close();
                    }
                    throw e;
                }
            }
        }
        finally {
            if (targetStmt != null && !targetStmt.isClosed()) {
                targetStmt.close();
                log.debug("Batch command is closed in SQream DB");
            }
        }
    }

    private void formatColumnNames(List<String> columns, DBType dbType, String loadDttmColumnName) {
        columns.replaceAll(word -> this.strUtils.formatColumnName(word, dbType, this.caseSensitive, loadDttmColumnName));
    }

    private void printSummary(String partitionName, String tableFullName, int ingestedRecordCount, long elapsed, double rowsIngestedPerMinute) {
        if (partitionName != null) {
            log.info("[SUMMARY] {}[{}] {} rows loaded in {} seconds. Average load performance: {} rows/min", new Object[]{tableFullName, partitionName, ingestedRecordCount, elapsed, NumberFormat.getInstance().format(rowsIngestedPerMinute)});
        } else {
            log.info("[SUMMARY] {} {} rows loaded in {} seconds. Average load performance: {} rows/min", new Object[]{tableFullName, ingestedRecordCount, elapsed, NumberFormat.getInstance().format(rowsIngestedPerMinute)});
        }
    }

    private List<String> getColumnsForInsert(ResultSetMetaData metaData) throws SQLException {
        ArrayList<String> columns = new ArrayList<String>();
        for (int i = 1; i <= metaData.getColumnCount(); ++i) {
            columns.add(metaData.getColumnName(i));
        }
        return columns;
    }

    private List<TypeConverter> createTypeConverterList(ResultSetMetaData meta) throws SQLException {
        ArrayList<TypeConverter> typeReaderList = new ArrayList<TypeConverter>();
        String javaType = null;
        String sqreamType = null;
        String columnName = null;
        String typeName = null;
        try {
            for (int i = 1; i <= meta.getColumnCount(); ++i) {
                ColumnData columnData = (ColumnData)this.srcColumnData.get(i - 1);
                log.trace("column name: {}; sql type name {}", (Object)meta.getColumnName(i), (Object)meta.getColumnTypeName(i));
                javaType = this.typeMappingService.getJavaType(this.srcDbType, columnData, this.caseSensitive);
                sqreamType = this.typeMappingService.getSqreamType(this.srcDbType, columnData, this.caseSensitive);
                typeName = meta.getColumnTypeName(i);
                columnName = meta.getColumnName(i);
                String targetColumnType = (String)this.targetColumnTypes.get(meta.getColumnName(i).toLowerCase());
                if (targetColumnType == null) {
                    log.debug("Target column type is empty for column name {}, Setting column type to be {}", (Object)meta.getColumnName(i), (Object)sqreamType);
                    targetColumnType = sqreamType;
                }
                if (sqreamType.contains("numeric(") && targetColumnType.toLowerCase().contains("numeric")) {
                    javaType = "bigdecimal";
                }
                if (javaType.equals("blob") && this.useDbmsLob) {
                    typeReaderList.add(this.typeConverterMap.getConverter("blobAsString"));
                    continue;
                }
                if (javaType.equals("clob") && this.useDbmsLob) {
                    typeReaderList.add(this.typeConverterMap.getConverter("clobAsString"));
                    continue;
                }
                typeReaderList.add(this.typeConverterMap.getConverter(javaType));
            }
            return typeReaderList;
        }
        catch (SQLException e) {
            log.error("column name: {}, sql type name: {}, java type: {}, sqream type: {}", new Object[]{columnName, typeName, javaType, sqreamType});
            throw e;
        }
    }

    private void setObjectToSqream(PreparedStatement targetPs, ResultSet rsSrc, int colNum, TypeConverter typeConverter, Connection conn) throws SQLException, IOException {
        try {
            typeConverter.setObject(colNum, rsSrc, targetPs, conn);
        }
        catch (SQLException e) {
            log.error("java type: {}, colNum : {}, value: {}", new Object[]{typeConverter.getTypeName(), colNum, rsSrc.getObject(colNum)});
            throw e;
        }
    }
}

