/*
 * Decompiled with CFR 0.152.
 */
package com.sqream.sqloaderService.loaders;

import com.sqream.sqloader.common.dto.RequestData;
import com.sqream.sqloaderService.dbhandler.SourceDbHandler;
import com.sqream.sqloaderService.dbhandler.SqreamDbHandler;
import com.sqream.sqloaderService.dbhandler.cdc.AbstractCatalogHandler;
import com.sqream.sqloaderService.dto.CreationColumnData;
import com.sqream.sqloaderService.dto.Params;
import com.sqream.sqloaderService.enums.ExitCode;
import com.sqream.sqloaderService.enums.TableType;
import com.sqream.sqloaderService.exceptions.SystemValidatorException;
import com.sqream.sqloaderService.loaders.CdcLoader;
import com.sqream.sqloaderService.loaders.LoadRowDataExecuter;
import com.sqream.sqloaderService.loaders.Loader;
import java.sql.SQLException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class IncLoader
extends CdcLoader
implements Loader {
    private static final Logger log = LoggerFactory.getLogger(IncLoader.class);

    public IncLoader(SourceDbHandler sourceDbHandler, SqreamDbHandler sqreamDbHandler, Params params, AbstractCatalogHandler catalogHandler) {
        super(sourceDbHandler, sqreamDbHandler, params, catalogHandler);
    }

    public void init() throws SQLException {
        super.init();
    }

    public void validatePrimaryKey() {
    }

    public void validate() throws SystemValidatorException {
        super.validate();
    }

    public void validateTableType() throws SystemValidatorException {
        if (this.catalogHandler.getTableType() == TableType.CDC || this.catalogHandler.getTableType() == TableType.STD) {
            RequestData requestData = (RequestData)this.hazelcastService.getRequests().get((Object)this.requestId);
            requestData.setStatusCode(Integer.valueOf(ExitCode.INCREMENTAL_PRECHECK_ERROR));
            this.hazelcastService.getRequests().put((Object)this.requestId, (Object)requestData);
            throw new SystemValidatorException("Load type is INC while table type according Catalog table is " + String.valueOf(this.catalogHandler.getTableType()), requestData.getStatusCode().intValue(), this.requestId);
        }
    }

    public void loadToStg(Map<String, String> columnTypesOfTarget, List<CreationColumnData> targetColumnsType) throws SQLException {
        this.validateColumns(targetColumnsType, columnTypesOfTarget);
        log.info("Truncate {} table first", (Object)this.sqreamDbHandler.getFullTableName());
        this.sqreamDbHandler.truncateTable(this.sqreamDbHandler.getFullTableName());
        log.info("Load data to {} is starting", (Object)this.sqreamDbHandler.getFullTableName());
        String queryForSelect = this.catalogHandler.getSelectCatalogQueryForCopy();
        log.info("Catalog query for loading: {}", (Object)queryForSelect);
        LoadRowDataExecuter loadRowDataService = this.getLoadRowDataExecuter(columnTypesOfTarget, queryForSelect, this.sourceDbHandler.getColumnsData());
        log.info("Starting to fetch rows to {} table", (Object)this.sqreamDbHandler.getFullTableName());
        loadRowDataService.run();
    }

    private void validateColumns(List<CreationColumnData> targetColumnsType, Map<String, String> columnTypesOfTarget) throws SQLException {
        if (this.params.getAutoCreateNewNullableColumn().booleanValue()) {
            LinkedHashMap<String, String> missingKeysMap = new LinkedHashMap<String, String>();
            for (CreationColumnData col : targetColumnsType) {
                String prev = columnTypesOfTarget.putIfAbsent(col.getColName(), col.getSqreamColumnType());
                if (prev != null) continue;
                missingKeysMap.put(col.getColName(), col.getSqreamColumnType());
            }
            if (missingKeysMap != null && !missingKeysMap.isEmpty()) {
                log.info("Add {} new columns: {}", (Object)missingKeysMap.size(), missingKeysMap);
                this.sqreamDbHandler.alterTableColumns(missingKeysMap);
            }
        }
    }
}

