/*
 * Decompiled with CFR 0.152.
 */
package com.sqream.sqloaderService.loaders;

import com.sqream.sqloader.common.dto.RequestData;
import com.sqream.sqloader.common.enums.DBType;
import com.sqream.sqloaderService.configuration.BeanUtil;
import com.sqream.sqloaderService.dbhandler.SourceDbHandler;
import com.sqream.sqloaderService.dbhandler.SqreamDbHandler;
import com.sqream.sqloaderService.dbhandler.cdc.AbstractCatalogHandler;
import com.sqream.sqloaderService.dto.ColumnData;
import com.sqream.sqloaderService.dto.Params;
import com.sqream.sqloaderService.dto.SelectColumnData;
import com.sqream.sqloaderService.enums.ExitCode;
import com.sqream.sqloaderService.enums.RequestPhase;
import com.sqream.sqloaderService.enums.RequestStatus;
import com.sqream.sqloaderService.exceptions.SqloadRuntimeException;
import com.sqream.sqloaderService.loaders.AbstractLoader;
import com.sqream.sqloaderService.loaders.LoadRowDataExecuter;
import com.sqream.sqloaderService.loaders.Loader;
import com.sqream.sqloaderService.loaders.cleanup.CleanupStrategy;
import com.sqream.sqloaderService.logging.LogManager;
import com.sqream.sqloaderService.utils.ManagedThreads;
import com.sqream.sqloaderService.utils.sqreamutils.SqreamVersionsFactory;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class FullLoader
extends AbstractLoader
implements Loader {
    private static final Logger log = LoggerFactory.getLogger(FullLoader.class);
    ManagedThreads managedThreads;
    SqreamVersionsFactory sqreamVersionsFactory;

    public FullLoader(SourceDbHandler sourceDbHandler, SqreamDbHandler sqreamDbHandler, Params params, AbstractCatalogHandler catalogHandler) {
        super(sourceDbHandler, sqreamDbHandler, params, catalogHandler);
        this.managedThreads = new ManagedThreads(params);
        this.sqreamVersionsFactory = (SqreamVersionsFactory)BeanUtil.getBean(SqreamVersionsFactory.class);
    }

    public void loadToSqream() throws SQLException, InterruptedException {
        log.info("Load data from {} to SQREAM through JDBC", (Object)this.sourceDbHandler.getDbType());
        List futures = this.loadThroughJDBC();
        futures.forEach(f -> {
            try {
                f.get();
            }
            catch (InterruptedException | ExecutionException e) {
                throw new RuntimeException(e);
            }
        });
    }

    public void init() throws SQLException {
        super.init();
        this.catalogHandler.initializeForFullLoad();
    }

    public void finalizeSqloader() throws SQLException {
        LogManager.setStatus((String)String.valueOf(RequestPhase.FINALIZE));
        this.managedThreads.shutdownManagedThreads();
        super.finalizeSqloader();
    }

    public void renameFullTables() {
        RequestData requestData = (RequestData)this.hazelcastService.getRequests().get((Object)this.requestId);
        if (!this.params.getDrop().booleanValue() && !this.params.getTruncate().booleanValue() || !requestData.getFinalStatus().equals(RequestStatus.SUCCEEDED.name())) {
            return;
        }
        CleanupStrategy cleanupStrategy = this.sqreamVersionsFactory.getFullLoadCleanupStrategyByVersion(this.sqreamDbHandler);
        cleanupStrategy.cleanup(this.params);
    }

    private List<Future<?>> loadThroughJDBC() throws SQLException, InterruptedException {
        List srcColumnDataList = this.sourceDbHandler.getColumnsData();
        this.fixUnexpectedIdentifier(srcColumnDataList, DBType.SQREAM);
        this.sourceDbHandler.addColumnsAccordingConfiguration(srcColumnDataList);
        this.initializeSqreamTable(srcColumnDataList);
        Map columnTypesOfTarget = this.sqreamDbHandler.getColumnTypesOfTarget();
        return this.load2SQream(srcColumnDataList, columnTypesOfTarget);
    }

    private void initializeSqreamTable(List<ColumnData> srcColumnDataList) throws SQLException {
        List creationColumnDataList = this.params.getTypeMapping().getTargetColumnsType(DBType.SQREAM, this.sourceDbHandler.getDbType(), srcColumnDataList, this.params.getCaseSensitive().booleanValue());
        if (this.params.getDrop().booleanValue()) {
            this.sqreamDbHandler.createTable(creationColumnDataList, true);
        } else {
            if (!this.sqreamDbHandler.isTableExist(this.params.getSqreamSchema(), this.params.getSqreamTable())) {
                String errMsg = MessageFormat.format("Target table {0} doesn''t not exist. Please create it first or define 'drop' param as 'true'", this.params.getSqreamTableNameFull());
                throw new SqloadRuntimeException(errMsg, ExitCode.TARGET_TABLE_CREATION_ERROR, this.requestId);
            }
            if (this.params.getTruncate().booleanValue()) {
                this.sqreamDbHandler.createFullTemp(this.params.getSqreamTableNameFull());
            }
        }
    }

    private List<Future<?>> load2SQream(List<ColumnData> columnsForSelect, Map<String, String> columnTypesOfTarget) throws SQLException, InterruptedException {
        Map queriesPerThread = this.sourceDbHandler.getSelectQueryList(columnsForSelect);
        int threadCount = this.sourceDbHandler.getThreadCount();
        this.logUtils.writeLogHeader("BEFORE STARTING INGESTION");
        ArrayList futures = new ArrayList();
        for (int threadId = 0; threadId < threadCount; ++threadId) {
            this.logUtils.writeLogHeader("QUERIES FOR THREAD " + threadId);
            List queriesForSingleThread = (List)queriesPerThread.get(threadId);
            ArrayList<String> selectQueryList = new ArrayList<String>();
            ArrayList<String> partitionList = new ArrayList<String>();
            for (int i = 0; i < queriesForSingleThread.size(); ++i) {
                SelectColumnData selectColumnData = (SelectColumnData)queriesForSingleThread.get(i);
                selectQueryList.add(this.sourceDbHandler.getSelectQuery(selectColumnData, this.params.getLoadDttmColumnName()));
                log.info("{} --> {}", (Object)threadId, selectQueryList.get(i));
                if (selectColumnData.getPartitionName() == null) continue;
                partitionList.add(selectColumnData.getPartitionName());
            }
            if (partitionList.isEmpty()) {
                partitionList = null;
            }
            futures.add(this.managedThreads.execute(new LoadRowDataExecuter(columnsForSelect, this.sourceDbHandler.getConnectionString(), this.sqreamDbHandler.getConnectionString(), selectQueryList, this.params.getFetchSize().intValue(), this.params.getBatchSize().intValue(), this.params.getUseDbmsLob().booleanValue(), this.sourceDbHandler.getDbType(), this.sqreamDbHandler.getFullTableName(), partitionList, columnTypesOfTarget, this.params.getCaseSensitive().booleanValue(), this.params.getTypeMapping(), this.params.getLoadDttmColumnName(), this.requestId)));
        }
        return futures;
    }
}

