/*
 * Decompiled with CFR 0.152.
 */
package com.sqream.sqloaderService.loaders;

import com.sqream.sqloader.common.dto.RequestData;
import com.sqream.sqloader.common.enums.DBType;
import com.sqream.sqloaderService.dbhandler.SourceDbHandler;
import com.sqream.sqloaderService.dbhandler.SqreamDbHandler;
import com.sqream.sqloaderService.dbhandler.cdc.AbstractCatalogHandler;
import com.sqream.sqloaderService.dto.ColumnData;
import com.sqream.sqloaderService.dto.CreationColumnData;
import com.sqream.sqloaderService.dto.Params;
import com.sqream.sqloaderService.enums.ExitCode;
import com.sqream.sqloaderService.enums.TableType;
import com.sqream.sqloaderService.exceptions.SystemValidatorException;
import com.sqream.sqloaderService.loaders.AbstractLoader;
import com.sqream.sqloaderService.loaders.LoadRowDataExecuter;
import com.sqream.sqloaderService.loaders.Loader;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CdcLoader
extends AbstractLoader
implements Loader {
    private static final Logger log = LoggerFactory.getLogger(CdcLoader.class);

    public CdcLoader(SourceDbHandler sourceDbHandler, SqreamDbHandler sqreamDbHandler, Params params, AbstractCatalogHandler catalogHandler) {
        super(sourceDbHandler, sqreamDbHandler, params, catalogHandler);
    }

    public void loadToSqream() throws SQLException, InterruptedException {
        if (!this.catalogHandler.isNewRecordsAdded()) {
            log.trace("No new records added");
            return;
        }
        List srcColumnDataList = this.sourceDbHandler.getColumnsDataCopy();
        this.fixUnexpectedIdentifier(srcColumnDataList, DBType.SQREAM);
        List targetColumnsType = this.params.getTypeMapping().getTargetColumnsType(DBType.SQREAM, this.sourceDbHandler.getDbType(), srcColumnDataList, this.params.getCaseSensitive().booleanValue());
        Map columnTypesOfTarget = this.sqreamDbHandler.getColumnTypesOfTarget();
        this.logUtils.writeLogHeader("LOAD ROWS TO STG TABLE");
        this.loadToStg(columnTypesOfTarget, targetColumnsType);
        log.info("Load rows to Stg table finished successfully");
        this.logUtils.writeLogHeader("");
        this.catalogHandler.apply();
        log.info("Apply {} finished successfully", (Object)this.catalogHandler.getTableType());
    }

    public void init() throws SQLException {
        super.init();
        this.validateTargetTables();
        this.initAndValidate();
        this.catalogHandler.printCatalogParameters();
    }

    public void validate() throws SystemValidatorException {
        super.validate();
        this.validateTableType();
    }

    public void renameFullTables() {
    }

    public void validateTableType() throws SystemValidatorException {
        if (this.catalogHandler.getTableType() == TableType.INC || this.catalogHandler.getTableType() == TableType.STD) {
            RequestData requestData = (RequestData)this.hazelcastService.getRequests().get((Object)this.requestId);
            requestData.setStatusCode(Integer.valueOf(ExitCode.CDC_PRECHECK_ERROR));
            this.hazelcastService.getRequests().put((Object)this.requestId, (Object)requestData);
            throw new SystemValidatorException("Load type is CDC while table type according Catalog table is " + String.valueOf(this.catalogHandler.getTableType()), requestData.getStatusCode().intValue(), this.requestId);
        }
    }

    public void validateTargetTables() throws SystemValidatorException {
        if (!this.sqreamDbHandler.isTableExist(this.sqreamDbHandler.getTableConfigData().getSchemaName(), this.sqreamDbHandler.getSqreamFinalTableName())) {
            String errMsg = MessageFormat.format("{0}.{1} table doesn''t exist in SQream DB, try to run SQLoader with loadType = ''full'' first", this.sqreamDbHandler.getTableConfigData().getSchemaName(), this.sqreamDbHandler.getSqreamFinalTableName());
            throw new SystemValidatorException(errMsg, ExitCode.CDC_APPLY_ERROR, this.requestId);
        }
        if (!this.sqreamDbHandler.isTableExist(this.sqreamDbHandler.getTableConfigData().getSchemaName(), this.sqreamDbHandler.getTableConfigData().getTableName())) {
            String errMsg = MessageFormat.format("{0}.{1} table doesn''t exist in SQream DB, try to run SQLoader with loadType = ''full'' first", this.sqreamDbHandler.getTableConfigData().getSchemaName(), this.sqreamDbHandler.getTableConfigData().getTableName());
            throw new SystemValidatorException(errMsg, ExitCode.CDC_APPLY_ERROR, this.requestId);
        }
    }

    private void initAndValidate() throws SQLException {
        this.catalogHandler.initialize();
        this.validatePrimaryKey();
    }

    public void validatePrimaryKey() {
        if (!this.catalogHandler.isTherePrimaryKey()) {
            StringBuilder sb = new StringBuilder();
            String errMsg = MessageFormat.format("No primary key found for source table [{0}] in catalog table [sqloader.cdc_table_primary_keys]. ", this.sourceDbHandler.getFullTableName());
            sb.append("You should identify primary keys for CDC operations. ");
            String sampleCommand = "Sample command:\tinsert into sqloader.cdc_table_primary_keys VALUES ('" + this.sourceDbHandler.getConfigSourceDbName() + "', '" + this.sourceDbHandler.getTableConfigData().getSchemaName() + "', '" + this.sourceDbHandler.getTableConfigData().getTableName() + "', '" + this.sourceDbHandler.getFullTableName() + "', '[ORA_KEY_NAME]', '[COL_NAME]')";
            sb.append(sampleCommand);
            throw new SystemValidatorException(sb.toString(), ExitCode.CDC_CANNOT_FIND_PRIMARY_COLUMNS, this.requestId);
        }
    }

    public void loadToStg(Map<String, String> columnTypesOfTarget, List<CreationColumnData> targetColumnsType) throws SQLException {
        log.info("Truncate {} table first", (Object)this.sqreamDbHandler.getFullTableName());
        this.sqreamDbHandler.truncateTable(this.sqreamDbHandler.getFullTableName());
        log.info("Load data to {} is starting", (Object)this.sqreamDbHandler.getFullTableName());
        String queryForSelect = this.catalogHandler.getSelectCatalogQueryForCopy();
        log.info("Catalog query for loading: {}", (Object)queryForSelect);
        List columnsData = this.sourceDbHandler.getCdcColumnsData(this.catalogHandler.getColumnDataCdcList());
        LoadRowDataExecuter loadRowDataService = this.getLoadRowDataExecuter(columnTypesOfTarget, queryForSelect, columnsData);
        log.info("Starting to fetch rows to {} table", (Object)this.sqreamDbHandler.getFullTableName());
        loadRowDataService.run();
    }

    @NotNull
    public LoadRowDataExecuter getLoadRowDataExecuter(Map<String, String> columnTypesOfTarget, String queryForSelect, List<ColumnData> columnsData) throws SQLException {
        ArrayList<String> queriesToRun = new ArrayList<String>();
        queriesToRun.add(queryForSelect);
        return new LoadRowDataExecuter(columnsData, this.sourceDbHandler.getConnectionString(), this.sqreamDbHandler.getConnectionString(), queriesToRun, this.params.getFetchSize().intValue(), this.params.getBatchSize().intValue(), this.params.getUseDbmsLob().booleanValue(), this.sourceDbHandler.getDbType(), this.sqreamDbHandler.getFullTableName(), null, columnTypesOfTarget, this.params.getCaseSensitive().booleanValue(), this.params.getTypeMapping(), this.params.getLoadDttmColumnName(), this.requestId);
    }
}

