/*
 * Decompiled with CFR 0.152.
 */
package com.sqream.sqloaderService.loaders;

import com.sqream.sqloader.common.dto.RequestData;
import com.sqream.sqloader.common.enums.DBType;
import com.sqream.sqloader.common.service.HazelcastService;
import com.sqream.sqloaderService.configuration.BeanUtil;
import com.sqream.sqloaderService.dbhandler.SourceDbHandler;
import com.sqream.sqloaderService.dbhandler.SqreamDbHandler;
import com.sqream.sqloaderService.dbhandler.cdc.AbstractCatalogHandler;
import com.sqream.sqloaderService.dto.ColumnData;
import com.sqream.sqloaderService.dto.Params;
import com.sqream.sqloaderService.enums.ExitCode;
import com.sqream.sqloaderService.enums.RequestPhase;
import com.sqream.sqloaderService.exceptions.SystemValidatorException;
import com.sqream.sqloaderService.loaders.Loader;
import com.sqream.sqloaderService.logging.LogManager;
import com.sqream.sqloaderService.monitor.MonitorService;
import com.sqream.sqloaderService.service.SqloaderHazelcastService;
import com.sqream.sqloaderService.utils.ExitCodeUtils;
import com.sqream.sqloaderService.utils.LogUtils;
import com.sqream.sqloaderService.utils.StrUtils;
import java.sql.SQLException;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractLoader
implements Loader {
    private static final Logger log = LoggerFactory.getLogger(AbstractLoader.class);
    StrUtils strUtils;
    LogUtils logUtils;
    Params params;
    SourceDbHandler sourceDbHandler;
    SqreamDbHandler sqreamDbHandler;
    String requestId;
    AbstractCatalogHandler catalogHandler;
    HazelcastService hazelcastService;
    MonitorService monitorService;
    SqloaderHazelcastService sqloaderHazelcastService;
    List<ColumnData> srcColumnDataList;

    public AbstractLoader(SourceDbHandler sourceDbHandler, SqreamDbHandler sqreamDbHandler, Params params, AbstractCatalogHandler catalogHandler) {
        this.params = params;
        this.strUtils = (StrUtils)BeanUtil.getBean(StrUtils.class);
        this.logUtils = (LogUtils)BeanUtil.getBean(LogUtils.class);
        this.sourceDbHandler = sourceDbHandler;
        this.sqreamDbHandler = sqreamDbHandler;
        this.requestId = params.getRequestId();
        this.hazelcastService = (HazelcastService)BeanUtil.getBean(HazelcastService.class);
        this.sqloaderHazelcastService = (SqloaderHazelcastService)BeanUtil.getBean(SqloaderHazelcastService.class);
        this.catalogHandler = catalogHandler;
        this.monitorService = (MonitorService)BeanUtil.getBean(MonitorService.class);
    }

    public void init() throws SQLException {
        this.sourceDbHandler.init();
        this.sqreamDbHandler.init();
        this.catalogHandler.validateSummaryTableExists();
    }

    public void validate() throws SystemValidatorException {
        log.info("Required Load type from user is {}, while table type according Catalog table is {}", (Object)this.params.getLoadType(), (Object)this.catalogHandler.getTableType());
    }

    public void fixUnexpectedIdentifier(List<ColumnData> columnsDataList, DBType dbType) {
        for (ColumnData columnData : columnsDataList) {
            columnData.setColName(this.strUtils.formatColumnName(columnData.getColName(), dbType, this.params.getCaseSensitive().booleanValue(), this.params.getLoadDttmColumnName()));
        }
    }

    public abstract void renameFullTables();

    public void finalizeSqloader() throws SQLException {
        RequestData requestData = (RequestData)this.hazelcastService.getRequests().get((Object)this.requestId);
        LogManager.setStatus((String)String.valueOf(RequestPhase.FINALIZE));
        requestData.setStatusPhase(String.valueOf(RequestPhase.FINALIZE));
        requestData.setLoadFinishTime(Long.valueOf(System.currentTimeMillis()));
        requestData.setFinalStatus(ExitCodeUtils.getRealStatus((int)requestData.getStatusCode()));
        this.hazelcastService.getRequests().put((Object)this.requestId, (Object)requestData);
        this.renameFullTables();
        requestData = (RequestData)this.hazelcastService.getRequests().get((Object)this.requestId);
        requestData.setFinalStatus(ExitCodeUtils.getRealStatus((int)requestData.getStatusCode()));
        this.hazelcastService.getRequests().put((Object)this.requestId, (Object)requestData);
        try {
            this.catalogHandler.finalizeCatalog();
        }
        catch (Exception e) {
            requestData = (RequestData)this.hazelcastService.getRequests().get((Object)this.requestId);
            requestData.setFinalStatus(ExitCodeUtils.getRealStatus((int)ExitCode.FAILED));
            this.hazelcastService.getRequests().put((Object)this.requestId, (Object)requestData);
            this.saveToMonitor();
            throw e;
        }
        this.saveToMonitor();
    }

    private void saveToMonitor() throws SQLException {
        try {
            log.info("Adding Record To Summary Table");
            this.monitorService.saveToMonitor(this.catalogHandler, this.sourceDbHandler, this.params, this.requestId);
        }
        finally {
            RequestData requestData = (RequestData)this.hazelcastService.getRequests().get((Object)this.requestId);
            requestData.setStatusPhase(String.valueOf(RequestPhase.DONE));
            this.hazelcastService.getRequests().put((Object)this.requestId, (Object)requestData);
            LogManager.setStatus((String)String.valueOf(RequestPhase.DONE));
        }
    }

    public List<ColumnData> getSrcColumnDataList() {
        return this.srcColumnDataList;
    }
}

