/*
 * Decompiled with CFR 0.152.
 */
package com.sqream.sqloaderService.dto;

import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.DataSerializable;
import com.sqream.sqloader.common.enums.DBType;
import com.sqream.sqloader.common.enums.LoadType;
import com.sqream.sqloader.common.utils.CommonStrUtils;
import com.sqream.sqloaderService.dto.Params;
import com.sqream.sqloaderService.typemapping.TypeMappingService;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Value;

public class Params
implements DataSerializable,
Comparable<Params> {
    public String projectVersion;
    private String sqreamJdbcVersion;
    private String oracleJdbcVersion;
    private String postgresJdbcVersion;
    private String mssqlJdbcVersion;
    private String sapJdbcVersion;
    private String teradataJdbcVersion;
    private String sybaseJdbcVersion;
    public String configFile;
    public String configDir;
    public String connectionStringSqream;
    public String connectionStringSource;
    public String connectionStringCatalog;
    public String cdcCatalogTable;
    public String cdcTrackingTable;
    public String cdcPrimaryKeyTable;
    public String loadSummaryTable;
    public String loadTypeName;
    public Boolean caseSensitive;
    public String sourceDatabaseName;
    public String sourceSchema;
    public String sourceTable;
    public String sourceTableNameFull;
    public String sqreamDatabaseName;
    public String sqreamSchema;
    public String sqreamTable;
    public String sqreamTableStg;
    public String sqreamTableTemp;
    public String sqreamTableOld;
    public String sqreamTableNameFull;
    public String sqreamTableNameFullStg;
    public String sqreamTableNameFullTemp;
    public String sqreamTableNameFullOld;
    public Boolean rowid;
    public Integer threadCount;
    public String splitByColumn;
    public Integer chunkSize;
    public Boolean usePartitions;
    public Integer limit;
    public Boolean count;
    public String filter;
    public Boolean drop;
    public Boolean truncate;
    public String columnListFilePath;
    public String selectedColumns;
    public Boolean cdcDelete;
    public Boolean lockTable;
    public Boolean lockCheck;
    public Boolean loadDttm;
    public String loadDttmColumnName;
    public Boolean useDbmsLob;
    public String logDir;
    public DBType sourceDbType;
    public DBType catalogDbType;
    public LoadType loadType;
    public String partitionName;
    public Integer batchSize;
    public Integer fetchSize;
    public Boolean checkCdcChain;
    public Boolean validateSourceTable;
    public String typeMappingPath;
    public String reservedWordPath;
    public TypeMappingService typeMapping;
    public List<String> reservedWordsList;
    public List<String> columnList;
    public String requestedHost;
    public String acquiredHost;
    public String clientIp;
    public String requestId;
    public String requestHash;
    public String sqreamRequestHash;
    public Integer validationCode;
    @Value(value="${clustered:#{true}}")
    public Boolean clustered;
    public Boolean warnOnIncLoadFilterChanges;
    public Boolean autoCreateNewNullableColumn;

    public String toString() {
        StringBuilder sb = new StringBuilder("Load Parameters (");
        try {
            for (Field field : this.getClass().getDeclaredFields()) {
                field.setAccessible(true);
                String fieldName = field.getName();
                Object fieldValue = field.get(this);
                if (fieldName.contains("connectionString")) {
                    fieldValue = CommonStrUtils.maskConnectionString((String)((String)fieldValue));
                }
                sb.append(fieldName).append(": ").append(fieldValue).append(", ");
            }
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        return sb.delete(sb.length() - 2, sb.length()).append(')').toString();
    }

    public void writeData(ObjectDataOutput out) throws IOException {
        out.writeString(this.projectVersion);
        out.writeString(this.sqreamJdbcVersion);
        out.writeString(this.oracleJdbcVersion);
        out.writeString(this.postgresJdbcVersion);
        out.writeString(this.mssqlJdbcVersion);
        out.writeString(this.sapJdbcVersion);
        out.writeString(this.teradataJdbcVersion);
        out.writeString(this.sybaseJdbcVersion);
        out.writeString(this.configFile);
        out.writeString(this.configDir);
        out.writeString(this.connectionStringSqream);
        out.writeString(this.connectionStringSource);
        out.writeString(this.connectionStringCatalog);
        out.writeString(this.cdcCatalogTable);
        out.writeString(this.cdcTrackingTable);
        out.writeString(this.cdcPrimaryKeyTable);
        out.writeString(this.loadSummaryTable);
        out.writeString(this.loadTypeName);
        out.writeBoolean(this.caseSensitive.booleanValue());
        out.writeString(this.sourceDatabaseName);
        out.writeString(this.sourceSchema);
        out.writeString(this.sourceTable);
        out.writeString(this.sourceTableNameFull);
        out.writeString(this.sqreamDatabaseName);
        out.writeString(this.sqreamSchema);
        out.writeString(this.sqreamTable);
        out.writeString(this.sqreamTableStg);
        out.writeString(this.sqreamTableTemp);
        out.writeString(this.sqreamTableOld);
        out.writeString(this.sqreamTableNameFull);
        out.writeString(this.sqreamTableNameFullStg);
        out.writeString(this.sqreamTableNameFullTemp);
        out.writeString(this.sqreamTableNameFullOld);
        out.writeBoolean(this.rowid.booleanValue());
        out.writeInt(this.threadCount.intValue());
        out.writeString(this.splitByColumn);
        out.writeInt(this.chunkSize.intValue());
        out.writeBoolean(this.usePartitions.booleanValue());
        out.writeInt(this.limit.intValue());
        out.writeBoolean(this.count.booleanValue());
        out.writeString(this.filter);
        out.writeBoolean(this.drop.booleanValue());
        out.writeBoolean(this.truncate.booleanValue());
        out.writeString(this.columnListFilePath);
        out.writeString(this.selectedColumns);
        out.writeBoolean(this.cdcDelete.booleanValue());
        out.writeBoolean(this.lockTable.booleanValue());
        out.writeBoolean(this.lockCheck.booleanValue());
        out.writeBoolean(this.loadDttm.booleanValue());
        out.writeString(this.loadDttmColumnName);
        out.writeBoolean(this.useDbmsLob.booleanValue());
        out.writeString(this.logDir);
        out.writeObject((Object)this.sourceDbType);
        out.writeObject((Object)this.catalogDbType);
        out.writeObject((Object)this.loadType);
        out.writeString(this.partitionName);
        out.writeInt(this.batchSize.intValue());
        out.writeInt(this.fetchSize.intValue());
        out.writeBoolean(this.checkCdcChain.booleanValue());
        out.writeBoolean(this.validateSourceTable.booleanValue());
        out.writeString(this.typeMappingPath);
        out.writeString(this.reservedWordPath);
        this.typeMapping.writeData(out);
        out.writeObject((Object)this.reservedWordsList);
        out.writeObject((Object)this.columnList);
        out.writeString(this.requestedHost);
        out.writeString(this.acquiredHost);
        out.writeString(this.clientIp);
        out.writeString(this.requestId);
        out.writeString(this.requestHash);
        out.writeString(this.sqreamRequestHash);
        out.writeBoolean(this.clustered.booleanValue());
        out.writeBoolean(this.warnOnIncLoadFilterChanges.booleanValue());
        out.writeBoolean(this.autoCreateNewNullableColumn.booleanValue());
    }

    public void readData(ObjectDataInput in) throws IOException {
        this.projectVersion = in.readString();
        this.sqreamJdbcVersion = in.readString();
        this.oracleJdbcVersion = in.readString();
        this.postgresJdbcVersion = in.readString();
        this.mssqlJdbcVersion = in.readString();
        this.sapJdbcVersion = in.readString();
        this.teradataJdbcVersion = in.readString();
        this.sybaseJdbcVersion = in.readString();
        this.configFile = in.readString();
        this.configDir = in.readString();
        this.connectionStringSqream = in.readString();
        this.connectionStringSource = in.readString();
        this.connectionStringCatalog = in.readString();
        this.cdcCatalogTable = in.readString();
        this.cdcTrackingTable = in.readString();
        this.cdcPrimaryKeyTable = in.readString();
        this.loadSummaryTable = in.readString();
        this.loadTypeName = in.readString();
        this.caseSensitive = in.readBoolean();
        this.sourceDatabaseName = in.readString();
        this.sourceSchema = in.readString();
        this.sourceTable = in.readString();
        this.sourceTableNameFull = in.readString();
        this.sqreamDatabaseName = in.readString();
        this.sqreamSchema = in.readString();
        this.sqreamTable = in.readString();
        this.sqreamTableStg = in.readString();
        this.sqreamTableTemp = in.readString();
        this.sqreamTableOld = in.readString();
        this.sqreamTableNameFull = in.readString();
        this.sqreamTableNameFullStg = in.readString();
        this.sqreamTableNameFullTemp = in.readString();
        this.sqreamTableNameFullOld = in.readString();
        this.rowid = in.readBoolean();
        this.threadCount = in.readInt();
        this.splitByColumn = in.readString();
        this.chunkSize = in.readInt();
        this.usePartitions = in.readBoolean();
        this.limit = in.readInt();
        this.count = in.readBoolean();
        this.filter = in.readString();
        this.drop = in.readBoolean();
        this.truncate = in.readBoolean();
        this.columnListFilePath = in.readString();
        this.selectedColumns = in.readString();
        this.cdcDelete = in.readBoolean();
        this.lockTable = in.readBoolean();
        this.lockCheck = in.readBoolean();
        this.loadDttm = in.readBoolean();
        this.loadDttmColumnName = in.readString();
        this.useDbmsLob = in.readBoolean();
        this.logDir = in.readString();
        this.sourceDbType = (DBType)in.readObject();
        this.catalogDbType = (DBType)in.readObject();
        this.loadType = (LoadType)in.readObject();
        this.partitionName = in.readString();
        this.batchSize = in.readInt();
        this.fetchSize = in.readInt();
        this.checkCdcChain = in.readBoolean();
        this.validateSourceTable = in.readBoolean();
        this.typeMappingPath = in.readString();
        this.reservedWordPath = in.readString();
        this.typeMapping = new TypeMappingService();
        this.typeMapping.readData(in);
        this.reservedWordsList = (List)in.readObject();
        this.columnList = (List)in.readObject();
        this.requestedHost = in.readString();
        this.acquiredHost = in.readString();
        this.clientIp = in.readString();
        this.requestId = in.readString();
        this.requestHash = in.readString();
        this.sqreamRequestHash = in.readString();
        this.clustered = in.readBoolean();
        this.warnOnIncLoadFilterChanges = in.readBoolean();
        this.autoCreateNewNullableColumn = in.readBoolean();
    }

    @Override
    public int compareTo(@NotNull Params o) {
        if (o.equals((Object)this)) {
            return 0;
        }
        return 1;
    }

    public static ParamsBuilder builder() {
        return new ParamsBuilder();
    }

    public Params() {
    }

    public Params(String projectVersion, String sqreamJdbcVersion, String oracleJdbcVersion, String postgresJdbcVersion, String mssqlJdbcVersion, String sapJdbcVersion, String teradataJdbcVersion, String sybaseJdbcVersion, String configFile, String configDir, String connectionStringSqream, String connectionStringSource, String connectionStringCatalog, String cdcCatalogTable, String cdcTrackingTable, String cdcPrimaryKeyTable, String loadSummaryTable, String loadTypeName, Boolean caseSensitive, String sourceDatabaseName, String sourceSchema, String sourceTable, String sourceTableNameFull, String sqreamDatabaseName, String sqreamSchema, String sqreamTable, String sqreamTableStg, String sqreamTableTemp, String sqreamTableOld, String sqreamTableNameFull, String sqreamTableNameFullStg, String sqreamTableNameFullTemp, String sqreamTableNameFullOld, Boolean rowid, Integer threadCount, String splitByColumn, Integer chunkSize, Boolean usePartitions, Integer limit, Boolean count, String filter, Boolean drop, Boolean truncate, String columnListFilePath, String selectedColumns, Boolean cdcDelete, Boolean lockTable, Boolean lockCheck, Boolean loadDttm, String loadDttmColumnName, Boolean useDbmsLob, String logDir, DBType sourceDbType, DBType catalogDbType, LoadType loadType, String partitionName, Integer batchSize, Integer fetchSize, Boolean checkCdcChain, Boolean validateSourceTable, String typeMappingPath, String reservedWordPath, TypeMappingService typeMapping, List<String> reservedWordsList, List<String> columnList, String requestedHost, String acquiredHost, String clientIp, String requestId, String requestHash, String sqreamRequestHash, Integer validationCode, Boolean clustered, Boolean warnOnIncLoadFilterChanges, Boolean autoCreateNewNullableColumn) {
        this.projectVersion = projectVersion;
        this.sqreamJdbcVersion = sqreamJdbcVersion;
        this.oracleJdbcVersion = oracleJdbcVersion;
        this.postgresJdbcVersion = postgresJdbcVersion;
        this.mssqlJdbcVersion = mssqlJdbcVersion;
        this.sapJdbcVersion = sapJdbcVersion;
        this.teradataJdbcVersion = teradataJdbcVersion;
        this.sybaseJdbcVersion = sybaseJdbcVersion;
        this.configFile = configFile;
        this.configDir = configDir;
        this.connectionStringSqream = connectionStringSqream;
        this.connectionStringSource = connectionStringSource;
        this.connectionStringCatalog = connectionStringCatalog;
        this.cdcCatalogTable = cdcCatalogTable;
        this.cdcTrackingTable = cdcTrackingTable;
        this.cdcPrimaryKeyTable = cdcPrimaryKeyTable;
        this.loadSummaryTable = loadSummaryTable;
        this.loadTypeName = loadTypeName;
        this.caseSensitive = caseSensitive;
        this.sourceDatabaseName = sourceDatabaseName;
        this.sourceSchema = sourceSchema;
        this.sourceTable = sourceTable;
        this.sourceTableNameFull = sourceTableNameFull;
        this.sqreamDatabaseName = sqreamDatabaseName;
        this.sqreamSchema = sqreamSchema;
        this.sqreamTable = sqreamTable;
        this.sqreamTableStg = sqreamTableStg;
        this.sqreamTableTemp = sqreamTableTemp;
        this.sqreamTableOld = sqreamTableOld;
        this.sqreamTableNameFull = sqreamTableNameFull;
        this.sqreamTableNameFullStg = sqreamTableNameFullStg;
        this.sqreamTableNameFullTemp = sqreamTableNameFullTemp;
        this.sqreamTableNameFullOld = sqreamTableNameFullOld;
        this.rowid = rowid;
        this.threadCount = threadCount;
        this.splitByColumn = splitByColumn;
        this.chunkSize = chunkSize;
        this.usePartitions = usePartitions;
        this.limit = limit;
        this.count = count;
        this.filter = filter;
        this.drop = drop;
        this.truncate = truncate;
        this.columnListFilePath = columnListFilePath;
        this.selectedColumns = selectedColumns;
        this.cdcDelete = cdcDelete;
        this.lockTable = lockTable;
        this.lockCheck = lockCheck;
        this.loadDttm = loadDttm;
        this.loadDttmColumnName = loadDttmColumnName;
        this.useDbmsLob = useDbmsLob;
        this.logDir = logDir;
        this.sourceDbType = sourceDbType;
        this.catalogDbType = catalogDbType;
        this.loadType = loadType;
        this.partitionName = partitionName;
        this.batchSize = batchSize;
        this.fetchSize = fetchSize;
        this.checkCdcChain = checkCdcChain;
        this.validateSourceTable = validateSourceTable;
        this.typeMappingPath = typeMappingPath;
        this.reservedWordPath = reservedWordPath;
        this.typeMapping = typeMapping;
        this.reservedWordsList = reservedWordsList;
        this.columnList = columnList;
        this.requestedHost = requestedHost;
        this.acquiredHost = acquiredHost;
        this.clientIp = clientIp;
        this.requestId = requestId;
        this.requestHash = requestHash;
        this.sqreamRequestHash = sqreamRequestHash;
        this.validationCode = validationCode;
        this.clustered = clustered;
        this.warnOnIncLoadFilterChanges = warnOnIncLoadFilterChanges;
        this.autoCreateNewNullableColumn = autoCreateNewNullableColumn;
    }

    public String getProjectVersion() {
        return this.projectVersion;
    }

    public String getSqreamJdbcVersion() {
        return this.sqreamJdbcVersion;
    }

    public String getOracleJdbcVersion() {
        return this.oracleJdbcVersion;
    }

    public String getPostgresJdbcVersion() {
        return this.postgresJdbcVersion;
    }

    public String getMssqlJdbcVersion() {
        return this.mssqlJdbcVersion;
    }

    public String getSapJdbcVersion() {
        return this.sapJdbcVersion;
    }

    public String getTeradataJdbcVersion() {
        return this.teradataJdbcVersion;
    }

    public String getSybaseJdbcVersion() {
        return this.sybaseJdbcVersion;
    }

    public String getConfigFile() {
        return this.configFile;
    }

    public String getConfigDir() {
        return this.configDir;
    }

    public String getConnectionStringSqream() {
        return this.connectionStringSqream;
    }

    public String getConnectionStringSource() {
        return this.connectionStringSource;
    }

    public String getConnectionStringCatalog() {
        return this.connectionStringCatalog;
    }

    public String getCdcCatalogTable() {
        return this.cdcCatalogTable;
    }

    public String getCdcTrackingTable() {
        return this.cdcTrackingTable;
    }

    public String getCdcPrimaryKeyTable() {
        return this.cdcPrimaryKeyTable;
    }

    public String getLoadSummaryTable() {
        return this.loadSummaryTable;
    }

    public String getLoadTypeName() {
        return this.loadTypeName;
    }

    public Boolean getCaseSensitive() {
        return this.caseSensitive;
    }

    public String getSourceDatabaseName() {
        return this.sourceDatabaseName;
    }

    public String getSourceSchema() {
        return this.sourceSchema;
    }

    public String getSourceTable() {
        return this.sourceTable;
    }

    public String getSourceTableNameFull() {
        return this.sourceTableNameFull;
    }

    public String getSqreamDatabaseName() {
        return this.sqreamDatabaseName;
    }

    public String getSqreamSchema() {
        return this.sqreamSchema;
    }

    public String getSqreamTable() {
        return this.sqreamTable;
    }

    public String getSqreamTableStg() {
        return this.sqreamTableStg;
    }

    public String getSqreamTableTemp() {
        return this.sqreamTableTemp;
    }

    public String getSqreamTableOld() {
        return this.sqreamTableOld;
    }

    public String getSqreamTableNameFull() {
        return this.sqreamTableNameFull;
    }

    public String getSqreamTableNameFullStg() {
        return this.sqreamTableNameFullStg;
    }

    public String getSqreamTableNameFullTemp() {
        return this.sqreamTableNameFullTemp;
    }

    public String getSqreamTableNameFullOld() {
        return this.sqreamTableNameFullOld;
    }

    public Boolean getRowid() {
        return this.rowid;
    }

    public Integer getThreadCount() {
        return this.threadCount;
    }

    public String getSplitByColumn() {
        return this.splitByColumn;
    }

    public Integer getChunkSize() {
        return this.chunkSize;
    }

    public Boolean getUsePartitions() {
        return this.usePartitions;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public Boolean getCount() {
        return this.count;
    }

    public String getFilter() {
        return this.filter;
    }

    public Boolean getDrop() {
        return this.drop;
    }

    public Boolean getTruncate() {
        return this.truncate;
    }

    public String getColumnListFilePath() {
        return this.columnListFilePath;
    }

    public String getSelectedColumns() {
        return this.selectedColumns;
    }

    public Boolean getCdcDelete() {
        return this.cdcDelete;
    }

    public Boolean getLockTable() {
        return this.lockTable;
    }

    public Boolean getLockCheck() {
        return this.lockCheck;
    }

    public Boolean getLoadDttm() {
        return this.loadDttm;
    }

    public String getLoadDttmColumnName() {
        return this.loadDttmColumnName;
    }

    public Boolean getUseDbmsLob() {
        return this.useDbmsLob;
    }

    public String getLogDir() {
        return this.logDir;
    }

    public DBType getSourceDbType() {
        return this.sourceDbType;
    }

    public DBType getCatalogDbType() {
        return this.catalogDbType;
    }

    public LoadType getLoadType() {
        return this.loadType;
    }

    public String getPartitionName() {
        return this.partitionName;
    }

    public Integer getBatchSize() {
        return this.batchSize;
    }

    public Integer getFetchSize() {
        return this.fetchSize;
    }

    public Boolean getCheckCdcChain() {
        return this.checkCdcChain;
    }

    public Boolean getValidateSourceTable() {
        return this.validateSourceTable;
    }

    public String getTypeMappingPath() {
        return this.typeMappingPath;
    }

    public String getReservedWordPath() {
        return this.reservedWordPath;
    }

    public TypeMappingService getTypeMapping() {
        return this.typeMapping;
    }

    public List<String> getReservedWordsList() {
        return this.reservedWordsList;
    }

    public List<String> getColumnList() {
        return this.columnList;
    }

    public String getRequestedHost() {
        return this.requestedHost;
    }

    public String getAcquiredHost() {
        return this.acquiredHost;
    }

    public String getClientIp() {
        return this.clientIp;
    }

    public String getRequestId() {
        return this.requestId;
    }

    public String getRequestHash() {
        return this.requestHash;
    }

    public String getSqreamRequestHash() {
        return this.sqreamRequestHash;
    }

    public Integer getValidationCode() {
        return this.validationCode;
    }

    public Boolean getClustered() {
        return this.clustered;
    }

    public Boolean getWarnOnIncLoadFilterChanges() {
        return this.warnOnIncLoadFilterChanges;
    }

    public Boolean getAutoCreateNewNullableColumn() {
        return this.autoCreateNewNullableColumn;
    }

    public void setProjectVersion(String projectVersion) {
        this.projectVersion = projectVersion;
    }

    public void setSqreamJdbcVersion(String sqreamJdbcVersion) {
        this.sqreamJdbcVersion = sqreamJdbcVersion;
    }

    public void setOracleJdbcVersion(String oracleJdbcVersion) {
        this.oracleJdbcVersion = oracleJdbcVersion;
    }

    public void setPostgresJdbcVersion(String postgresJdbcVersion) {
        this.postgresJdbcVersion = postgresJdbcVersion;
    }

    public void setMssqlJdbcVersion(String mssqlJdbcVersion) {
        this.mssqlJdbcVersion = mssqlJdbcVersion;
    }

    public void setSapJdbcVersion(String sapJdbcVersion) {
        this.sapJdbcVersion = sapJdbcVersion;
    }

    public void setTeradataJdbcVersion(String teradataJdbcVersion) {
        this.teradataJdbcVersion = teradataJdbcVersion;
    }

    public void setSybaseJdbcVersion(String sybaseJdbcVersion) {
        this.sybaseJdbcVersion = sybaseJdbcVersion;
    }

    public void setConfigFile(String configFile) {
        this.configFile = configFile;
    }

    public void setConfigDir(String configDir) {
        this.configDir = configDir;
    }

    public void setConnectionStringSqream(String connectionStringSqream) {
        this.connectionStringSqream = connectionStringSqream;
    }

    public void setConnectionStringSource(String connectionStringSource) {
        this.connectionStringSource = connectionStringSource;
    }

    public void setConnectionStringCatalog(String connectionStringCatalog) {
        this.connectionStringCatalog = connectionStringCatalog;
    }

    public void setCdcCatalogTable(String cdcCatalogTable) {
        this.cdcCatalogTable = cdcCatalogTable;
    }

    public void setCdcTrackingTable(String cdcTrackingTable) {
        this.cdcTrackingTable = cdcTrackingTable;
    }

    public void setCdcPrimaryKeyTable(String cdcPrimaryKeyTable) {
        this.cdcPrimaryKeyTable = cdcPrimaryKeyTable;
    }

    public void setLoadSummaryTable(String loadSummaryTable) {
        this.loadSummaryTable = loadSummaryTable;
    }

    public void setLoadTypeName(String loadTypeName) {
        this.loadTypeName = loadTypeName;
    }

    public void setCaseSensitive(Boolean caseSensitive) {
        this.caseSensitive = caseSensitive;
    }

    public void setSourceDatabaseName(String sourceDatabaseName) {
        this.sourceDatabaseName = sourceDatabaseName;
    }

    public void setSourceSchema(String sourceSchema) {
        this.sourceSchema = sourceSchema;
    }

    public void setSourceTable(String sourceTable) {
        this.sourceTable = sourceTable;
    }

    public void setSourceTableNameFull(String sourceTableNameFull) {
        this.sourceTableNameFull = sourceTableNameFull;
    }

    public void setSqreamDatabaseName(String sqreamDatabaseName) {
        this.sqreamDatabaseName = sqreamDatabaseName;
    }

    public void setSqreamSchema(String sqreamSchema) {
        this.sqreamSchema = sqreamSchema;
    }

    public void setSqreamTable(String sqreamTable) {
        this.sqreamTable = sqreamTable;
    }

    public void setSqreamTableStg(String sqreamTableStg) {
        this.sqreamTableStg = sqreamTableStg;
    }

    public void setSqreamTableTemp(String sqreamTableTemp) {
        this.sqreamTableTemp = sqreamTableTemp;
    }

    public void setSqreamTableOld(String sqreamTableOld) {
        this.sqreamTableOld = sqreamTableOld;
    }

    public void setSqreamTableNameFull(String sqreamTableNameFull) {
        this.sqreamTableNameFull = sqreamTableNameFull;
    }

    public void setSqreamTableNameFullStg(String sqreamTableNameFullStg) {
        this.sqreamTableNameFullStg = sqreamTableNameFullStg;
    }

    public void setSqreamTableNameFullTemp(String sqreamTableNameFullTemp) {
        this.sqreamTableNameFullTemp = sqreamTableNameFullTemp;
    }

    public void setSqreamTableNameFullOld(String sqreamTableNameFullOld) {
        this.sqreamTableNameFullOld = sqreamTableNameFullOld;
    }

    public void setRowid(Boolean rowid) {
        this.rowid = rowid;
    }

    public void setThreadCount(Integer threadCount) {
        this.threadCount = threadCount;
    }

    public void setSplitByColumn(String splitByColumn) {
        this.splitByColumn = splitByColumn;
    }

    public void setChunkSize(Integer chunkSize) {
        this.chunkSize = chunkSize;
    }

    public void setUsePartitions(Boolean usePartitions) {
        this.usePartitions = usePartitions;
    }

    public void setLimit(Integer limit) {
        this.limit = limit;
    }

    public void setCount(Boolean count) {
        this.count = count;
    }

    public void setFilter(String filter) {
        this.filter = filter;
    }

    public void setDrop(Boolean drop) {
        this.drop = drop;
    }

    public void setTruncate(Boolean truncate) {
        this.truncate = truncate;
    }

    public void setColumnListFilePath(String columnListFilePath) {
        this.columnListFilePath = columnListFilePath;
    }

    public void setSelectedColumns(String selectedColumns) {
        this.selectedColumns = selectedColumns;
    }

    public void setCdcDelete(Boolean cdcDelete) {
        this.cdcDelete = cdcDelete;
    }

    public void setLockTable(Boolean lockTable) {
        this.lockTable = lockTable;
    }

    public void setLockCheck(Boolean lockCheck) {
        this.lockCheck = lockCheck;
    }

    public void setLoadDttm(Boolean loadDttm) {
        this.loadDttm = loadDttm;
    }

    public void setLoadDttmColumnName(String loadDttmColumnName) {
        this.loadDttmColumnName = loadDttmColumnName;
    }

    public void setUseDbmsLob(Boolean useDbmsLob) {
        this.useDbmsLob = useDbmsLob;
    }

    public void setLogDir(String logDir) {
        this.logDir = logDir;
    }

    public void setSourceDbType(DBType sourceDbType) {
        this.sourceDbType = sourceDbType;
    }

    public void setCatalogDbType(DBType catalogDbType) {
        this.catalogDbType = catalogDbType;
    }

    public void setLoadType(LoadType loadType) {
        this.loadType = loadType;
    }

    public void setPartitionName(String partitionName) {
        this.partitionName = partitionName;
    }

    public void setBatchSize(Integer batchSize) {
        this.batchSize = batchSize;
    }

    public void setFetchSize(Integer fetchSize) {
        this.fetchSize = fetchSize;
    }

    public void setCheckCdcChain(Boolean checkCdcChain) {
        this.checkCdcChain = checkCdcChain;
    }

    public void setValidateSourceTable(Boolean validateSourceTable) {
        this.validateSourceTable = validateSourceTable;
    }

    public void setTypeMappingPath(String typeMappingPath) {
        this.typeMappingPath = typeMappingPath;
    }

    public void setReservedWordPath(String reservedWordPath) {
        this.reservedWordPath = reservedWordPath;
    }

    public void setTypeMapping(TypeMappingService typeMapping) {
        this.typeMapping = typeMapping;
    }

    public void setReservedWordsList(List<String> reservedWordsList) {
        this.reservedWordsList = reservedWordsList;
    }

    public void setColumnList(List<String> columnList) {
        this.columnList = columnList;
    }

    public void setRequestedHost(String requestedHost) {
        this.requestedHost = requestedHost;
    }

    public void setAcquiredHost(String acquiredHost) {
        this.acquiredHost = acquiredHost;
    }

    public void setClientIp(String clientIp) {
        this.clientIp = clientIp;
    }

    public void setRequestId(String requestId) {
        this.requestId = requestId;
    }

    public void setRequestHash(String requestHash) {
        this.requestHash = requestHash;
    }

    public void setSqreamRequestHash(String sqreamRequestHash) {
        this.sqreamRequestHash = sqreamRequestHash;
    }

    public void setValidationCode(Integer validationCode) {
        this.validationCode = validationCode;
    }

    public void setClustered(Boolean clustered) {
        this.clustered = clustered;
    }

    public void setWarnOnIncLoadFilterChanges(Boolean warnOnIncLoadFilterChanges) {
        this.warnOnIncLoadFilterChanges = warnOnIncLoadFilterChanges;
    }

    public void setAutoCreateNewNullableColumn(Boolean autoCreateNewNullableColumn) {
        this.autoCreateNewNullableColumn = autoCreateNewNullableColumn;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Params)) {
            return false;
        }
        Params other = (Params)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Boolean this$caseSensitive = this.getCaseSensitive();
        Boolean other$caseSensitive = other.getCaseSensitive();
        if (this$caseSensitive == null ? other$caseSensitive != null : !((Object)this$caseSensitive).equals(other$caseSensitive)) {
            return false;
        }
        Boolean this$rowid = this.getRowid();
        Boolean other$rowid = other.getRowid();
        if (this$rowid == null ? other$rowid != null : !((Object)this$rowid).equals(other$rowid)) {
            return false;
        }
        Integer this$threadCount = this.getThreadCount();
        Integer other$threadCount = other.getThreadCount();
        if (this$threadCount == null ? other$threadCount != null : !((Object)this$threadCount).equals(other$threadCount)) {
            return false;
        }
        Integer this$chunkSize = this.getChunkSize();
        Integer other$chunkSize = other.getChunkSize();
        if (this$chunkSize == null ? other$chunkSize != null : !((Object)this$chunkSize).equals(other$chunkSize)) {
            return false;
        }
        Boolean this$usePartitions = this.getUsePartitions();
        Boolean other$usePartitions = other.getUsePartitions();
        if (this$usePartitions == null ? other$usePartitions != null : !((Object)this$usePartitions).equals(other$usePartitions)) {
            return false;
        }
        Integer this$limit = this.getLimit();
        Integer other$limit = other.getLimit();
        if (this$limit == null ? other$limit != null : !((Object)this$limit).equals(other$limit)) {
            return false;
        }
        Boolean this$count = this.getCount();
        Boolean other$count = other.getCount();
        if (this$count == null ? other$count != null : !((Object)this$count).equals(other$count)) {
            return false;
        }
        Boolean this$drop = this.getDrop();
        Boolean other$drop = other.getDrop();
        if (this$drop == null ? other$drop != null : !((Object)this$drop).equals(other$drop)) {
            return false;
        }
        Boolean this$truncate = this.getTruncate();
        Boolean other$truncate = other.getTruncate();
        if (this$truncate == null ? other$truncate != null : !((Object)this$truncate).equals(other$truncate)) {
            return false;
        }
        Boolean this$cdcDelete = this.getCdcDelete();
        Boolean other$cdcDelete = other.getCdcDelete();
        if (this$cdcDelete == null ? other$cdcDelete != null : !((Object)this$cdcDelete).equals(other$cdcDelete)) {
            return false;
        }
        Boolean this$lockTable = this.getLockTable();
        Boolean other$lockTable = other.getLockTable();
        if (this$lockTable == null ? other$lockTable != null : !((Object)this$lockTable).equals(other$lockTable)) {
            return false;
        }
        Boolean this$lockCheck = this.getLockCheck();
        Boolean other$lockCheck = other.getLockCheck();
        if (this$lockCheck == null ? other$lockCheck != null : !((Object)this$lockCheck).equals(other$lockCheck)) {
            return false;
        }
        Boolean this$loadDttm = this.getLoadDttm();
        Boolean other$loadDttm = other.getLoadDttm();
        if (this$loadDttm == null ? other$loadDttm != null : !((Object)this$loadDttm).equals(other$loadDttm)) {
            return false;
        }
        Boolean this$useDbmsLob = this.getUseDbmsLob();
        Boolean other$useDbmsLob = other.getUseDbmsLob();
        if (this$useDbmsLob == null ? other$useDbmsLob != null : !((Object)this$useDbmsLob).equals(other$useDbmsLob)) {
            return false;
        }
        Integer this$batchSize = this.getBatchSize();
        Integer other$batchSize = other.getBatchSize();
        if (this$batchSize == null ? other$batchSize != null : !((Object)this$batchSize).equals(other$batchSize)) {
            return false;
        }
        Integer this$fetchSize = this.getFetchSize();
        Integer other$fetchSize = other.getFetchSize();
        if (this$fetchSize == null ? other$fetchSize != null : !((Object)this$fetchSize).equals(other$fetchSize)) {
            return false;
        }
        Boolean this$checkCdcChain = this.getCheckCdcChain();
        Boolean other$checkCdcChain = other.getCheckCdcChain();
        if (this$checkCdcChain == null ? other$checkCdcChain != null : !((Object)this$checkCdcChain).equals(other$checkCdcChain)) {
            return false;
        }
        Boolean this$validateSourceTable = this.getValidateSourceTable();
        Boolean other$validateSourceTable = other.getValidateSourceTable();
        if (this$validateSourceTable == null ? other$validateSourceTable != null : !((Object)this$validateSourceTable).equals(other$validateSourceTable)) {
            return false;
        }
        Integer this$validationCode = this.getValidationCode();
        Integer other$validationCode = other.getValidationCode();
        if (this$validationCode == null ? other$validationCode != null : !((Object)this$validationCode).equals(other$validationCode)) {
            return false;
        }
        Boolean this$clustered = this.getClustered();
        Boolean other$clustered = other.getClustered();
        if (this$clustered == null ? other$clustered != null : !((Object)this$clustered).equals(other$clustered)) {
            return false;
        }
        Boolean this$warnOnIncLoadFilterChanges = this.getWarnOnIncLoadFilterChanges();
        Boolean other$warnOnIncLoadFilterChanges = other.getWarnOnIncLoadFilterChanges();
        if (this$warnOnIncLoadFilterChanges == null ? other$warnOnIncLoadFilterChanges != null : !((Object)this$warnOnIncLoadFilterChanges).equals(other$warnOnIncLoadFilterChanges)) {
            return false;
        }
        Boolean this$autoCreateNewNullableColumn = this.getAutoCreateNewNullableColumn();
        Boolean other$autoCreateNewNullableColumn = other.getAutoCreateNewNullableColumn();
        if (this$autoCreateNewNullableColumn == null ? other$autoCreateNewNullableColumn != null : !((Object)this$autoCreateNewNullableColumn).equals(other$autoCreateNewNullableColumn)) {
            return false;
        }
        String this$projectVersion = this.getProjectVersion();
        String other$projectVersion = other.getProjectVersion();
        if (this$projectVersion == null ? other$projectVersion != null : !this$projectVersion.equals(other$projectVersion)) {
            return false;
        }
        String this$sqreamJdbcVersion = this.getSqreamJdbcVersion();
        String other$sqreamJdbcVersion = other.getSqreamJdbcVersion();
        if (this$sqreamJdbcVersion == null ? other$sqreamJdbcVersion != null : !this$sqreamJdbcVersion.equals(other$sqreamJdbcVersion)) {
            return false;
        }
        String this$oracleJdbcVersion = this.getOracleJdbcVersion();
        String other$oracleJdbcVersion = other.getOracleJdbcVersion();
        if (this$oracleJdbcVersion == null ? other$oracleJdbcVersion != null : !this$oracleJdbcVersion.equals(other$oracleJdbcVersion)) {
            return false;
        }
        String this$postgresJdbcVersion = this.getPostgresJdbcVersion();
        String other$postgresJdbcVersion = other.getPostgresJdbcVersion();
        if (this$postgresJdbcVersion == null ? other$postgresJdbcVersion != null : !this$postgresJdbcVersion.equals(other$postgresJdbcVersion)) {
            return false;
        }
        String this$mssqlJdbcVersion = this.getMssqlJdbcVersion();
        String other$mssqlJdbcVersion = other.getMssqlJdbcVersion();
        if (this$mssqlJdbcVersion == null ? other$mssqlJdbcVersion != null : !this$mssqlJdbcVersion.equals(other$mssqlJdbcVersion)) {
            return false;
        }
        String this$sapJdbcVersion = this.getSapJdbcVersion();
        String other$sapJdbcVersion = other.getSapJdbcVersion();
        if (this$sapJdbcVersion == null ? other$sapJdbcVersion != null : !this$sapJdbcVersion.equals(other$sapJdbcVersion)) {
            return false;
        }
        String this$teradataJdbcVersion = this.getTeradataJdbcVersion();
        String other$teradataJdbcVersion = other.getTeradataJdbcVersion();
        if (this$teradataJdbcVersion == null ? other$teradataJdbcVersion != null : !this$teradataJdbcVersion.equals(other$teradataJdbcVersion)) {
            return false;
        }
        String this$sybaseJdbcVersion = this.getSybaseJdbcVersion();
        String other$sybaseJdbcVersion = other.getSybaseJdbcVersion();
        if (this$sybaseJdbcVersion == null ? other$sybaseJdbcVersion != null : !this$sybaseJdbcVersion.equals(other$sybaseJdbcVersion)) {
            return false;
        }
        String this$configFile = this.getConfigFile();
        String other$configFile = other.getConfigFile();
        if (this$configFile == null ? other$configFile != null : !this$configFile.equals(other$configFile)) {
            return false;
        }
        String this$configDir = this.getConfigDir();
        String other$configDir = other.getConfigDir();
        if (this$configDir == null ? other$configDir != null : !this$configDir.equals(other$configDir)) {
            return false;
        }
        String this$connectionStringSqream = this.getConnectionStringSqream();
        String other$connectionStringSqream = other.getConnectionStringSqream();
        if (this$connectionStringSqream == null ? other$connectionStringSqream != null : !this$connectionStringSqream.equals(other$connectionStringSqream)) {
            return false;
        }
        String this$connectionStringSource = this.getConnectionStringSource();
        String other$connectionStringSource = other.getConnectionStringSource();
        if (this$connectionStringSource == null ? other$connectionStringSource != null : !this$connectionStringSource.equals(other$connectionStringSource)) {
            return false;
        }
        String this$connectionStringCatalog = this.getConnectionStringCatalog();
        String other$connectionStringCatalog = other.getConnectionStringCatalog();
        if (this$connectionStringCatalog == null ? other$connectionStringCatalog != null : !this$connectionStringCatalog.equals(other$connectionStringCatalog)) {
            return false;
        }
        String this$cdcCatalogTable = this.getCdcCatalogTable();
        String other$cdcCatalogTable = other.getCdcCatalogTable();
        if (this$cdcCatalogTable == null ? other$cdcCatalogTable != null : !this$cdcCatalogTable.equals(other$cdcCatalogTable)) {
            return false;
        }
        String this$cdcTrackingTable = this.getCdcTrackingTable();
        String other$cdcTrackingTable = other.getCdcTrackingTable();
        if (this$cdcTrackingTable == null ? other$cdcTrackingTable != null : !this$cdcTrackingTable.equals(other$cdcTrackingTable)) {
            return false;
        }
        String this$cdcPrimaryKeyTable = this.getCdcPrimaryKeyTable();
        String other$cdcPrimaryKeyTable = other.getCdcPrimaryKeyTable();
        if (this$cdcPrimaryKeyTable == null ? other$cdcPrimaryKeyTable != null : !this$cdcPrimaryKeyTable.equals(other$cdcPrimaryKeyTable)) {
            return false;
        }
        String this$loadSummaryTable = this.getLoadSummaryTable();
        String other$loadSummaryTable = other.getLoadSummaryTable();
        if (this$loadSummaryTable == null ? other$loadSummaryTable != null : !this$loadSummaryTable.equals(other$loadSummaryTable)) {
            return false;
        }
        String this$loadTypeName = this.getLoadTypeName();
        String other$loadTypeName = other.getLoadTypeName();
        if (this$loadTypeName == null ? other$loadTypeName != null : !this$loadTypeName.equals(other$loadTypeName)) {
            return false;
        }
        String this$sourceDatabaseName = this.getSourceDatabaseName();
        String other$sourceDatabaseName = other.getSourceDatabaseName();
        if (this$sourceDatabaseName == null ? other$sourceDatabaseName != null : !this$sourceDatabaseName.equals(other$sourceDatabaseName)) {
            return false;
        }
        String this$sourceSchema = this.getSourceSchema();
        String other$sourceSchema = other.getSourceSchema();
        if (this$sourceSchema == null ? other$sourceSchema != null : !this$sourceSchema.equals(other$sourceSchema)) {
            return false;
        }
        String this$sourceTable = this.getSourceTable();
        String other$sourceTable = other.getSourceTable();
        if (this$sourceTable == null ? other$sourceTable != null : !this$sourceTable.equals(other$sourceTable)) {
            return false;
        }
        String this$sourceTableNameFull = this.getSourceTableNameFull();
        String other$sourceTableNameFull = other.getSourceTableNameFull();
        if (this$sourceTableNameFull == null ? other$sourceTableNameFull != null : !this$sourceTableNameFull.equals(other$sourceTableNameFull)) {
            return false;
        }
        String this$sqreamDatabaseName = this.getSqreamDatabaseName();
        String other$sqreamDatabaseName = other.getSqreamDatabaseName();
        if (this$sqreamDatabaseName == null ? other$sqreamDatabaseName != null : !this$sqreamDatabaseName.equals(other$sqreamDatabaseName)) {
            return false;
        }
        String this$sqreamSchema = this.getSqreamSchema();
        String other$sqreamSchema = other.getSqreamSchema();
        if (this$sqreamSchema == null ? other$sqreamSchema != null : !this$sqreamSchema.equals(other$sqreamSchema)) {
            return false;
        }
        String this$sqreamTable = this.getSqreamTable();
        String other$sqreamTable = other.getSqreamTable();
        if (this$sqreamTable == null ? other$sqreamTable != null : !this$sqreamTable.equals(other$sqreamTable)) {
            return false;
        }
        String this$sqreamTableStg = this.getSqreamTableStg();
        String other$sqreamTableStg = other.getSqreamTableStg();
        if (this$sqreamTableStg == null ? other$sqreamTableStg != null : !this$sqreamTableStg.equals(other$sqreamTableStg)) {
            return false;
        }
        String this$sqreamTableTemp = this.getSqreamTableTemp();
        String other$sqreamTableTemp = other.getSqreamTableTemp();
        if (this$sqreamTableTemp == null ? other$sqreamTableTemp != null : !this$sqreamTableTemp.equals(other$sqreamTableTemp)) {
            return false;
        }
        String this$sqreamTableOld = this.getSqreamTableOld();
        String other$sqreamTableOld = other.getSqreamTableOld();
        if (this$sqreamTableOld == null ? other$sqreamTableOld != null : !this$sqreamTableOld.equals(other$sqreamTableOld)) {
            return false;
        }
        String this$sqreamTableNameFull = this.getSqreamTableNameFull();
        String other$sqreamTableNameFull = other.getSqreamTableNameFull();
        if (this$sqreamTableNameFull == null ? other$sqreamTableNameFull != null : !this$sqreamTableNameFull.equals(other$sqreamTableNameFull)) {
            return false;
        }
        String this$sqreamTableNameFullStg = this.getSqreamTableNameFullStg();
        String other$sqreamTableNameFullStg = other.getSqreamTableNameFullStg();
        if (this$sqreamTableNameFullStg == null ? other$sqreamTableNameFullStg != null : !this$sqreamTableNameFullStg.equals(other$sqreamTableNameFullStg)) {
            return false;
        }
        String this$sqreamTableNameFullTemp = this.getSqreamTableNameFullTemp();
        String other$sqreamTableNameFullTemp = other.getSqreamTableNameFullTemp();
        if (this$sqreamTableNameFullTemp == null ? other$sqreamTableNameFullTemp != null : !this$sqreamTableNameFullTemp.equals(other$sqreamTableNameFullTemp)) {
            return false;
        }
        String this$sqreamTableNameFullOld = this.getSqreamTableNameFullOld();
        String other$sqreamTableNameFullOld = other.getSqreamTableNameFullOld();
        if (this$sqreamTableNameFullOld == null ? other$sqreamTableNameFullOld != null : !this$sqreamTableNameFullOld.equals(other$sqreamTableNameFullOld)) {
            return false;
        }
        String this$splitByColumn = this.getSplitByColumn();
        String other$splitByColumn = other.getSplitByColumn();
        if (this$splitByColumn == null ? other$splitByColumn != null : !this$splitByColumn.equals(other$splitByColumn)) {
            return false;
        }
        String this$filter = this.getFilter();
        String other$filter = other.getFilter();
        if (this$filter == null ? other$filter != null : !this$filter.equals(other$filter)) {
            return false;
        }
        String this$columnListFilePath = this.getColumnListFilePath();
        String other$columnListFilePath = other.getColumnListFilePath();
        if (this$columnListFilePath == null ? other$columnListFilePath != null : !this$columnListFilePath.equals(other$columnListFilePath)) {
            return false;
        }
        String this$selectedColumns = this.getSelectedColumns();
        String other$selectedColumns = other.getSelectedColumns();
        if (this$selectedColumns == null ? other$selectedColumns != null : !this$selectedColumns.equals(other$selectedColumns)) {
            return false;
        }
        String this$loadDttmColumnName = this.getLoadDttmColumnName();
        String other$loadDttmColumnName = other.getLoadDttmColumnName();
        if (this$loadDttmColumnName == null ? other$loadDttmColumnName != null : !this$loadDttmColumnName.equals(other$loadDttmColumnName)) {
            return false;
        }
        String this$logDir = this.getLogDir();
        String other$logDir = other.getLogDir();
        if (this$logDir == null ? other$logDir != null : !this$logDir.equals(other$logDir)) {
            return false;
        }
        DBType this$sourceDbType = this.getSourceDbType();
        DBType other$sourceDbType = other.getSourceDbType();
        if (this$sourceDbType == null ? other$sourceDbType != null : !this$sourceDbType.equals(other$sourceDbType)) {
            return false;
        }
        DBType this$catalogDbType = this.getCatalogDbType();
        DBType other$catalogDbType = other.getCatalogDbType();
        if (this$catalogDbType == null ? other$catalogDbType != null : !this$catalogDbType.equals(other$catalogDbType)) {
            return false;
        }
        LoadType this$loadType = this.getLoadType();
        LoadType other$loadType = other.getLoadType();
        if (this$loadType == null ? other$loadType != null : !this$loadType.equals(other$loadType)) {
            return false;
        }
        String this$partitionName = this.getPartitionName();
        String other$partitionName = other.getPartitionName();
        if (this$partitionName == null ? other$partitionName != null : !this$partitionName.equals(other$partitionName)) {
            return false;
        }
        String this$typeMappingPath = this.getTypeMappingPath();
        String other$typeMappingPath = other.getTypeMappingPath();
        if (this$typeMappingPath == null ? other$typeMappingPath != null : !this$typeMappingPath.equals(other$typeMappingPath)) {
            return false;
        }
        String this$reservedWordPath = this.getReservedWordPath();
        String other$reservedWordPath = other.getReservedWordPath();
        if (this$reservedWordPath == null ? other$reservedWordPath != null : !this$reservedWordPath.equals(other$reservedWordPath)) {
            return false;
        }
        TypeMappingService this$typeMapping = this.getTypeMapping();
        TypeMappingService other$typeMapping = other.getTypeMapping();
        if (this$typeMapping == null ? other$typeMapping != null : !this$typeMapping.equals(other$typeMapping)) {
            return false;
        }
        List this$reservedWordsList = this.getReservedWordsList();
        List other$reservedWordsList = other.getReservedWordsList();
        if (this$reservedWordsList == null ? other$reservedWordsList != null : !((Object)this$reservedWordsList).equals(other$reservedWordsList)) {
            return false;
        }
        List this$columnList = this.getColumnList();
        List other$columnList = other.getColumnList();
        if (this$columnList == null ? other$columnList != null : !((Object)this$columnList).equals(other$columnList)) {
            return false;
        }
        String this$requestedHost = this.getRequestedHost();
        String other$requestedHost = other.getRequestedHost();
        if (this$requestedHost == null ? other$requestedHost != null : !this$requestedHost.equals(other$requestedHost)) {
            return false;
        }
        String this$acquiredHost = this.getAcquiredHost();
        String other$acquiredHost = other.getAcquiredHost();
        if (this$acquiredHost == null ? other$acquiredHost != null : !this$acquiredHost.equals(other$acquiredHost)) {
            return false;
        }
        String this$clientIp = this.getClientIp();
        String other$clientIp = other.getClientIp();
        if (this$clientIp == null ? other$clientIp != null : !this$clientIp.equals(other$clientIp)) {
            return false;
        }
        String this$requestId = this.getRequestId();
        String other$requestId = other.getRequestId();
        if (this$requestId == null ? other$requestId != null : !this$requestId.equals(other$requestId)) {
            return false;
        }
        String this$requestHash = this.getRequestHash();
        String other$requestHash = other.getRequestHash();
        if (this$requestHash == null ? other$requestHash != null : !this$requestHash.equals(other$requestHash)) {
            return false;
        }
        String this$sqreamRequestHash = this.getSqreamRequestHash();
        String other$sqreamRequestHash = other.getSqreamRequestHash();
        return !(this$sqreamRequestHash == null ? other$sqreamRequestHash != null : !this$sqreamRequestHash.equals(other$sqreamRequestHash));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Params;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $caseSensitive = this.getCaseSensitive();
        result = result * 59 + ($caseSensitive == null ? 43 : ((Object)$caseSensitive).hashCode());
        Boolean $rowid = this.getRowid();
        result = result * 59 + ($rowid == null ? 43 : ((Object)$rowid).hashCode());
        Integer $threadCount = this.getThreadCount();
        result = result * 59 + ($threadCount == null ? 43 : ((Object)$threadCount).hashCode());
        Integer $chunkSize = this.getChunkSize();
        result = result * 59 + ($chunkSize == null ? 43 : ((Object)$chunkSize).hashCode());
        Boolean $usePartitions = this.getUsePartitions();
        result = result * 59 + ($usePartitions == null ? 43 : ((Object)$usePartitions).hashCode());
        Integer $limit = this.getLimit();
        result = result * 59 + ($limit == null ? 43 : ((Object)$limit).hashCode());
        Boolean $count = this.getCount();
        result = result * 59 + ($count == null ? 43 : ((Object)$count).hashCode());
        Boolean $drop = this.getDrop();
        result = result * 59 + ($drop == null ? 43 : ((Object)$drop).hashCode());
        Boolean $truncate = this.getTruncate();
        result = result * 59 + ($truncate == null ? 43 : ((Object)$truncate).hashCode());
        Boolean $cdcDelete = this.getCdcDelete();
        result = result * 59 + ($cdcDelete == null ? 43 : ((Object)$cdcDelete).hashCode());
        Boolean $lockTable = this.getLockTable();
        result = result * 59 + ($lockTable == null ? 43 : ((Object)$lockTable).hashCode());
        Boolean $lockCheck = this.getLockCheck();
        result = result * 59 + ($lockCheck == null ? 43 : ((Object)$lockCheck).hashCode());
        Boolean $loadDttm = this.getLoadDttm();
        result = result * 59 + ($loadDttm == null ? 43 : ((Object)$loadDttm).hashCode());
        Boolean $useDbmsLob = this.getUseDbmsLob();
        result = result * 59 + ($useDbmsLob == null ? 43 : ((Object)$useDbmsLob).hashCode());
        Integer $batchSize = this.getBatchSize();
        result = result * 59 + ($batchSize == null ? 43 : ((Object)$batchSize).hashCode());
        Integer $fetchSize = this.getFetchSize();
        result = result * 59 + ($fetchSize == null ? 43 : ((Object)$fetchSize).hashCode());
        Boolean $checkCdcChain = this.getCheckCdcChain();
        result = result * 59 + ($checkCdcChain == null ? 43 : ((Object)$checkCdcChain).hashCode());
        Boolean $validateSourceTable = this.getValidateSourceTable();
        result = result * 59 + ($validateSourceTable == null ? 43 : ((Object)$validateSourceTable).hashCode());
        Integer $validationCode = this.getValidationCode();
        result = result * 59 + ($validationCode == null ? 43 : ((Object)$validationCode).hashCode());
        Boolean $clustered = this.getClustered();
        result = result * 59 + ($clustered == null ? 43 : ((Object)$clustered).hashCode());
        Boolean $warnOnIncLoadFilterChanges = this.getWarnOnIncLoadFilterChanges();
        result = result * 59 + ($warnOnIncLoadFilterChanges == null ? 43 : ((Object)$warnOnIncLoadFilterChanges).hashCode());
        Boolean $autoCreateNewNullableColumn = this.getAutoCreateNewNullableColumn();
        result = result * 59 + ($autoCreateNewNullableColumn == null ? 43 : ((Object)$autoCreateNewNullableColumn).hashCode());
        String $projectVersion = this.getProjectVersion();
        result = result * 59 + ($projectVersion == null ? 43 : $projectVersion.hashCode());
        String $sqreamJdbcVersion = this.getSqreamJdbcVersion();
        result = result * 59 + ($sqreamJdbcVersion == null ? 43 : $sqreamJdbcVersion.hashCode());
        String $oracleJdbcVersion = this.getOracleJdbcVersion();
        result = result * 59 + ($oracleJdbcVersion == null ? 43 : $oracleJdbcVersion.hashCode());
        String $postgresJdbcVersion = this.getPostgresJdbcVersion();
        result = result * 59 + ($postgresJdbcVersion == null ? 43 : $postgresJdbcVersion.hashCode());
        String $mssqlJdbcVersion = this.getMssqlJdbcVersion();
        result = result * 59 + ($mssqlJdbcVersion == null ? 43 : $mssqlJdbcVersion.hashCode());
        String $sapJdbcVersion = this.getSapJdbcVersion();
        result = result * 59 + ($sapJdbcVersion == null ? 43 : $sapJdbcVersion.hashCode());
        String $teradataJdbcVersion = this.getTeradataJdbcVersion();
        result = result * 59 + ($teradataJdbcVersion == null ? 43 : $teradataJdbcVersion.hashCode());
        String $sybaseJdbcVersion = this.getSybaseJdbcVersion();
        result = result * 59 + ($sybaseJdbcVersion == null ? 43 : $sybaseJdbcVersion.hashCode());
        String $configFile = this.getConfigFile();
        result = result * 59 + ($configFile == null ? 43 : $configFile.hashCode());
        String $configDir = this.getConfigDir();
        result = result * 59 + ($configDir == null ? 43 : $configDir.hashCode());
        String $connectionStringSqream = this.getConnectionStringSqream();
        result = result * 59 + ($connectionStringSqream == null ? 43 : $connectionStringSqream.hashCode());
        String $connectionStringSource = this.getConnectionStringSource();
        result = result * 59 + ($connectionStringSource == null ? 43 : $connectionStringSource.hashCode());
        String $connectionStringCatalog = this.getConnectionStringCatalog();
        result = result * 59 + ($connectionStringCatalog == null ? 43 : $connectionStringCatalog.hashCode());
        String $cdcCatalogTable = this.getCdcCatalogTable();
        result = result * 59 + ($cdcCatalogTable == null ? 43 : $cdcCatalogTable.hashCode());
        String $cdcTrackingTable = this.getCdcTrackingTable();
        result = result * 59 + ($cdcTrackingTable == null ? 43 : $cdcTrackingTable.hashCode());
        String $cdcPrimaryKeyTable = this.getCdcPrimaryKeyTable();
        result = result * 59 + ($cdcPrimaryKeyTable == null ? 43 : $cdcPrimaryKeyTable.hashCode());
        String $loadSummaryTable = this.getLoadSummaryTable();
        result = result * 59 + ($loadSummaryTable == null ? 43 : $loadSummaryTable.hashCode());
        String $loadTypeName = this.getLoadTypeName();
        result = result * 59 + ($loadTypeName == null ? 43 : $loadTypeName.hashCode());
        String $sourceDatabaseName = this.getSourceDatabaseName();
        result = result * 59 + ($sourceDatabaseName == null ? 43 : $sourceDatabaseName.hashCode());
        String $sourceSchema = this.getSourceSchema();
        result = result * 59 + ($sourceSchema == null ? 43 : $sourceSchema.hashCode());
        String $sourceTable = this.getSourceTable();
        result = result * 59 + ($sourceTable == null ? 43 : $sourceTable.hashCode());
        String $sourceTableNameFull = this.getSourceTableNameFull();
        result = result * 59 + ($sourceTableNameFull == null ? 43 : $sourceTableNameFull.hashCode());
        String $sqreamDatabaseName = this.getSqreamDatabaseName();
        result = result * 59 + ($sqreamDatabaseName == null ? 43 : $sqreamDatabaseName.hashCode());
        String $sqreamSchema = this.getSqreamSchema();
        result = result * 59 + ($sqreamSchema == null ? 43 : $sqreamSchema.hashCode());
        String $sqreamTable = this.getSqreamTable();
        result = result * 59 + ($sqreamTable == null ? 43 : $sqreamTable.hashCode());
        String $sqreamTableStg = this.getSqreamTableStg();
        result = result * 59 + ($sqreamTableStg == null ? 43 : $sqreamTableStg.hashCode());
        String $sqreamTableTemp = this.getSqreamTableTemp();
        result = result * 59 + ($sqreamTableTemp == null ? 43 : $sqreamTableTemp.hashCode());
        String $sqreamTableOld = this.getSqreamTableOld();
        result = result * 59 + ($sqreamTableOld == null ? 43 : $sqreamTableOld.hashCode());
        String $sqreamTableNameFull = this.getSqreamTableNameFull();
        result = result * 59 + ($sqreamTableNameFull == null ? 43 : $sqreamTableNameFull.hashCode());
        String $sqreamTableNameFullStg = this.getSqreamTableNameFullStg();
        result = result * 59 + ($sqreamTableNameFullStg == null ? 43 : $sqreamTableNameFullStg.hashCode());
        String $sqreamTableNameFullTemp = this.getSqreamTableNameFullTemp();
        result = result * 59 + ($sqreamTableNameFullTemp == null ? 43 : $sqreamTableNameFullTemp.hashCode());
        String $sqreamTableNameFullOld = this.getSqreamTableNameFullOld();
        result = result * 59 + ($sqreamTableNameFullOld == null ? 43 : $sqreamTableNameFullOld.hashCode());
        String $splitByColumn = this.getSplitByColumn();
        result = result * 59 + ($splitByColumn == null ? 43 : $splitByColumn.hashCode());
        String $filter = this.getFilter();
        result = result * 59 + ($filter == null ? 43 : $filter.hashCode());
        String $columnListFilePath = this.getColumnListFilePath();
        result = result * 59 + ($columnListFilePath == null ? 43 : $columnListFilePath.hashCode());
        String $selectedColumns = this.getSelectedColumns();
        result = result * 59 + ($selectedColumns == null ? 43 : $selectedColumns.hashCode());
        String $loadDttmColumnName = this.getLoadDttmColumnName();
        result = result * 59 + ($loadDttmColumnName == null ? 43 : $loadDttmColumnName.hashCode());
        String $logDir = this.getLogDir();
        result = result * 59 + ($logDir == null ? 43 : $logDir.hashCode());
        DBType $sourceDbType = this.getSourceDbType();
        result = result * 59 + ($sourceDbType == null ? 43 : $sourceDbType.hashCode());
        DBType $catalogDbType = this.getCatalogDbType();
        result = result * 59 + ($catalogDbType == null ? 43 : $catalogDbType.hashCode());
        LoadType $loadType = this.getLoadType();
        result = result * 59 + ($loadType == null ? 43 : $loadType.hashCode());
        String $partitionName = this.getPartitionName();
        result = result * 59 + ($partitionName == null ? 43 : $partitionName.hashCode());
        String $typeMappingPath = this.getTypeMappingPath();
        result = result * 59 + ($typeMappingPath == null ? 43 : $typeMappingPath.hashCode());
        String $reservedWordPath = this.getReservedWordPath();
        result = result * 59 + ($reservedWordPath == null ? 43 : $reservedWordPath.hashCode());
        TypeMappingService $typeMapping = this.getTypeMapping();
        result = result * 59 + ($typeMapping == null ? 43 : $typeMapping.hashCode());
        List $reservedWordsList = this.getReservedWordsList();
        result = result * 59 + ($reservedWordsList == null ? 43 : ((Object)$reservedWordsList).hashCode());
        List $columnList = this.getColumnList();
        result = result * 59 + ($columnList == null ? 43 : ((Object)$columnList).hashCode());
        String $requestedHost = this.getRequestedHost();
        result = result * 59 + ($requestedHost == null ? 43 : $requestedHost.hashCode());
        String $acquiredHost = this.getAcquiredHost();
        result = result * 59 + ($acquiredHost == null ? 43 : $acquiredHost.hashCode());
        String $clientIp = this.getClientIp();
        result = result * 59 + ($clientIp == null ? 43 : $clientIp.hashCode());
        String $requestId = this.getRequestId();
        result = result * 59 + ($requestId == null ? 43 : $requestId.hashCode());
        String $requestHash = this.getRequestHash();
        result = result * 59 + ($requestHash == null ? 43 : $requestHash.hashCode());
        String $sqreamRequestHash = this.getSqreamRequestHash();
        result = result * 59 + ($sqreamRequestHash == null ? 43 : $sqreamRequestHash.hashCode());
        return result;
    }
}

