/*
 * Decompiled with CFR 0.152.
 */
package com.sqream.sqloaderService.dbhandler.connectors;

import com.sqream.sqloader.common.dto.RequestData;
import com.sqream.sqloader.common.service.HazelcastService;
import com.sqream.sqloader.common.utils.CommonStrUtils;
import com.sqream.sqloaderService.configuration.BeanUtil;
import com.sqream.sqloaderService.dbhandler.connectors.QueryResultData;
import com.sqream.sqloaderService.enums.ExitCode;
import com.sqream.sqloaderService.enums.QueryResultType;
import com.sqream.sqloaderService.exceptions.SqloadInitException;
import com.sqream.sqloaderService.utils.LogUtils;
import com.sqream.sqloaderService.utils.retry.ErrorHolder;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.Map;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JDBCConnector
implements AutoCloseable {
    private static final Logger log = LoggerFactory.getLogger(JDBCConnector.class);
    private final String connectionUrl;
    private final String logHeader;
    Connection connection;
    String requestId;
    HazelcastService hazelcastService;
    String connectionId;
    ErrorHolder errorHolder;

    public JDBCConnector(String connectionUrl, String logHeader, String requestId) {
        this.logHeader = logHeader;
        this.connectionUrl = connectionUrl;
        this.requestId = requestId;
        this.hazelcastService = (HazelcastService)BeanUtil.getBean(HazelcastService.class);
        this.errorHolder = (ErrorHolder)BeanUtil.getBean(ErrorHolder.class);
    }

    public void connect() throws SqloadInitException {
        try {
            log.info("[{}]\tConnecting to DB : {}", (Object)this.logHeader, (Object)CommonStrUtils.maskConnectionString((String)this.connectionUrl));
            Map connectionDetails = CommonStrUtils.splitURLToParams((String)this.connectionUrl);
            this.connection = DriverManager.getConnection((String)connectionDetails.get("url"), (String)connectionDetails.get("user"), (String)connectionDetails.get("password"));
            this.connectionId = this.generateConnectionHash();
            log.info("[{}]\tConnected successfully to DB with connection ID : {}", (Object)this.logHeader, (Object)this.connectionId);
        }
        catch (Exception e) {
            String errMsg = MessageFormat.format("Didn''t succeed to connect to \"{0}\". Check DB connection details. Error is: {1}", CommonStrUtils.maskConnectionString((String)this.connectionUrl), LogUtils.exceptionFormat((String)e.getMessage()));
            throw new SqloadInitException(errMsg, ExitCode.DB_CONNECTION_ERROR, this.requestId);
        }
    }

    public Object executeCommand(String command, QueryResultType queryResultType) throws SQLException {
        log.debug("[{}]\tQuery to run: '{}'", (Object)this.logHeader, (Object)command);
        Object retVal = null;
        try (Statement stmt = this.connection.createStatement();){
            boolean hasResult = stmt.execute(command);
            if (hasResult) {
                ResultSet resultSet = stmt.getResultSet();
                if (resultSet.next()) {
                    if (queryResultType == QueryResultType.COUNT) {
                        Integer n = resultSet.getInt(1);
                        return n;
                    }
                    if (queryResultType == QueryResultType.DATETIME) {
                        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                        retVal = resultSet.getTimestamp(1);
                        if (retVal != null) {
                            retVal = sdf.format(resultSet.getTimestamp(1));
                        }
                    }
                    if (queryResultType == QueryResultType.TIMESTAMP) {
                        SimpleDateFormat stf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
                        Timestamp ts = resultSet.getTimestamp(1);
                        retVal = stf.format(resultSet.getTimestamp(1));
                    }
                    if (queryResultType == QueryResultType.INT) {
                        String queryResult = resultSet.getString(1);
                        if (queryResult.contains(".")) {
                            queryResult = queryResult.split("\\.")[0];
                        }
                        retVal = queryResult;
                    }
                    if (queryResultType == QueryResultType.STRING) {
                        retVal = resultSet.getString(1);
                    }
                }
                if (!command.contains("get_ddl") && !command.contains("get_view_ddl")) {
                    log.debug("[{}]\tResult from query: {}", (Object)this.logHeader, retVal);
                }
            }
        }
        return retVal;
    }

    public QueryResultData executeCommandWithoutClosingStatement(String query) throws SQLException {
        log.debug("[{}]\tQuery to run: '{}'", (Object)this.logHeader, (Object)query);
        Statement statement = this.connection.createStatement();
        ResultSet resultSet = statement.executeQuery(query);
        return new QueryResultData(resultSet, statement);
    }

    @Override
    public void close() throws SQLException {
        block3: {
            log.debug("[{}]\tConnection close is called", (Object)this.logHeader);
            try {
                if (this.connection != null) {
                    this.connection.close();
                }
            }
            catch (SQLException e) {
                if (!this.errorHolder.idleConnectionErrors().stream().noneMatch(e.getMessage()::contains)) break block3;
                RequestData requestData = (RequestData)this.hazelcastService.getRequests().get((Object)this.requestId);
                requestData.setStatusCode(Integer.valueOf(ExitCode.SQLEXCEPTION_ERROR));
                this.hazelcastService.getRequests().put((Object)this.requestId, (Object)requestData);
                throw e;
            }
        }
        log.info("[{}]\tClosed Connection : {}, for connecting ID : {}", new Object[]{this.logHeader, CommonStrUtils.maskConnectionString((String)this.connectionUrl), this.connectionId});
    }

    public boolean isExist(String isExistsQuery) {
        try {
            Object result = this.executeCommand(isExistsQuery, QueryResultType.COUNT);
            if (result == null) {
                return false;
            }
            int count = (Integer)result;
            return count != 0;
        }
        catch (SQLException e) {
            if (e.getMessage().contains("not found") || e.getMessage().contains("does not exist")) {
                return false;
            }
            log.error("an error occurred {}", (Object)LogUtils.exceptionFormat((String)e.getMessage()));
            return false;
        }
    }

    private String generateConnectionHash() {
        UUID uuid = UUID.randomUUID();
        return uuid.toString();
    }

    public Connection getConnection() {
        return this.connection;
    }
}

