/*
 * Decompiled with CFR 0.152.
 */
package com.sqream.sqloaderService.dbhandler.cdc;

import com.sqream.sqloader.common.dto.RequestData;
import com.sqream.sqloader.common.enums.DBType;
import com.sqream.sqloaderService.dbhandler.SourceDbHandler;
import com.sqream.sqloaderService.dbhandler.SqreamDbHandler;
import com.sqream.sqloaderService.dbhandler.cdc.CdcHandler;
import com.sqream.sqloaderService.dbhandler.connectors.JDBCConnector;
import com.sqream.sqloaderService.dto.CreationColumnData;
import com.sqream.sqloaderService.dto.Params;
import com.sqream.sqloaderService.enums.ExitCode;
import com.sqream.sqloaderService.enums.QueryResultType;
import com.sqream.sqloaderService.enums.TableType;
import com.sqream.sqloaderService.exceptions.SqloadRuntimeException;
import com.sqream.sqloaderService.querycomposer.AbstractQueryComposer;
import com.sqream.sqloaderService.utils.StrUtils;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class IncHandler
extends CdcHandler {
    private static final Logger log = LoggerFactory.getLogger(IncHandler.class);
    String incrColumnValue_Max;
    String incrColumnType;
    String incrColumnValue_Last;
    String incrColumnName;
    String trackingColumnName;
    boolean rowid;
    boolean warnOnIncLoadFilterChanges;

    public IncHandler(JDBCConnector catalogConnector, SourceDbHandler sourceDbHandler, SqreamDbHandler sqreamDbHandler, AbstractQueryComposer queryComposer, Params params) {
        super(catalogConnector, sourceDbHandler, sqreamDbHandler, queryComposer, params);
        this.rowid = params.getRowid();
        this.warnOnIncLoadFilterChanges = params.getWarnOnIncLoadFilterChanges();
    }

    public void initialize() throws SQLException {
        this.validateCatalogTablesExist();
        this.validateFilter();
        this.updateParametersFromCatalogTableForInc();
        this.handleLockParameters();
        this.primaryKeyList = this.getPrimaryKeysForTable();
        log.info("Init {} params finished successfully", (Object)this.getTableType().toString());
    }

    private void validateFilter() throws SQLException {
        String trackingFilterQuery = this.queryComposer.getFilterFromTracking(this.trackingColumnName, this.cdcTrackingTable, this.sourceDbHandler.getConfigSourceDbName(), this.sourceDbHandler.getFullTableName(), this.incrColumnType);
        String trackingFilter = (String)this.catalogConnector.executeCommand(trackingFilterQuery, QueryResultType.STRING);
        if (this.warnOnIncLoadFilterChanges && !this.sourceDbHandler.getFilter().equals(trackingFilter)) {
            String errMsg = "[INCREMENTAL]\t Warning! Filter was changed. ";
            throw new SqloadRuntimeException(errMsg, ExitCode.FILTER_CHANGED, this.requestId);
        }
    }

    public void printCatalogParametersFull() {
        this.logUtils.writeLogHeader("PARAMETERS FOR FULL LOAD OF TABLE TYPE " + String.valueOf(this.getTableType()));
        log.info("Catalog parameters for " + String.valueOf(this.getTableType()) + " table:");
        this.superPrintCatalogParameters();
        log.info("Incremental column name: {}", (Object)this.incrColumnName);
        log.info("Incremental column type: {}", (Object)this.incrColumnType);
        log.info("Incremental max column value: {}", (Object)this.incrColumnValue_Max);
        this.logUtils.writeLogHeader("");
    }

    public void printCatalogParameters() {
        this.logUtils.writeLogHeader("PARAMETERS FOR " + String.valueOf(this.getTableType()) + " LOAD");
        log.info("Catalog parameters for " + String.valueOf(this.getTableType()) + " table:");
        this.superPrintCatalogParameters();
        log.info("Incremental column name: {}", (Object)this.incrColumnName);
        log.info("Incremental column type: {}", (Object)this.incrColumnType);
        log.info("Incremental last column value: {}", (Object)this.incrColumnValue_Last);
        log.info("Incremental max column value: {}", (Object)this.incrColumnValue_Max);
        this.logUtils.writeLogHeader("");
    }

    public TableType getTableType() {
        return TableType.INC;
    }

    public boolean isNewRecordsAdded() {
        if (this.incrColumnValue_Max == null) {
            log.info("[INCREMENTAL]\tThere is no new record found after last value \"" + this.incrColumnValue_Last + "\"!");
            RequestData requestData = (RequestData)this.hazelcastService.getRequests().get((Object)this.requestId);
            requestData.setStatusCode(Integer.valueOf(ExitCode.NO_NEW_RECORDS_INCREMENTAL_LOAD));
            this.hazelcastService.getRequests().put((Object)this.requestId, (Object)requestData);
            return false;
        }
        return true;
    }

    protected void appendColumnsToStgTable(List<CreationColumnData> creationColumnDataList) {
        creationColumnDataList.add(new CreationColumnData("ora_row_id", "text null", "text", true));
    }

    public Map<String, String> fillSummaryValues(Map<String, String> loadSummary) {
        if (this.incrColumnType != null) {
            String lastVal = this.getLastVal();
            String val = this.incrColumnValue_Max != null ? this.incrColumnValue_Max : this.incrColumnValue_Last;
            loadSummary.put(lastVal, val);
        }
        return loadSummary;
    }

    private String getLastVal() {
        return switch (this.incrColumnType) {
            case "int" -> "last_val_int";
            case "datetime2" -> "last_val_dt2";
            default -> "last_val_ts";
        };
    }

    public void updateParametersFromCatalogTableForInc() throws SQLException {
        this.updateParametersFromCatalogTable();
        this.updateLatestValueFromTrackingTable();
        this.updateMaxValue();
    }

    public void updateParametersFromCatalogTableForFull() throws SQLException {
        this.updateParametersFromCatalogTable();
        this.updateDefaultLatestValue();
        this.updateMaxValue();
    }

    protected void updateSpecificParameters(ResultSet rsTableDetails) throws SQLException {
        this.incrColumnType = rsTableDetails.getString("inc_column_type").toLowerCase();
        this.incrColumnName = rsTableDetails.getString("inc_column_name").toLowerCase();
        switch (this.incrColumnType) {
            case "int": {
                this.trackingColumnName = "last_val_int";
                break;
            }
            case "timestamp": {
                this.trackingColumnName = "last_val_ts";
                break;
            }
            case "datetime": {
                this.trackingColumnName = "last_val_dt";
                break;
            }
            case "datetime2": {
                this.trackingColumnName = "last_val_dt2";
                break;
            }
            default: {
                String errMsg = "Unrecognized value \"" + this.incrColumnType + "\"" + this.incrColumnName;
                throw new SqloadRuntimeException(errMsg, ExitCode.INCREMENTAL_UNRECOGNIZED_DATATYPE, this.requestId);
            }
        }
    }

    private void updateMaxValue() throws SQLException {
        String maxValueQuery = this.queryComposer.composeMaxValueQuery(this.incrColumnValue_Last, this.sourceDbHandler.getFullTableName(), this.incrColumnName, this.incrColumnType, this.sourceDbHandler.getFilter());
        switch (this.incrColumnType) {
            case "int": 
            case "datetime": 
            case "timestamp": {
                this.incrColumnValue_Max = (String)this.sourceDbHandler.executeQuery(maxValueQuery, QueryResultType.STRING);
                break;
            }
            case "datetime2": {
                this.incrColumnValue_Max = (String)this.sourceDbHandler.executeQuery(maxValueQuery, QueryResultType.STRING);
                this.incrColumnValue_Max = StrUtils.formatDateTime2ForQuery((String)this.incrColumnValue_Max);
                break;
            }
            default: {
                log.error("Unrecognized column type \"" + this.incrColumnType + "\"");
            }
        }
    }

    private void updateDefaultLatestValue() {
        switch (this.incrColumnType) {
            case "int": {
                this.trackingColumnName = "last_val_int";
                this.incrColumnValue_Last = "0";
                break;
            }
            case "timestamp": {
                this.trackingColumnName = "last_val_ts";
                this.incrColumnValue_Last = "1900-01-01 00:00:00.000";
                break;
            }
            case "datetime": {
                this.trackingColumnName = "last_val_dt";
                this.incrColumnValue_Last = "1900-01-01 00:00:00";
                break;
            }
            case "datetime2": {
                this.trackingColumnName = "last_val_dt2";
                this.incrColumnValue_Last = "1900-01-01 00:00:00.000000000";
                break;
            }
            default: {
                String errMsg = "Incremental column type \"" + this.incrColumnType + "\" not supported";
                throw new SqloadRuntimeException(errMsg, ExitCode.INCREMENTAL_COLUMN_TYPE_ERROR, this.requestId);
            }
        }
    }

    private void updateLatestValueFromTrackingTable() throws SQLException {
        String latestValueQuery = this.queryComposer.composeLastValueFromTracking(this.trackingColumnName, this.cdcTrackingTable, this.sourceDbHandler.getConfigSourceDbName(), this.sourceDbHandler.getFullTableName(), this.incrColumnType);
        switch (this.incrColumnType.toLowerCase()) {
            case "int": 
            case "datetime": 
            case "timestamp": {
                this.incrColumnValue_Last = (String)this.catalogConnector.executeCommand(latestValueQuery, QueryResultType.STRING);
                break;
            }
            case "datetime2": {
                this.incrColumnValue_Last = (String)this.catalogConnector.executeCommand(latestValueQuery, QueryResultType.STRING);
                this.incrColumnValue_Last = StrUtils.formatDateTime2ForQuery((String)this.incrColumnValue_Last);
                break;
            }
            default: {
                log.error("Unrecognized column type \"" + this.incrColumnType + "\"");
            }
        }
        if (this.incrColumnValue_Last == null) {
            String errMsg = "[INCREMENTAL]\tThere is no tracking record found for table \"" + this.sourceDbHandler.getFullTableName() + "\"!";
            throw new SqloadRuntimeException(errMsg, ExitCode.NO_TRACKING_RECORD_FOUND, this.requestId);
        }
    }

    public String getSelectCatalogQueryForCopy() throws SQLException {
        List columnsForStg = this.sourceDbHandler.getColumnsData();
        this.addColumnsAccordingConfiguration(columnsForStg);
        return this.queryComposer.composeSelectFromIncQuery(this.sourceDbHandler.getFullTableName(), this.incrColumnName, this.incrColumnType, columnsForStg, this.incrColumnValue_Last, this.incrColumnValue_Max, this.rowid, this.loadDttm, this.loadDttmColumnName, this.sourceDbHandler.getFilter());
    }

    public void apply() throws SQLException {
        this.logUtils.writeLogHeader("INCREMENTAL APPLY");
        List columnList = this.sqreamDbHandler.getColumnList(this.sqreamTableNameFull, null);
        this.formatColumnName(columnList, DBType.SQREAM);
        log.info("STEP-1:\tDelete existing rows based on primary keys!");
        this.logUtils.writeLogHeader("");
        this.deleteRowsFromTargetTable();
        log.info("STEP-2:\tInsert new rows from stage table to target table!");
        this.logUtils.writeLogHeader("");
        this.insertRowsFromStgToTargetTable(columnList);
        log.info("Insert operation completed successfully!");
    }

    private void deleteRowsFromTargetTable() throws SQLException {
        if (!this.isTherePrimaryKey()) {
            log.info("There is no primary keys defined for this table, delete operation skipped");
            RequestData requestData = (RequestData)this.hazelcastService.getRequests().get((Object)this.requestId);
            requestData.setStatusCode(Integer.valueOf(ExitCode.NO_PRIMARY_KEY_FOUND_INC));
            this.hazelcastService.getRequests().put((Object)this.requestId, (Object)requestData);
            return;
        }
        String deleteQuery = this.queryComposer.composeIncDeleteQuery(this.sqreamTableNameFull, this.sqreamTableNameStgFull, this.primaryKeyList, "ISNULL");
        this.sqreamDbHandler.executeCommand(deleteQuery, QueryResultType.IGNORE);
    }

    private void insertRowsFromStgToTargetTable(List<String> columnList) throws SQLException {
        String insertCmd = this.queryComposer.composeInsertFromStgToSqream(columnList, this.sqreamTableNameFull, this.sqreamTableNameStgFull);
        this.sqreamDbHandler.executeCommand(insertCmd, QueryResultType.IGNORE);
    }

    protected void updateTrackingRecord(boolean shouldSaveFilter) throws SQLException {
        if (this.incrColumnValue_Max == null) {
            log.debug("Max incremental column value is null, skipping updating the tracking record..");
            return;
        }
        if (shouldSaveFilter) {
            String filterForInsert = this.sourceDbHandler.getFilter().replace("'", "''");
            String updateFilterInTrackingQuery = this.queryComposer.compoUpdateTrackingQueryIncludeFilter(this.cdcTrackingTable, this.trackingColumnName, this.incrColumnValue_Max, this.sourceDbHandler.getConfigSourceDbName(), this.sourceDbHandler.getFullTableName(), this.incrColumnType, filterForInsert);
            this.catalogConnector.executeCommand(updateFilterInTrackingQuery, QueryResultType.IGNORE);
        } else {
            String updateTrackingQuery = this.queryComposer.compoUpdateTrackingQuery(this.cdcTrackingTable, this.trackingColumnName, this.incrColumnValue_Max, this.sourceDbHandler.getConfigSourceDbName(), this.sourceDbHandler.getFullTableName(), this.incrColumnType);
            this.catalogConnector.executeCommand(updateTrackingQuery, QueryResultType.IGNORE);
        }
    }

    protected void insertNewTrackingRecord() throws SQLException {
        String filterForInsert = this.sourceDbHandler.getFilter().replace("'", "''");
        String insertTrackingQuery = this.queryComposer.composeInsertTrackingQuery(this.cdcTrackingTable, this.trackingColumnName, this.incrColumnType, this.sourceDbHandler.getConfigSourceDbName(), this.sourceDbHandler.getTableConfigData().getSchemaName(), this.sourceDbHandler.getTableConfigData().getTableName(), this.sourceDbHandler.getFullTableName(), this.incrColumnValue_Last, filterForInsert);
        this.catalogConnector.executeCommand(insertTrackingQuery, QueryResultType.IGNORE);
    }

    public String getIncrColumnType() {
        return this.incrColumnType;
    }

    public String getIncrColumnValue_Last() {
        return this.incrColumnValue_Last;
    }
}

