/*
 * Decompiled with CFR 0.152.
 */
package com.sqream.sqloaderService.dbhandler.cdc;

import com.sqream.sqloader.common.dto.RequestData;
import com.sqream.sqloader.common.enums.DBType;
import com.sqream.sqloaderService.dbhandler.SourceDbHandler;
import com.sqream.sqloaderService.dbhandler.SqreamDbHandler;
import com.sqream.sqloaderService.dbhandler.cdc.AbstractCatalogHandler;
import com.sqream.sqloaderService.dbhandler.connectors.JDBCConnector;
import com.sqream.sqloaderService.dto.ColumnData;
import com.sqream.sqloaderService.dto.CreationColumnData;
import com.sqream.sqloaderService.dto.Params;
import com.sqream.sqloaderService.dto.PrimaryKeyData;
import com.sqream.sqloaderService.enums.ExitCode;
import com.sqream.sqloaderService.enums.QueryResultType;
import com.sqream.sqloaderService.enums.RequestStatus;
import com.sqream.sqloaderService.enums.TableType;
import com.sqream.sqloaderService.exceptions.SqloadRuntimeException;
import com.sqream.sqloaderService.loaders.LoadRowDataExecuter;
import com.sqream.sqloaderService.querycomposer.AbstractQueryComposer;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.retry.annotation.Retryable;

public class CdcHandler
extends AbstractCatalogHandler {
    private static final Logger log = LoggerFactory.getLogger(CdcHandler.class);
    String maxUpdatedDttm;
    String lastUpdatedDttm;
    String sourceTableNameCdcFull;
    String sourceTableNameCdc;
    String sourceSchemaNameCdc;
    String sqreamTableNameFull;
    String sqreamTableName;
    String sqreamSchemaName;
    String incrColumnName;
    int fetchSize;
    int batchSize;
    boolean useDbmsLob;
    boolean validateSourceTable;
    boolean checkCdcChain;
    boolean cdcDelete;

    public CdcHandler(JDBCConnector catalogConnector, SourceDbHandler sourceDbHandler, SqreamDbHandler sqreamDbHandler, AbstractQueryComposer queryComposer, Params params) {
        super(catalogConnector, sourceDbHandler, sqreamDbHandler, queryComposer, params);
        this.checkCdcChain = params.getCheckCdcChain();
        this.cdcDelete = params.getCdcDelete();
        this.sqreamTableNameFull = params.getSqreamTableNameFull();
        this.fetchSize = params.getFetchSize();
        this.batchSize = params.getBatchSize();
        this.useDbmsLob = params.getUseDbmsLob();
        this.sqreamSchemaName = this.sqreamTableNameFull.split("\\.")[0];
        this.sqreamTableName = this.sqreamTableNameFull.split("\\.")[1];
    }

    public void finalizeCatalog() throws SQLException {
        this.retryCallbackExecutor.execute("catalogHandler", (Object)this, args -> this.finalizeCatalogWithRetry(), new Object[0]);
    }

    @Retryable(value={SQLException.class})
    public void finalizeCatalogWithRetry() throws SQLException {
        RequestData requestData = (RequestData)this.hazelcastService.getRequests().get((Object)this.requestId);
        if (requestData.getFinalStatus().equals(RequestStatus.SUCCEEDED.name())) {
            this.updateTrackingValueInTrackingTable(true);
        }
        if (this.loadPerformed) {
            this.unlockTable();
        }
    }

    public TableType getTableType() {
        return TableType.CDC;
    }

    public void initialize() throws SQLException {
        this.validateCatalogTablesExist();
        this.updateParametersFromCatalogTableForCdc();
        this.handleLockParameters();
        this.primaryKeyList = this.getPrimaryKeysForTable();
        log.info("Init {} params finished successfully", (Object)this.getTableType().toString());
    }

    public void initializeForFullLoad() throws SQLException {
        log.info("Table type is {}. Initialize catalog parameters started", (Object)this.getTableType());
        this.validateCatalogTablesExist();
        this.updateParametersFromCatalogTableForFull();
        this.handleLockParameters();
        this.createStgTableInSqreamDb();
        this.updateTrackingValueInTrackingTable(false);
        this.printCatalogParametersFull();
    }

    public void printCatalogParametersFull() {
        this.logUtils.writeLogHeader("PARAMETERS FOR FULL LOAD OF TABLE TYPE " + String.valueOf(this.getTableType()));
        log.info("Catalog parameters for " + String.valueOf(this.getTableType()) + " table:");
        this.superPrintCatalogParameters();
        log.info("Max Updated Dttm: {}", (Object)this.maxUpdatedDttm);
        log.info("Increment column name: {}", (Object)this.incrColumnName);
        log.info("Full " + String.valueOf(this.getTableType()) + " table name: {}", (Object)this.sourceTableNameCdcFull);
        this.logUtils.writeLogHeader("");
    }

    public void printCatalogParameters() {
        this.logUtils.writeLogHeader("PARAMETERS FOR " + String.valueOf(this.getTableType()) + " LOAD");
        log.info("Catalog parameters for " + String.valueOf(this.getTableType()) + " table:");
        this.superPrintCatalogParameters();
        log.info("Last Updated Dttm: {}", (Object)this.lastUpdatedDttm);
        log.info("Increment column name: {}", (Object)this.incrColumnName);
        log.info("Full " + String.valueOf(this.getTableType()) + " table name: {}", (Object)this.sourceTableNameCdcFull);
        this.logUtils.writeLogHeader("");
    }

    public Map<String, String> fillSummaryValues(Map<String, String> loadSummary) {
        loadSummary.put("updated_dttm_from", this.lastUpdatedDttm);
        loadSummary.put("updated_dttm_to", this.maxUpdatedDttm);
        return loadSummary;
    }

    public void superPrintCatalogParameters() {
        super.printCatalogParameters();
    }

    public void updateParametersFromCatalogTableForCdc() throws SQLException {
        this.updateParametersFromCatalogTable();
        this.updateLatestDttm();
        this.updateMaxDttm(this.lastUpdatedDttm);
        this.checkCdcChain();
    }

    public void updateParametersFromCatalogTableForFull() throws SQLException {
        this.updateParametersFromCatalogTable();
        this.updateMaxDttm(null);
        this.lastUpdatedDttm = this.maxUpdatedDttm;
    }

    public boolean isNewRecordsAdded() throws SQLException {
        String selectCountDeltaQuery = this.queryComposer.composeSelectDeltaCount(this.sourceTableNameCdcFull, this.lastUpdatedDttm, this.maxUpdatedDttm);
        String countOfDelta = (String)this.sourceDbHandler.executeQuery(selectCountDeltaQuery, QueryResultType.STRING);
        if (countOfDelta.equals("0")) {
            log.info("There are no new records found on cdc table after \"" + this.lastUpdatedDttm + "\"!");
            RequestData requestData = (RequestData)this.hazelcastService.getRequests().get((Object)this.requestId);
            requestData.setStatusCode(Integer.valueOf(ExitCode.NO_NEW_RECORDS_CDC_LOAD));
            this.hazelcastService.getRequests().put((Object)this.requestId, (Object)requestData);
            return false;
        }
        return true;
    }

    protected void updateSpecificParameters(ResultSet rsTableDetails) throws SQLException {
        this.sourceTableNameCdcFull = rsTableDetails.getString("table_name_cdc").toUpperCase();
        this.sourceSchemaNameCdc = this.sourceTableNameCdcFull.split("\\.")[0];
        this.sourceTableNameCdc = this.sourceTableNameCdcFull.split("\\.")[1];
        this.incrColumnName = rsTableDetails.getString("inc_column_name");
        if (this.incrColumnName == null) {
            this.incrColumnName = "updated_dttm";
            log.warn("incremental column name is missing. Changed to default inc column name is {}", (Object)this.incrColumnName);
        }
        if (this.validateSourceTable && !this.sourceDbHandler.isTableExist(this.sourceSchemaNameCdc, this.sourceTableNameCdc)) {
            String errMsg = MessageFormat.format("cdc table {0} for table {1} doesn't exist in source DB", this.sourceTableNameCdcFull, this.sourceDbHandler.getFullTableName());
            throw new SqloadRuntimeException(errMsg, ExitCode.CDC_ACTIVATION_ERROR, this.requestId);
        }
    }

    private void updateMaxDttm(String latestDttmOnSqream) throws SQLException {
        try {
            String selectMaxDttmQuery = this.queryComposer.composeSelectMaxDttmQuery(this.sourceTableNameCdcFull, latestDttmOnSqream);
            this.maxUpdatedDttm = (String)this.sourceDbHandler.executeQuery(selectMaxDttmQuery, QueryResultType.DATETIME);
            log.info("Max dttm on {} is {}", (Object)this.sourceTableNameCdcFull, (Object)this.maxUpdatedDttm);
            if (this.maxUpdatedDttm == null) {
                log.debug("There are no records in tracking table {} yet", (Object)this.sourceTableNameCdcFull);
                this.maxUpdatedDttm = "2023-01-01 00:00:00";
                log.debug("Max dttm set by default: \"" + this.maxUpdatedDttm + "\"");
            }
        }
        catch (SQLException e) {
            String errMsg = MessageFormat.format("Failed to get max dttm for table {0}", this.sourceTableNameCdcFull);
            throw new SqloadRuntimeException(errMsg, ExitCode.CANNOT_GET_MAX_DTTM_SOURCE_CDC, this.requestId);
        }
    }

    public void updateLatestDttm() throws SQLException {
        try {
            String selectLatestDttmQuery = this.queryComposer.composeSelectLatestDttmQuery(this.cdcTrackingTable, this.sourceDbHandler.getConfigSourceDbName(), this.sourceDbHandler.getFullTableName());
            log.debug("[QUERY-CT]\t" + selectLatestDttmQuery);
            this.lastUpdatedDttm = (String)this.catalogConnector.executeCommand(selectLatestDttmQuery, QueryResultType.DATETIME);
        }
        catch (SQLException e) {
            throw new SqloadRuntimeException("Failed to get latest dttm for cdc", ExitCode.CANNOT_GET_LATEST_DTTM_CDC, this.requestId);
        }
    }

    private void checkCdcChain() throws SQLException {
        String lastDttmValidationQuery = this.queryComposer.composeLastDttmValidationQuery(this.sourceTableNameCdcFull, this.lastUpdatedDttm);
        String countExists = (String)this.sourceDbHandler.executeQuery(lastDttmValidationQuery, QueryResultType.STRING);
        if (countExists.equals("0") && this.lastUpdatedDttm != null && !this.lastUpdatedDttm.equals("2023-01-01 00:00:00")) {
            log.warn("No record found in CDC table belongs to latest dttm \"" + this.lastUpdatedDttm + "\"");
            if (this.checkCdcChain) {
                log.error("CDC data chain broken! Loading operation stopped, please re-initate table by full load!");
                log.error("You can run with option \"-check_cdc_chain false\"");
                throw new SqloadRuntimeException("CDC data chain broken", this.requestId);
            }
            log.info("CDC data chain broken! Loading operation will continue, please re-initiate table by full load!");
        }
    }

    public String getSelectCatalogQueryForCopy() throws SQLException {
        List columnsForStg = this.getColumnListForStg();
        this.addColumnsAccordingConfiguration(columnsForStg);
        return this.queryComposer.composeSelectFromCdcToStg(this.primaryKeyList, columnsForStg, this.sourceDbHandler.getFullTableName(), this.sourceTableNameCdcFull, this.lastUpdatedDttm, this.maxUpdatedDttm, this.loadDttmColumnName);
    }

    private List<ColumnData> getColumnListForStg() throws SQLException {
        List columnDataList = this.sourceDbHandler.getColumnsDataCopy();
        this.columnDataCdcList = this.sourceDbHandler.getColumnsData(this.sourceSchemaNameCdc, this.sourceTableNameCdc, null);
        for (ColumnData columnData : this.columnDataCdcList) {
            if (!this.sourceDbHandler.isExist(columnDataList, columnData.getColName())) {
                columnData.setColAlias(columnData.getColName() + "_from_cdc");
                columnDataList.add(columnData);
                continue;
            }
            if (!columnData.getColName().equalsIgnoreCase("type") && !columnData.getColName().equalsIgnoreCase("updated_dttm") && !columnData.getColName().equalsIgnoreCase("rowid") && !columnData.getColName().equalsIgnoreCase("row_id")) continue;
            columnData.setColAlias(columnData.getColName() + "_from_cdc");
            columnDataList.add(columnData);
        }
        return columnDataList;
    }

    protected void appendColumnsToStgTable(List<CreationColumnData> creationColumnDataList) {
        creationColumnDataList.add(new CreationColumnData("ora_dml_type", "text null", "string", true));
        creationColumnDataList.add(new CreationColumnData("ora_updated_dttm", "datetime null", "datetime", true));
        creationColumnDataList.add(new CreationColumnData("ora_row_id", "text null", "text", true));
    }

    protected void updateTrackingRecord(boolean shouldSaveFilter) throws SQLException {
        log.info("[CDC] Updating incremental tracking record!");
        String queryToExecute = this.queryComposer.composeUpdateLastDttmQuery(this.cdcTrackingTable, this.maxUpdatedDttm, this.catalogDbType, this.sourceDbHandler.getConfigSourceDbName(), this.sourceDbHandler.getFullTableName());
        this.catalogConnector.executeCommand(queryToExecute, QueryResultType.IGNORE);
    }

    protected void insertNewTrackingRecord() throws SQLException {
        log.info("[CDC] Inserting new incremental tracking record!");
        String query = this.queryComposer.composeInsertMaxDttmQuery(this.cdcTrackingTable, this.catalogDbType, this.sourceDbHandler.getConfigSourceDbName(), this.sourceDbHandler.getTableConfigData().getSchemaName(), this.sourceDbHandler.getTableConfigData().getTableName(), this.sourceDbHandler.getFullTableName(), this.maxUpdatedDttm);
        this.catalogConnector.executeCommand(query, QueryResultType.IGNORE);
    }

    public void apply() throws SQLException {
        if (this.cdcDelete) {
            this.applyDelete();
        }
        List columnList = this.sqreamDbHandler.getColumnList(this.sqreamTableNameFull, null);
        this.formatColumnName(columnList, DBType.SQREAM);
        this.logUtils.writeLogHeader("START OF CDC APPLY PROCESS");
        log.info("CDC APPLY STEP-1:\tDelete insert type rows!");
        this.logUtils.writeLogHeader("");
        this.deleteTypeRowsFromTargetTable(this.primaryKeyList, "I");
        log.info("CDC APPLY STEP-2:\tInsert inserted type rows to the target table!");
        this.logUtils.writeLogHeader("");
        this.insertRowsFromStgToSqreamTable(columnList, "I");
        log.info("Insert operation completed successfully for insert type rows!");
        log.info("CDC APPLY STEP-3:\tDelete update type rows!");
        this.logUtils.writeLogHeader("");
        this.deleteTypeRowsFromTargetTable(this.primaryKeyList, "U");
        log.info("CDC APPLY STEP-4:\tInsert updated type rows to the target table!");
        this.logUtils.writeLogHeader("");
        this.insertRowsFromStgToSqreamTable(columnList, "U");
        log.info("Insert operation completed successfully for update type rows!");
        if (this.cdcDelete) {
            log.info("CDC APPLY STEP-5:\tProcess delete operations on target table!");
            this.logUtils.writeLogHeader("");
            this.deleteTypeRowsFromTargetTable(this.primaryKeyList, "D");
        }
        this.sqreamDbHandler.cleanupTable(this.sqreamSchemaName, this.sqreamTableName);
    }

    public void applyDelete() throws SQLException {
        this.logUtils.writeLogHeader("CDC APPLY DELETE");
        String cdcDeleteQuery = this.getCdcDeleteQuery(this.columnDataCdcList);
        log.debug("Cdc delete query for ingestion to stg: {}", (Object)cdcDeleteQuery);
        this.loadToStgTable(this.columnDataCdcList, cdcDeleteQuery);
        log.info("Data with ora_dml_type='D' loaded to stg table");
    }

    private void addAliasToColumnData(List<ColumnData> srcColumns) {
        for (ColumnData column : srcColumns) {
            column.setColAlias(column.getColName() + "_from_cdc");
        }
    }

    private String getCdcDeleteQuery(List<ColumnData> columnDataList) {
        return this.queryComposer.composeSelectAccordingDttmFilter(this.primaryKeyList, columnDataList, this.sourceDbHandler.getFullTableName(), this.sourceTableNameCdcFull, this.lastUpdatedDttm, this.maxUpdatedDttm, this.loadDttm, this.loadDttmColumnName);
    }

    private void loadToStgTable(List<ColumnData> srcColumns, String queryToRun) throws SQLException {
        Map columnTypesOfTarget = this.sqreamDbHandler.getColumnTypesOfTarget();
        ArrayList<String> queriesForThread = new ArrayList<String>();
        queriesForThread.add(queryToRun);
        LoadRowDataExecuter loadRowDataExecuter = new LoadRowDataExecuter(srcColumns, this.sourceDbHandler.getConnectionString(), this.sqreamDbHandler.getConnectionString(), queriesForThread, this.fetchSize, this.batchSize, this.useDbmsLob, this.sourceDbHandler.getDbType(), this.sqreamTableNameStgFull, null, columnTypesOfTarget, this.caseSensitive, this.typeMappingService, this.loadDttmColumnName, this.requestId);
        loadRowDataExecuter.run();
    }

    private void deleteTypeRowsFromTargetTable(List<PrimaryKeyData> primaryKeysForSrcTable, String dmlType) throws SQLException {
        String cdcDeleteStatement = this.queryComposer.composeCdcDeleteStatement(primaryKeysForSrcTable, dmlType, this.sqreamTableNameFull, this.sqreamTableNameStgFull, "ISNULL");
        this.sqreamDbHandler.executeCommand(cdcDeleteStatement, QueryResultType.IGNORE);
    }

    private void insertRowsFromStgToSqreamTable(List<String> columnList, String dmlType) throws SQLException {
        String insertCmd = this.queryComposer.composeInsertFromStgToSqream(columnList, this.sqreamTableNameFull, this.sqreamTableNameStgFull, dmlType);
        this.sqreamDbHandler.executeCommand(insertCmd, QueryResultType.IGNORE);
    }

    public String getMaxUpdatedDttm() {
        return this.maxUpdatedDttm;
    }

    public String getLastUpdatedDttm() {
        return this.lastUpdatedDttm;
    }
}

