/*
 * Decompiled with CFR 0.152.
 */
package com.sqream.sqloaderService.dbhandler.cdc;

import com.sqream.sqloader.common.enums.DBType;
import com.sqream.sqloader.common.service.HazelcastService;
import com.sqream.sqloaderService.configuration.BeanUtil;
import com.sqream.sqloaderService.dbhandler.SourceDbHandler;
import com.sqream.sqloaderService.dbhandler.SqreamDbHandler;
import com.sqream.sqloaderService.dbhandler.connectors.JDBCConnector;
import com.sqream.sqloaderService.dbhandler.connectors.QueryResultData;
import com.sqream.sqloaderService.dto.ColumnData;
import com.sqream.sqloaderService.dto.CreationColumnData;
import com.sqream.sqloaderService.dto.Params;
import com.sqream.sqloaderService.dto.PrimaryKeyData;
import com.sqream.sqloaderService.enums.ExitCode;
import com.sqream.sqloaderService.enums.QueryResultType;
import com.sqream.sqloaderService.enums.TableType;
import com.sqream.sqloaderService.exceptions.SqloadRuntimeException;
import com.sqream.sqloaderService.querycomposer.AbstractQueryComposer;
import com.sqream.sqloaderService.typemapping.TypeMappingService;
import com.sqream.sqloaderService.utils.LogUtils;
import com.sqream.sqloaderService.utils.StrUtils;
import com.sqream.sqloaderService.utils.retry.RetryCallbackExecutor;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.retry.support.RetryTemplate;

public abstract class AbstractCatalogHandler
implements AutoCloseable {
    private static final Logger log = LoggerFactory.getLogger(AbstractCatalogHandler.class);
    RetryTemplate retryTemplate;
    RetryCallbackExecutor retryCallbackExecutor;
    TypeMappingService typeMappingService;
    protected final String cdcCatalogTable;
    protected final String cdcPrimaryKeyTable;
    protected final String cdcTrackingTable;
    protected final JDBCConnector catalogConnector;
    protected AbstractQueryComposer queryComposer;
    protected DBType catalogDbType;
    List<PrimaryKeyData> primaryKeyList;
    StrUtils strUtils;
    SourceDbHandler sourceDbHandler;
    SqreamDbHandler sqreamDbHandler;
    LogUtils logUtils;
    int statusLoadCurrent;
    boolean loadPerformed = false;
    boolean lockCheck;
    boolean lockTable;
    boolean loadDttm;
    String loadDttmColumnName;
    String sqreamTableNameStgFull;
    boolean caseSensitive;
    String requestId;
    HazelcastService hazelcastService;
    String loadSummaryTable;
    List<ColumnData> columnDataCdcList;
    boolean warnOnIncLoadFilterChanges;

    public AbstractCatalogHandler(JDBCConnector catalogConnector, SourceDbHandler sourceDbHandler, SqreamDbHandler sqreamDbHandler, AbstractQueryComposer queryComposer, Params params) {
        this.catalogConnector = catalogConnector;
        this.sourceDbHandler = sourceDbHandler;
        this.sqreamDbHandler = sqreamDbHandler;
        this.queryComposer = queryComposer;
        this.caseSensitive = params.getCaseSensitive();
        this.typeMappingService = params.getTypeMapping();
        this.lockCheck = params.getLockCheck();
        this.lockTable = params.getLockTable();
        this.loadDttm = params.getLoadDttm();
        this.loadDttmColumnName = params.getLoadDttmColumnName();
        this.sqreamTableNameStgFull = params.getSqreamTableNameFullStg();
        this.loadSummaryTable = params.getLoadSummaryTable();
        this.cdcCatalogTable = params.getCdcCatalogTable();
        this.cdcPrimaryKeyTable = params.getCdcPrimaryKeyTable();
        this.cdcTrackingTable = params.getCdcTrackingTable();
        this.catalogDbType = params.getCatalogDbType();
        this.strUtils = (StrUtils)BeanUtil.getBean(StrUtils.class);
        this.logUtils = (LogUtils)BeanUtil.getBean(LogUtils.class);
        this.hazelcastService = (HazelcastService)BeanUtil.getBean(HazelcastService.class);
        this.retryTemplate = (RetryTemplate)BeanUtil.getBean(RetryTemplate.class);
        this.retryCallbackExecutor = (RetryCallbackExecutor)BeanUtil.getBean(RetryCallbackExecutor.class);
        this.requestId = params.getRequestId();
        this.warnOnIncLoadFilterChanges = params.getWarnOnIncLoadFilterChanges();
    }

    public abstract void initializeForFullLoad() throws SQLException;

    public abstract void initialize() throws SQLException;

    public abstract void finalizeCatalog() throws SQLException;

    protected void updateSpecificParameters(ResultSet rsTableDetails) throws SQLException {
    }

    protected void appendColumnsToStgTable(List<CreationColumnData> creationColumnDataList) {
    }

    public String getSelectCatalogQueryForCopy() throws SQLException {
        return null;
    }

    public void apply() throws SQLException {
    }

    protected void insertNewTrackingRecord() throws SQLException {
    }

    protected void updateTrackingRecord(boolean shouldSaveFilter) throws SQLException {
    }

    public abstract TableType getTableType();

    public Map<String, String> fillSummaryValues(Map<String, String> loadSummary) {
        return loadSummary;
    }

    public void printCatalogParameters() {
        log.info("Catalog db type is {}", (Object)this.catalogDbType);
        if (this.primaryKeyList != null) {
            log.info("Primary keys: {}", (Object)this.primaryKeyList);
        }
    }

    protected void handleLockParameters() throws SQLException {
        if (this.lockCheck) {
            if (this.statusLoadCurrent == 1) {
                String errMsg = "[TABLE LOCK]\tCheck lock enabled! There is active load in progress, please try after current loading completed.";
                throw new SqloadRuntimeException(errMsg, ExitCode.TABLE_LOCKED_ACTIVE_LOAD, this.requestId);
            }
            log.info("[TABLE LOCK]\tCheck lock enabled! There is no active load, load will be performed.");
        } else if (this.statusLoadCurrent == 1) {
            log.info("[TABLE LOCK]\tCheck lock disabled! There is active load in progress but load will be performed.");
        } else {
            log.info("[TABLE LOCK]\tCheck lock disabled! There is no active load, load will be started.");
        }
        if (this.lockTable) {
            this.changeLoadStatus(1);
            this.loadPerformed = true;
        }
    }

    public void changeLoadStatus(int loadStatus) throws SQLException {
        String cmdUpdate = this.queryComposer.composeUpdateStatusLoad(this.cdcCatalogTable, loadStatus, this.sourceDbHandler.getConfigSourceDbName(), this.sourceDbHandler.getFullTableName());
        log.info("[TABLE LOCK]\t" + cmdUpdate);
        this.catalogConnector.executeCommand(cmdUpdate, QueryResultType.IGNORE);
        log.info("lock status updated to {}", (Object)(loadStatus == 1 ? "LOCKED" : "UN-LOCKED"));
    }

    public void validateCatalogTablesExist() throws SqloadRuntimeException {
        log.info("Validate catalog tables exist: {}, {}. (table {} has already been validated)", new Object[]{this.cdcPrimaryKeyTable, this.cdcTrackingTable, this.cdcCatalogTable});
        if (!this.catalogConnector.isExist(this.queryComposer.composeIsTableExistQuery(this.cdcTrackingTable, this.caseSensitive, this.sqreamDbHandler.getSqreamVersion()))) {
            String errMsg = "Table " + this.cdcTrackingTable + " doesn't exist";
            throw new SqloadRuntimeException(errMsg, ExitCode.CDC_ACTIVATION_ERROR, this.requestId);
        }
        if (!this.catalogConnector.isExist(this.queryComposer.composeIsTableExistQuery(this.cdcPrimaryKeyTable, this.caseSensitive, this.sqreamDbHandler.getSqreamVersion()))) {
            String errMsg = "Table " + this.cdcPrimaryKeyTable + " doesn't exist";
            throw new SqloadRuntimeException(errMsg, ExitCode.CDC_ACTIVATION_ERROR, this.requestId);
        }
        log.info("Tables {}, {}, {} exist in catalog DB", new Object[]{this.cdcCatalogTable, this.cdcPrimaryKeyTable, this.cdcTrackingTable});
    }

    public void validateSummaryTableExists() throws SqloadRuntimeException {
        log.info("Validate catalog summary table exists: {}", (Object)this.loadSummaryTable);
        if (!this.catalogConnector.isExist(this.queryComposer.composeIsTableExistQuery(this.loadSummaryTable, this.caseSensitive, this.sqreamDbHandler.getSqreamVersion()))) {
            String errMsg = "Summary table " + this.loadSummaryTable + " doesn't exist";
            throw new SqloadRuntimeException(errMsg, ExitCode.SUMMARY_TABLE_ERROR, this.requestId);
        }
        log.info("Table {} exists in catalog DB.", (Object)this.loadSummaryTable);
    }

    protected void createStgTableInSqreamDb() {
        try {
            List srcColumnDataList = this.sourceDbHandler.getColumnsDataCopy();
            this.fixUnexpectedIdentifier(srcColumnDataList, DBType.SQREAM);
            this.convertColumnsToNullable(srcColumnDataList);
            List creationColumnDataList = this.typeMappingService.getTargetColumnsType(DBType.SQREAM, this.sourceDbHandler.getDbType(), srcColumnDataList, this.caseSensitive);
            this.addColumnsAccordingConfigurationForCreate(creationColumnDataList);
            this.sqreamDbHandler.createTable(creationColumnDataList, this.sqreamTableNameStgFull, true);
        }
        catch (SQLException e) {
            String errMsg = "Staging table \"" + this.sqreamTableNameStgFull + "\" cannot created! Error occurred from jdbc: " + LogUtils.exceptionFormat((String)e.getMessage());
            throw new SqloadRuntimeException(errMsg, ExitCode.STAGING_TABLE_CREATION_FAILED, this.requestId);
        }
    }

    protected void fixUnexpectedIdentifier(List<ColumnData> columnsDataList, DBType dbType) {
        for (ColumnData columnData : columnsDataList) {
            columnData.setColName(this.strUtils.formatColumnName(columnData.getColName(), dbType, this.caseSensitive, this.loadDttmColumnName));
        }
    }

    protected void formatColumnName(List<String> columnList, DBType dbType) {
        columnList.replaceAll(word -> this.strUtils.formatColumnName(word, dbType, this.caseSensitive, this.loadDttmColumnName));
    }

    private void convertColumnsToNullable(List<ColumnData> srcColumnDataList) {
        for (ColumnData columnData : srcColumnDataList) {
            columnData.setNullable(true);
        }
    }

    protected void addColumnsAccordingConfigurationForCreate(List<CreationColumnData> creatingColumns) {
        this.appendColumnsToStgTable(creatingColumns);
        if (this.loadDttm) {
            creatingColumns.add(new CreationColumnData(this.loadDttmColumnName, "datetime", "datetime", true));
        }
    }

    protected void addColumnsAccordingConfiguration(List<ColumnData> columns) {
        if (this.loadDttm) {
            columns.add(new ColumnData(this.loadDttmColumnName, "datetime", null, null, null, true, null, false));
        }
    }

    protected void updateTrackingValueInTrackingTable(boolean shouldSaveFilter) throws SQLException {
        if (this.isTableExistInTrackingTable(this.sourceDbHandler.getFullTableName())) {
            this.updateTrackingRecord(shouldSaveFilter);
        } else {
            this.insertNewTrackingRecord();
        }
    }

    private boolean isTableExistInTrackingTable(String tableFullName) throws SQLException {
        String filter = "db_name='" + this.sourceDbHandler.getConfigSourceDbName() + "' and table_name_full='" + tableFullName + "'";
        ArrayList<ColumnData> columnDataList = new ArrayList<ColumnData>();
        columnDataList.add(new ColumnData("table_name_full", "text", null, null, null, true, null, false));
        String queryToExecute = this.queryComposer.composeSelectQuery(this.cdcTrackingTable, columnDataList, filter, this.loadDttmColumnName);
        String tableName = (String)this.catalogConnector.executeCommand(queryToExecute, QueryResultType.STRING);
        return tableName != null;
    }

    protected void updateParametersFromCatalogTable() throws SQLException {
        String filter = "UPPER(LOAD_TYPE)='" + String.valueOf(this.getTableType()) + "' and is_active=1 and db_name='" + this.sourceDbHandler.getConfigSourceDbName() + "' and table_name_full='" + this.sourceDbHandler.getFullTableName() + "'";
        String selectQuery = this.queryComposer.composeSelectQuery(this.cdcCatalogTable, null, filter, this.loadDttmColumnName);
        try (QueryResultData queryResultData = this.catalogConnector.executeCommandWithoutClosingStatement(selectQuery);){
            this.updateCatalogParameters(queryResultData.getResultSet());
        }
    }

    protected void updateCatalogParameters(ResultSet rsTableDetails) throws SQLException {
        int i = 0;
        while (rsTableDetails.next()) {
            this.updateSpecificParameters(rsTableDetails);
            this.statusLoadCurrent = rsTableDetails.getInt("status_load");
            ++i;
        }
        if (i == 0) {
            String errMsg = "This is a standard table, no records found in CDC catalog!";
            throw new SqloadRuntimeException(errMsg, ExitCode.CDC_ACTIVATION_ERROR, this.requestId);
        }
        if (i > 1) {
            log.warn("Multiple record found in catalog [{0}] for \"{}\" in {}", (Object)this.sourceDbHandler.getFullTableName(), (Object)this.cdcCatalogTable);
        }
    }

    protected List<PrimaryKeyData> getPrimaryKeysForTable() {
        List list;
        block8: {
            String selectQuery = this.queryComposer.composeSelectQueryForPrimaryKeys(this.cdcPrimaryKeyTable, this.sourceDbHandler.getConfigSourceDbName(), this.sourceDbHandler.getFullTableName(), this.loadDttmColumnName);
            QueryResultData queryResultData = this.catalogConnector.executeCommandWithoutClosingStatement(selectQuery);
            try {
                list = this.getPrimaryKeysFromResultSet(queryResultData.getResultSet());
                if (queryResultData == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (queryResultData != null) {
                        try {
                            queryResultData.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    throw new SqloadRuntimeException("Failed to get primary keys for table " + this.sourceDbHandler.getFullTableName(), this.requestId);
                }
            }
            queryResultData.close();
        }
        return list;
    }

    private List<PrimaryKeyData> getPrimaryKeysFromResultSet(ResultSet rs) throws SQLException {
        ArrayList<PrimaryKeyData> primaryKeyList = new ArrayList<PrimaryKeyData>();
        List srcColumnList = this.sourceDbHandler.getColumnsData();
        while (rs.next()) {
            Object colName = rs.getString("COLUMN_NAME");
            String nullable = rs.getString("IS_NULLABLE");
            ColumnData colData = this.getPrimaryKeyColumnData((String)colName, srcColumnList);
            String javaType = this.typeMappingService.getJavaType(this.sourceDbHandler.getDbType(), colData, this.caseSensitive);
            if (this.strUtils.checkUnexpectedIdentifier((String)colName)) {
                colName = "\"" + (String)colName + "\"";
            }
            primaryKeyList.add(new PrimaryKeyData((String)colName, nullable, javaType));
        }
        return primaryKeyList;
    }

    private ColumnData getPrimaryKeyColumnData(String primaryKey, List<ColumnData> columnList) {
        for (ColumnData colData : columnList) {
            if (!colData.getColName().equalsIgnoreCase(primaryKey)) continue;
            return colData;
        }
        String errMsg = "Cannot find primary key column \"" + primaryKey + "\" in source table column list!";
        throw new SqloadRuntimeException(errMsg, ExitCode.GET_PRIMARY_KEY_COLUMNS_ERROR, this.requestId);
    }

    public static TableType getCatalogTableType(String catalogTableName, DBType catalogDbType, DBType srcDbType, String sourceDatabaseName, String tableFullName, boolean caseSensitive, JDBCConnector catalogConnector, AbstractQueryComposer queryComposer) throws SQLException {
        if (Stream.of(srcDbType, catalogDbType).anyMatch(dbType -> !DBType.SUPPORTED_CATALOG_DB_TYPES.contains(dbType))) {
            return TableType.STD;
        }
        if (!catalogConnector.isExist(queryComposer.composeIsTableExistQuery(catalogTableName, caseSensitive, "0.0.0"))) {
            log.warn("CDC catalog table {} doesn't exist, relating to table as STD table.", (Object)catalogTableName);
            return TableType.STD;
        }
        String tableType = null;
        String filter = "is_active=1 and db_name='" + sourceDatabaseName + "' and table_name_full='" + tableFullName + "'";
        String selectQuery = AbstractQueryComposer.composeIsCatalogTableQuery((String)catalogTableName, null, (String)filter);
        try (QueryResultData queryResultData = catalogConnector.executeCommandWithoutClosingStatement(selectQuery);){
            ResultSet rsTableDetails = queryResultData.getResultSet();
            while (rsTableDetails.next()) {
                tableType = rsTableDetails.getString("load_type").toUpperCase();
            }
            if (tableType == null) {
                TableType tableType2 = TableType.STD;
                return tableType2;
            }
            if (tableType.equalsIgnoreCase("INC")) {
                TableType tableType3 = TableType.INC;
                return tableType3;
            }
            if (tableType.equalsIgnoreCase("CDC")) {
                TableType tableType4 = TableType.CDC;
                return tableType4;
            }
            TableType tableType5 = null;
            return tableType5;
        }
    }

    public void unlockTable() throws SQLException {
        this.changeLoadStatus(0);
    }

    public void insertMonitorRecordToSummaryTable(Map<String, String> loadSummaryMap) throws SQLException {
        String insertSummaryRecord = this.queryComposer.composeInsertSummaryRecord(loadSummaryMap, this.loadSummaryTable);
        this.catalogConnector.executeCommand(insertSummaryRecord, QueryResultType.IGNORE);
    }

    public boolean isTherePrimaryKey() {
        return this.primaryKeyList != null && !this.primaryKeyList.isEmpty();
    }

    protected String getColumnNameForSelect(ColumnData columnData) {
        if (columnData.getColType().equalsIgnoreCase("rowid")) {
            return "RAWTOHEX(" + columnData.getColName() + ") as ORA_ROW_ID";
        }
        return columnData.getColName();
    }

    public boolean isNewRecordsAdded() throws SQLException {
        return false;
    }

    public void resetConnection() throws SQLException {
        this.catalogConnector.close();
        this.catalogConnector.connect();
    }

    @Override
    public void close() throws SQLException {
        log.info("Close Catalog connection");
        this.catalogConnector.close();
    }

    public List<ColumnData> getColumnDataCdcList() {
        return this.columnDataCdcList;
    }
}

