/*
 * Decompiled with CFR 0.152.
 */
package com.sqream.sqloaderService.dbhandler;

import com.sqream.sqloader.common.enums.DBType;
import com.sqream.sqloaderService.configuration.BeanUtil;
import com.sqream.sqloaderService.configuration.JdbcConnectorFactory;
import com.sqream.sqloaderService.dbhandler.SourceDbHandler;
import com.sqream.sqloaderService.dbhandler.connectors.QueryResultData;
import com.sqream.sqloaderService.dto.ColumnData;
import com.sqream.sqloaderService.dto.SelectColumnData;
import com.sqream.sqloaderService.dto.TableSplitData;
import com.sqream.sqloaderService.dto.dbconfigdata.SourceConfigData;
import com.sqream.sqloaderService.dto.dbconfigdata.TableConfigData;
import com.sqream.sqloaderService.enums.ExitCode;
import com.sqream.sqloaderService.exceptions.SqloadRuntimeException;
import com.sqream.sqloaderService.querycomposer.AbstractQueryComposer;
import com.sqream.sqloaderService.querycomposer.SqreamQueryComposer;
import com.sqream.sqloaderService.typemapping.TypeMappingService;
import com.sqream.sqloaderService.utils.sqreamutils.SqreamVersions;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SqreamSourceDbHandler
extends SourceDbHandler {
    private static final Logger log = LoggerFactory.getLogger(SqreamSourceDbHandler.class);
    String sqreamVersion;
    SqreamVersions sqreamVersions;

    public SqreamSourceDbHandler(TableConfigData tableConfigData, SourceConfigData sourceConfigData, JdbcConnectorFactory jdbcConnectorFactory, TypeMappingService typeMapping, String requestId) {
        super(tableConfigData, sourceConfigData, jdbcConnectorFactory, typeMapping, requestId);
        this.queryComposer = (AbstractQueryComposer)BeanUtil.getBean(SqreamQueryComposer.class);
        this.sqreamVersions = (SqreamVersions)BeanUtil.getBean(SqreamVersions.class);
    }

    public void init() throws SQLException {
        super.init();
        this.sqreamVersion = this.sqreamVersions.getSqreamVersion(this.tableConfigData.getConnectionString(), this.jdbcConnector);
    }

    public DBType getDbType() {
        return DBType.SQREAM;
    }

    public Map<Integer, List<SelectColumnData>> getSelectQueryList(List<ColumnData> columnsForSelect) throws SQLException {
        if (this.threadCount == 1) {
            return super.getSelectQueryList(columnsForSelect);
        }
        List tableSplitDataList = this.splitTable(this.threadCount, 0);
        if (tableSplitDataList == null || tableSplitDataList.size() != this.threadCount) {
            log.warn("Cannot split table to defined number of threads [{}].", (Object)this.threadCount);
            if (tableSplitDataList == null || tableSplitDataList.isEmpty()) {
                log.warn("Thread count will be changed to 1");
                this.threadCount = 1;
                return super.getSelectQueryList(columnsForSelect);
            }
            if (tableSplitDataList.size() != this.threadCount) {
                log.warn("Thread count will be changed to {}", (Object)tableSplitDataList.size());
                this.threadCount = tableSplitDataList.size();
            }
        }
        HashMap<Integer, List<SelectColumnData>> selectListPerThread = new HashMap<Integer, List<SelectColumnData>>();
        for (int threadId = 0; threadId < this.threadCount; ++threadId) {
            ArrayList<SelectColumnData> selectColumnDataList = new ArrayList<SelectColumnData>();
            List columnList = this.getColumnListForSelect(columnsForSelect);
            int limit = this.sourceConfigData.getLimit() != 0 ? ((TableSplitData)tableSplitDataList.get(threadId)).getRowCount() : 0;
            selectColumnDataList.add(new SelectColumnData(this.tableConfigData.getTableFullName(), columnList, this.sourceConfigData.getFilter(), limit, null, null, (TableSplitData)tableSplitDataList.get(threadId)));
            selectListPerThread.put(threadId, selectColumnDataList);
        }
        return selectListPerThread;
    }

    protected List<TableSplitData> splitTable(int threadCount, int recordCount) {
        try {
            return this.getMinMaxChunkIdList(threadCount);
        }
        catch (SQLException e) {
            return null;
        }
    }

    private List<TableSplitData> getMinMaxChunkIdList(int threadCount) throws SQLException {
        return null;
    }

    public List<ColumnData> getColumnsData(String schemaName, String tableName, List<String> configColumnList) throws SQLException {
        String columnListQuery = this.queryComposer.composeColumnListQuery(schemaName, tableName, configColumnList, this.sqreamVersion);
        try (QueryResultData queryResultData = this.jdbcConnector.executeCommandWithoutClosingStatement(columnListQuery);){
            List columnDataList = this.getColumns(queryResultData.getResultSet());
            if (columnDataList.isEmpty()) {
                throw new SqloadRuntimeException("Requested columns were not found in source table", ExitCode.GET_COLUMNS_ERROR, this.requestId);
            }
            List list = columnDataList;
            return list;
        }
    }

    public String getSqreamVersion() {
        return this.sqreamVersion;
    }
}

