/*
 * Decompiled with CFR 0.152.
 */
package com.sqream.sqloaderService.dbhandler;

import com.sqream.sqloader.common.enums.DBType;
import com.sqream.sqloaderService.configuration.BeanUtil;
import com.sqream.sqloaderService.configuration.JdbcConnectorFactory;
import com.sqream.sqloaderService.dbhandler.AbstractDbHandler;
import com.sqream.sqloaderService.dbhandler.connectors.QueryResultData;
import com.sqream.sqloaderService.dto.CreationColumnData;
import com.sqream.sqloaderService.dto.dbconfigdata.TableConfigData;
import com.sqream.sqloaderService.enums.ExitCode;
import com.sqream.sqloaderService.enums.QueryResultType;
import com.sqream.sqloaderService.exceptions.SqloadRuntimeException;
import com.sqream.sqloaderService.querycomposer.AbstractQueryComposer;
import com.sqream.sqloaderService.querycomposer.SqreamQueryComposer;
import com.sqream.sqloaderService.typemapping.TypeMappingService;
import com.sqream.sqloaderService.utils.LogUtils;
import com.sqream.sqloaderService.utils.StrUtils;
import com.sqream.sqloaderService.utils.sqreamutils.SqreamVersions;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SqreamDbHandler
extends AbstractDbHandler {
    private static final Logger log = LoggerFactory.getLogger(SqreamDbHandler.class);
    boolean caseSensitive;
    SqreamVersions sqreamVersions;
    String sqreamVersion;
    String sqreamFinalTableName;
    String sqreamDatabaseName;
    String loadDttmColumnName;

    public SqreamDbHandler(TableConfigData tableConfigData, JdbcConnectorFactory jdbcConnectorFactory, TypeMappingService typeMappingService, boolean caseSensitive, String sqreamFinalTableName, String sqreamDatabaseName, String loadDttmColumnName, String requestId) throws SQLException {
        super(tableConfigData, jdbcConnectorFactory, "QUERY-SQ", typeMappingService, requestId);
        this.queryComposer = (AbstractQueryComposer)BeanUtil.getBean(SqreamQueryComposer.class);
        this.sqreamVersions = (SqreamVersions)BeanUtil.getBean(SqreamVersions.class);
        this.caseSensitive = caseSensitive;
        this.sqreamFinalTableName = sqreamFinalTableName;
        this.sqreamDatabaseName = sqreamDatabaseName;
        this.loadDttmColumnName = loadDttmColumnName;
    }

    public void init() throws SQLException {
        this.jdbcConnector.connect();
        this.sqreamVersion = this.sqreamVersions.getSqreamVersion(this.tableConfigData.getConnectionString(), this.jdbcConnector);
    }

    public DBType getDbType() {
        return DBType.SQREAM;
    }

    public void executeCommand(String query, QueryResultType queryResultType) throws SQLException {
        this.jdbcConnector.executeCommand(query, queryResultType);
    }

    public List<CreationColumnData> getColumnsName() throws SQLException {
        String query = this.queryComposer.composeMetadataQuery(this.tableConfigData.getTableFullName());
        ArrayList<CreationColumnData> columns = new ArrayList<CreationColumnData>();
        try (QueryResultData queryResultData = this.jdbcConnector.executeCommandWithoutClosingStatement(query);){
            ResultSetMetaData meta = queryResultData.getResultSet().getMetaData();
            for (int i = 1; i <= meta.getColumnCount(); ++i) {
                String columnName = meta.getColumnName(i);
                String columnType = meta.getColumnTypeName(i);
                int isNullable = meta.isNullable(i);
                String javaColumnType = this.typeMapping.getJavaType(this.getDbType(), null, this.caseSensitive);
                columns.add(new CreationColumnData(columnName, columnType, javaColumnType, isNullable != 0));
            }
            ArrayList<CreationColumnData> arrayList = columns;
            return arrayList;
        }
    }

    public Map<String, String> getColumnTypesOfTarget() throws SQLException {
        HashMap<String, String> columnTypes = new HashMap<String, String>();
        String query = this.queryComposer.composeMetadataQuery(this.tableConfigData.getTableFullName());
        try (QueryResultData queryResultData = this.jdbcConnector.executeCommandWithoutClosingStatement(query);){
            ResultSetMetaData metaData = queryResultData.getResultSet().getMetaData();
            for (int i = 1; i <= metaData.getColumnCount(); ++i) {
                String columnName = metaData.getColumnName(i);
                String columnType = metaData.getColumnTypeName(i);
                columnTypes.put(columnName.toLowerCase(), columnType);
                log.trace("target column name: {}, target column type: {}", (Object)columnName, (Object)columnType);
            }
            HashMap<String, String> hashMap = columnTypes;
            return hashMap;
        }
    }

    public void createFullTemp(String sourceTable) {
        try {
            String createTableQuery = this.queryComposer.composeCreateAsSelect(sourceTable, this.getFullTableName());
            this.jdbcConnector.executeCommand(createTableQuery, QueryResultType.IGNORE);
            log.info("Temp table {} created successfully in {} DB", (Object)this.getFullTableName(), (Object)this.getDbType());
        }
        catch (SQLException e) {
            String errMsg = MessageFormat.format("Table {0} create didn''t succeed in {1} DB. Error is: {2}", this.getFullTableName(), this.getDbType(), LogUtils.exceptionFormat((String)e.toString()));
            throw new SqloadRuntimeException(errMsg, ExitCode.TARGET_TABLE_CREATION_ERROR, this.requestId);
        }
    }

    public void close() throws SQLException {
        super.close();
    }

    public boolean isTableExist(String schemaName, String tableName) {
        String query = this.queryComposer.composeIsTableExistQuery(this.sqreamDatabaseName, schemaName, tableName, this.sqreamVersion);
        return this.getTableIfExist(query) != null;
    }

    public boolean isViewExist(String schemaName, String tableName) {
        String query = this.queryComposer.composeIsViewExistQuery(this.sqreamDatabaseName, schemaName, tableName, this.sqreamVersion);
        return this.getTableIfExist(query) != null;
    }

    protected String getLoadDttmColumnName() {
        return this.loadDttmColumnName;
    }

    private String getTableIfExist(String getTableQuery) {
        try {
            String res = (String)this.jdbcConnector.executeCommand(getTableQuery, QueryResultType.STRING);
            if (res == null || res.equals("0") || res.equals("false")) {
                return null;
            }
            return res;
        }
        catch (SQLException e) {
            log.error("an error occurred {}", (Object)LogUtils.exceptionFormat((String)e.getMessage()));
            return null;
        }
    }

    public void alterView(String fullViewName, String schemaName, String viewName, String alteredViewName) {
        String alteredViewDdl;
        String viewDdl = StrUtils.removeNewLines((String)this.getViewDdl(schemaName, viewName));
        if (viewDdl.equals(alteredViewDdl = viewDdl.replaceFirst("(?i)\\b" + viewName + "\\b", alteredViewName))) {
            alteredViewDdl = viewDdl.replaceFirst("(?i)\\b" + viewName.replace("\"", "") + "\\b", alteredViewName.replace("\"", ""));
        }
        try {
            this.jdbcConnector.executeCommand(alteredViewDdl, QueryResultType.IGNORE);
        }
        catch (SQLException e) {
            String errMsg = MessageFormat.format("Creating view {0} based on {1} didn''t succeed in {2} DB. Error is: {3}", alteredViewName, viewName, this.getDbType(), LogUtils.exceptionFormat((String)e.getMessage()));
            throw new SqloadRuntimeException(errMsg, ExitCode.TARGET_TABLE_ALTER_ERROR, this.requestId);
        }
        this.dropView(fullViewName);
        log.info("View {} name altered successfully into {} in {} DB", new Object[]{viewName, alteredViewName, this.getDbType()});
    }

    private String getViewDdl(String schemaName, String viewName) {
        try {
            String getViewDdlQuery = this.queryComposer.composeGetViewDdl(schemaName, viewName);
            return (String)this.jdbcConnector.executeCommand(getViewDdlQuery, QueryResultType.STRING);
        }
        catch (SQLException e) {
            throw new SqloadRuntimeException("Failed to retrieve view DDL in SQream. Error is: " + LogUtils.exceptionFormat((String)e.getMessage()), ExitCode.TARGET_TABLE_ALTER_ERROR, this.requestId);
        }
    }

    public void swapTables(String schemaName, String firstTable, String secondTable) {
        try {
            String query = this.queryComposer.composeSwapTables(schemaName, firstTable, secondTable);
            this.jdbcConnector.executeCommand(query, QueryResultType.IGNORE);
            log.info("Tables {}.{} and {}.{} swapped successfully in {} DB", new Object[]{schemaName, firstTable, schemaName, secondTable, this.getDbType()});
        }
        catch (SQLException e) {
            throw new SqloadRuntimeException("Failed to swap tables in SQream. Error is: " + LogUtils.exceptionFormat((String)e.getMessage()), ExitCode.TARGET_TABLE_ALTER_ERROR, this.requestId);
        }
    }

    public void cleanupTable(String schemaName, String tableName) throws SQLException {
        String cleanupQuery = this.queryComposer.composeCleanupChucksQuery(schemaName, tableName);
        this.executeCommand(cleanupQuery, QueryResultType.IGNORE);
        cleanupQuery = this.queryComposer.composeCleanupExtentsQuery(schemaName, tableName);
        this.executeCommand(cleanupQuery, QueryResultType.IGNORE);
    }

    public void alterTableColumns(Map<String, String> missingKeysMap) throws SQLException {
        String alterQuery = this.queryComposer.compoAlterQueryColumns(missingKeysMap, this.sqreamFinalTableName);
        this.executeCommand(alterQuery, QueryResultType.IGNORE);
        alterQuery = this.queryComposer.compoAlterQueryColumns(missingKeysMap, this.tableConfigData.getTableFullName());
        this.executeCommand(alterQuery, QueryResultType.IGNORE);
    }

    public String getSqreamVersion() {
        return this.sqreamVersion;
    }

    public String getSqreamFinalTableName() {
        return this.sqreamFinalTableName;
    }
}

