/*
 * Decompiled with CFR 0.152.
 */
package com.sqream.sqloaderService.dbhandler;

import com.sqream.sqloaderService.configuration.JdbcConnectorFactory;
import com.sqream.sqloaderService.dbhandler.AbstractDbHandler;
import com.sqream.sqloaderService.dto.ColumnData;
import com.sqream.sqloaderService.dto.SelectColumnData;
import com.sqream.sqloaderService.dto.TableSplitData;
import com.sqream.sqloaderService.dto.dbconfigdata.SourceConfigData;
import com.sqream.sqloaderService.dto.dbconfigdata.TableConfigData;
import com.sqream.sqloaderService.enums.ExitCode;
import com.sqream.sqloaderService.enums.QueryResultType;
import com.sqream.sqloaderService.exceptions.SqloadInitException;
import com.sqream.sqloaderService.exceptions.SqloadRuntimeException;
import com.sqream.sqloaderService.typemapping.TypeMappingService;
import com.sqream.sqloaderService.utils.LogUtils;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SourceDbHandler
extends AbstractDbHandler {
    private static final Logger log = LoggerFactory.getLogger(SourceDbHandler.class);
    SourceConfigData sourceConfigData;
    int threadCount;
    int rowCount = 0;
    protected int partitionCount;

    public SourceDbHandler(TableConfigData tableConfigData, SourceConfigData sourceConfigData, JdbcConnectorFactory jdbcConnectorFactory, TypeMappingService typeMapping, String requestId) {
        super(tableConfigData, jdbcConnectorFactory, "QUERY-SRC", typeMapping, requestId);
        this.sourceConfigData = sourceConfigData;
        this.threadCount = sourceConfigData.getThreadCount();
    }

    public void init() throws SQLException {
        super.init();
        if (this.sourceConfigData.isValidateSourceTable() && !this.isTableExist(this.tableConfigData.getSchemaName(), this.tableConfigData.getTableName()) && !this.isViewExist(this.tableConfigData.getSchemaName(), this.tableConfigData.getTableName())) {
            throw new SqloadInitException("Source table: " + this.getFullTableName() + " was not found in source database", ExitCode.SOURCE_TABLE_NOT_FOUND_ERROR, this.requestId);
        }
        this.updatePartitionData(this.sourceConfigData.getPartitionName());
        if (!this.sourceConfigData.isUsePartitions() && this.getPartitionCount() > 0) {
            log.info("Using partitions disabled by configuration/parameter");
            if (this.threadCount > 1) {
                String errMsg = "You cannot execute multithread loads for partitioned tables without partitioning!";
                throw new SqloadInitException(errMsg, ExitCode.PARAMETER_CONFIGURATION_ERROR, this.requestId);
            }
        }
        if (this.sourceConfigData.getPartitionName() != null) {
            if (this.threadCount > 1) {
                log.warn("You cannot use multi thread option with partition parameter! thread count will be changed to 1");
                this.threadCount = 1;
            }
        } else if (this.isPartitioned() && this.threadCount > this.partitionCount) {
            log.warn("Table partition count is bigger than thread count. Thread count will be changed to {}!", (Object)this.partitionCount);
            int n = this.threadCount = this.getPartitionCount() > 0 ? this.getPartitionCount() : 1;
        }
        if (!this.isPartitioned() && this.sourceConfigData.isCount()) {
            log.info("Counting table rows on source db");
            this.rowCount = this.getTableRowCount(this.sourceConfigData.getFilter(), this.sourceConfigData.getLimit());
            if (this.sourceConfigData.getLimit() == 0) {
                log.info("Table row count: " + this.rowCount);
            } else {
                log.info("Table row count (limited by configuration): " + this.rowCount);
            }
        }
    }

    protected void updatePartitionData(String partitionName) throws SQLException {
    }

    public boolean isPartitioned() {
        return false;
    }

    protected int getTableRowCount(String filter, int limit) throws SqloadRuntimeException {
        int row_count = 0;
        int count = 0;
        String countQuery = this.queryComposer.composeRowCountQuery(this.tableConfigData.getTableFullName(), filter);
        try {
            row_count = count = ((Integer)this.jdbcConnector.executeCommand(countQuery, QueryResultType.COUNT)).intValue();
            if (limit > 0 && row_count > limit) {
                row_count = limit;
            }
        }
        catch (SQLException e) {
            throw new SqloadRuntimeException(LogUtils.exceptionFormat((String)e.toString()), ExitCode.ROW_COUNT_ERROR, this.requestId);
        }
        return row_count;
    }

    protected List<TableSplitData> splitTable(int threadCount, int recordCount) throws SQLException {
        ArrayList<TableSplitData> retval = new ArrayList<TableSplitData>();
        int rowPerChunk = recordCount / threadCount;
        for (int i = 0; i < threadCount; ++i) {
            int from = i * rowPerChunk + 1;
            int to = (i + 1) * rowPerChunk;
            if (i + 1 == threadCount) {
                to = recordCount;
            }
            int chunk_row_count = to - from + 1;
            retval.add(new TableSplitData((Object)from, (Object)to, chunk_row_count));
        }
        return retval;
    }

    protected List<String> getColumnListForSelect(List<ColumnData> columnDataList) {
        ArrayList<String> columnListForSelect = new ArrayList<String>();
        for (ColumnData columnData : columnDataList) {
            columnListForSelect.add(this.getColumnNameForSelect(columnData));
        }
        return columnListForSelect;
    }

    protected String getColumnNameForSelect(ColumnData columnData) {
        return columnData.getColName();
    }

    public Map<Integer, List<SelectColumnData>> getSelectQueryList(List<ColumnData> columnsForSelect) throws SQLException {
        HashMap<Integer, List<SelectColumnData>> selectQueriesPerThread = new HashMap<Integer, List<SelectColumnData>>();
        List columnList = this.getColumnListForSelect(columnsForSelect);
        if (this.threadCount == 1) {
            ArrayList<SelectColumnData> selectColumnData = new ArrayList<SelectColumnData>();
            selectColumnData.add(new SelectColumnData(this.tableConfigData.getTableFullName(), columnList, this.sourceConfigData.getFilter(), this.sourceConfigData.getLimit(), this.sourceConfigData.getPartitionName(), this.sourceConfigData.getSplitByColumn(), null));
            selectQueriesPerThread.put(0, selectColumnData);
            return selectQueriesPerThread;
        }
        List tableSplitDataList = this.splitTable(this.threadCount, this.rowCount);
        int threadId = 0;
        for (TableSplitData tableSplitData : tableSplitDataList) {
            ArrayList<SelectColumnData> selectColumnData = new ArrayList<SelectColumnData>();
            selectColumnData.add(new SelectColumnData(this.tableConfigData.getTableFullName(), columnList, this.sourceConfigData.getFilter(), this.sourceConfigData.getLimit() / this.threadCount, null, this.sourceConfigData.getSplitByColumn(), tableSplitData));
            selectQueriesPerThread.put(threadId, selectColumnData);
            ++threadId;
        }
        return selectQueriesPerThread;
    }

    public void addColumnsAccordingConfiguration(List<ColumnData> srcColumnDataList) {
        if (this.sourceConfigData.isSqLoadDttm()) {
            srcColumnDataList.add(new ColumnData(this.sourceConfigData.getSqLoadDttmColumnName(), "datetime", null, null, null, true, null, false));
        }
    }

    public String getConfigSourceDbName() {
        return this.sourceConfigData.getSrcDbName();
    }

    public boolean isExist(List<ColumnData> srcColumnData, String columnName) {
        for (ColumnData columnData : srcColumnData) {
            if (!columnData.getColName().equals(columnName)) continue;
            return true;
        }
        return false;
    }

    public void close() throws SQLException {
        super.close();
    }

    public List<ColumnData> getColumnsDataCopy() throws SQLException {
        if (this.columnDataList == null) {
            this.getColumnsData();
        }
        ArrayList<ColumnData> srcColumnDataList = new ArrayList<ColumnData>();
        for (ColumnData columnData : this.columnDataList) {
            srcColumnDataList.add(new ColumnData(columnData));
        }
        return srcColumnDataList;
    }

    protected String getLoadDttmColumnName() {
        return this.sourceConfigData.getSqLoadDttmColumnName();
    }

    public String getFilter() {
        return this.sourceConfigData.getFilter();
    }

    public int getThreadCount() {
        return this.threadCount;
    }

    public int getPartitionCount() {
        return this.partitionCount;
    }
}

