/*
 * Decompiled with CFR 0.152.
 */
package com.sqream.sqloaderService.dbhandler;

import com.sqream.sqloader.common.enums.DBType;
import com.sqream.sqloaderService.configuration.BeanUtil;
import com.sqream.sqloaderService.configuration.JdbcConnectorFactory;
import com.sqream.sqloaderService.dbhandler.SourceDbHandler;
import com.sqream.sqloaderService.dto.ColumnData;
import com.sqream.sqloaderService.dto.dbconfigdata.SourceConfigData;
import com.sqream.sqloaderService.dto.dbconfigdata.TableConfigData;
import com.sqream.sqloaderService.querycomposer.AbstractQueryComposer;
import com.sqream.sqloaderService.querycomposer.SapQueryComposer;
import com.sqream.sqloaderService.typemapping.TypeMappingService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SapSourceDbHandler
extends SourceDbHandler {
    private static final Logger log = LoggerFactory.getLogger(SapSourceDbHandler.class);

    public SapSourceDbHandler(TableConfigData tableConfigData, SourceConfigData sourceConfigData, JdbcConnectorFactory jdbcConnectorFactory, TypeMappingService typeMapping, String requestId) {
        super(tableConfigData, sourceConfigData, jdbcConnectorFactory, typeMapping, requestId);
        this.queryComposer = (AbstractQueryComposer)BeanUtil.getBean(SapQueryComposer.class);
    }

    public DBType getDbType() {
        return DBType.SAP;
    }

    protected String getColumnNameForSelect(ColumnData columnData) {
        if (columnData.getColType().equalsIgnoreCase("varbinary")) {
            return "TO_ALPHANUM(" + columnData.getColName() + ")";
        }
        return columnData.getColName();
    }
}

