/*
 * Decompiled with CFR 0.152.
 */
package com.sqream.sqloaderService.dbhandler;

import com.sqream.sqloader.common.enums.DBType;
import com.sqream.sqloaderService.configuration.BeanUtil;
import com.sqream.sqloaderService.configuration.JdbcConnectorFactory;
import com.sqream.sqloaderService.dbhandler.SourceDbHandler;
import com.sqream.sqloaderService.dbhandler.connectors.QueryResultData;
import com.sqream.sqloaderService.dto.ColumnData;
import com.sqream.sqloaderService.dto.SelectColumnData;
import com.sqream.sqloaderService.dto.TableSplitData;
import com.sqream.sqloaderService.dto.dbconfigdata.SourceConfigData;
import com.sqream.sqloaderService.dto.dbconfigdata.TableConfigData;
import com.sqream.sqloaderService.enums.QueryResultType;
import com.sqream.sqloaderService.querycomposer.AbstractQueryComposer;
import com.sqream.sqloaderService.querycomposer.OracleQueryComposer;
import com.sqream.sqloaderService.typemapping.TypeMappingService;
import com.sqream.sqloaderService.utils.LogUtils;
import com.sqream.sqloaderService.utils.StrUtils;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class OracleSourceDbHandler
extends SourceDbHandler {
    private static final Logger log = LoggerFactory.getLogger(OracleSourceDbHandler.class);
    StrUtils strUtils = (StrUtils)BeanUtil.getBean(StrUtils.class);
    List<String> partitionList;

    public OracleSourceDbHandler(TableConfigData tableConfigData, SourceConfigData sourceConfigData, JdbcConnectorFactory jdbcConnectorFactory, TypeMappingService typeMapping, String requestId) {
        super(tableConfigData, sourceConfigData, jdbcConnectorFactory, typeMapping, requestId);
        this.logUtils = (LogUtils)BeanUtil.getBean(LogUtils.class);
        this.queryComposer = (AbstractQueryComposer)BeanUtil.getBean(OracleQueryComposer.class);
    }

    public DBType getDbType() {
        return DBType.ORCL;
    }

    public void updatePartitionData(String partitionName) throws SQLException {
        this.partitionList = this.getPartitionList();
        int n = this.partitionCount = this.partitionList != null ? this.partitionList.size() : 0;
        if (this.partitionList.isEmpty()) {
            log.info("Table is not partitioned!");
        } else {
            log.info("Table has {} partitions!", (Object)this.partitionCount);
        }
        if (partitionName != null && !partitionName.isEmpty()) {
            this.partitionList = new ArrayList();
            this.partitionList.add(partitionName);
            this.partitionCount = this.partitionList.size();
        }
    }

    public boolean isPartitioned() {
        return this.sourceConfigData.isUsePartitions() && this.partitionCount > 0;
    }

    private List<String> getPartitionList() throws SQLException {
        String sqlString = this.queryComposer.composePartitionListQuery(this.tableConfigData.getSchemaName(), this.tableConfigData.getTableName());
        try (QueryResultData queryResultData = this.jdbcConnector.executeCommandWithoutClosingStatement(sqlString);){
            ResultSet rsPartitions = queryResultData.getResultSet();
            ArrayList<String> partitionList = new ArrayList<String>();
            while (rsPartitions.next()) {
                String partitionName = rsPartitions.getString("PARTITION_NAME");
                partitionList.add(partitionName);
            }
            ArrayList<String> arrayList = partitionList;
            return arrayList;
        }
    }

    protected String getColType(String colType) {
        if (colType.toLowerCase().contains("timestamp(")) {
            return "TIMESTAMP";
        }
        return colType;
    }

    protected List<TableSplitData> splitTable(int threadCount, int recordCount) {
        try {
            return this.getMinMaxRowIdList(threadCount);
        }
        catch (SQLException e) {
            return null;
        }
    }

    private List<TableSplitData> getMinMaxRowIdList(int threadCount) throws SQLException {
        ArrayList<TableSplitData> splitDataList = new ArrayList<TableSplitData>();
        String getMinMaxRowsQuery = this.queryComposer.composeGetMinMaxRowsQuery(threadCount, this.tableConfigData.getSchemaName(), this.tableConfigData.getTableName());
        try (QueryResultData queryResultData = this.jdbcConnector.executeCommandWithoutClosingStatement(getMinMaxRowsQuery);){
            ResultSet rsRowId = queryResultData.getResultSet();
            while (rsRowId.next()) {
                String minRowid = rsRowId.getString("MIN_ROWID");
                String maxRowid = rsRowId.getString("MAX_ROWID");
                int counter = 0;
                if (this.sourceConfigData.isCount()) {
                    Object filter = String.format("rowid between '%s' and '%s'", minRowid, maxRowid);
                    if (this.sourceConfigData.getLimit() > 0) {
                        filter = (String)filter + " and rownum<=" + this.sourceConfigData.getLimit() / threadCount;
                    }
                    String countQuery = this.queryComposer.composeCountQuery(this.tableConfigData.getTableFullName(), (String)filter);
                    counter = (Integer)this.jdbcConnector.executeCommand(countQuery, QueryResultType.COUNT);
                }
                splitDataList.add(new TableSplitData((Object)minRowid, (Object)maxRowid, counter));
            }
            ArrayList<TableSplitData> arrayList = splitDataList;
            return arrayList;
        }
    }

    public Map<Integer, List<SelectColumnData>> getSelectQueryList(List<ColumnData> columnsForSelect) throws SQLException {
        if (this.threadCount == 1 && !this.isPartitioned()) {
            return super.getSelectQueryList(columnsForSelect);
        }
        HashMap<Integer, List<SelectColumnData>> selectListPerThread = null;
        if (this.isPartitioned()) {
            selectListPerThread = this.SplitPartitionedTable(this.threadCount, columnsForSelect);
            return selectListPerThread;
        }
        List tableSplitDataList = this.splitTable(this.threadCount, 0);
        if (tableSplitDataList == null || tableSplitDataList.size() != this.threadCount) {
            log.warn("Cannot split table to defined number of threads [{}].", (Object)this.threadCount);
            if (tableSplitDataList == null || tableSplitDataList.isEmpty()) {
                log.warn("Thread count will be changed to 1");
                this.threadCount = 1;
                return super.getSelectQueryList(columnsForSelect);
            }
            if (tableSplitDataList.size() != this.threadCount) {
                log.warn("Thread count will be changed to {}", (Object)tableSplitDataList.size());
                this.threadCount = tableSplitDataList.size();
            }
        }
        selectListPerThread = new HashMap<Integer, List<SelectColumnData>>();
        for (int threadId = 0; threadId < this.threadCount; ++threadId) {
            ArrayList<SelectColumnData> selectColumnDataList = new ArrayList<SelectColumnData>();
            List columnList = this.getColumnListForSelect(columnsForSelect);
            int limit = this.sourceConfigData.getLimit() != 0 ? ((TableSplitData)tableSplitDataList.get(threadId)).getRowCount() : 0;
            selectColumnDataList.add(new SelectColumnData(this.tableConfigData.getTableFullName(), columnList, this.sourceConfigData.getFilter(), limit, null, null, (TableSplitData)tableSplitDataList.get(threadId)));
            selectListPerThread.put(threadId, selectColumnDataList);
        }
        return selectListPerThread;
    }

    private Map<Integer, List<SelectColumnData>> SplitPartitionedTable(int threadCount, List<ColumnData> columnsForSelect) {
        List columnList = this.getColumnListForSelect(columnsForSelect);
        HashMap<Integer, List<SelectColumnData>> columnListPerThread = new HashMap<Integer, List<SelectColumnData>>();
        int threadId = 0;
        for (String partition : this.partitionList) {
            columnListPerThread.computeIfAbsent(threadId, k -> new ArrayList());
            List selectList = (List)columnListPerThread.get(threadId);
            SelectColumnData selectColumnData = new SelectColumnData(this.tableConfigData.getTableFullName(), columnList, this.sourceConfigData.getFilter(), this.sourceConfigData.getLimit(), partition, null, null);
            selectList.add(selectColumnData);
            ++threadId;
            threadId %= threadCount;
        }
        return columnListPerThread;
    }

    protected String getColumnNameForSelect(ColumnData columnData) {
        if (this.sourceConfigData.isUseDbmsLob()) {
            if (columnData.getColType().equalsIgnoreCase("clob")) {
                return "DBMS_LOB.substr(" + columnData.getColName() + ") AS " + columnData.getColName();
            }
            if (columnData.getColType().equalsIgnoreCase("blob")) {
                return "utl_raw.cast_to_varchar2(dbms_lob.substr(" + columnData.getColName() + ")) AS " + columnData.getColName();
            }
        }
        if (columnData.getColType().equalsIgnoreCase("raw") || columnData.getColType().equalsIgnoreCase("rowid") || columnData.getColType().equalsIgnoreCase("urowid")) {
            return "RAWTOHEX(" + columnData.getColName() + ") AS " + columnData.getColName();
        }
        return columnData.getColName();
    }

    public void addColumnsAccordingConfiguration(List<ColumnData> srcColumnDataList) {
        super.addColumnsAccordingConfiguration(srcColumnDataList);
        if (this.sourceConfigData.isRowId()) {
            srcColumnDataList.add(new ColumnData("ora_row_id", "text", null, null, null, true, null, false));
        }
    }

    public List<ColumnData> getCdcColumnsData(List<ColumnData> cdcColumnDataList) throws SQLException {
        List columnDataList = this.getColumnsDataCopy();
        for (ColumnData columnData : cdcColumnDataList) {
            if (this.isExist(columnDataList, columnData.getColName())) continue;
            columnDataList.add(new ColumnData(columnData.getColName(), columnData.getColType(), "", columnData.getColPrec(), columnData.getColFrac(), columnData.isNullable(), null, false));
        }
        this.addColumnsAccordingConfiguration(columnDataList);
        return columnDataList;
    }

    public int getPartitionCount() {
        return this.partitionList != null ? this.partitionList.size() : 0;
    }
}

