/*
 * Decompiled with CFR 0.152.
 */
package com.sqream.sqloaderService.dbhandler;

import com.sqream.sqloader.common.enums.DBType;
import com.sqream.sqloaderService.configuration.BeanUtil;
import com.sqream.sqloaderService.configuration.JdbcConnectorFactory;
import com.sqream.sqloaderService.dbhandler.SourceDbHandler;
import com.sqream.sqloaderService.dto.ColumnData;
import com.sqream.sqloaderService.dto.dbconfigdata.SourceConfigData;
import com.sqream.sqloaderService.dto.dbconfigdata.TableConfigData;
import com.sqream.sqloaderService.querycomposer.AbstractQueryComposer;
import com.sqream.sqloaderService.querycomposer.MssqlQueryComposer;
import com.sqream.sqloaderService.typemapping.TypeMappingService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MssqlSourceDbHandler
extends SourceDbHandler {
    private static final Logger log = LoggerFactory.getLogger(MssqlSourceDbHandler.class);

    public MssqlSourceDbHandler(TableConfigData tableConfigData, SourceConfigData sourceConfigData, JdbcConnectorFactory jdbcConnectorFactory, TypeMappingService typeMapping, String requestId) {
        super(tableConfigData, sourceConfigData, jdbcConnectorFactory, typeMapping, requestId);
        this.queryComposer = (AbstractQueryComposer)BeanUtil.getBean(MssqlQueryComposer.class);
    }

    public DBType getDbType() {
        return DBType.MSSQL;
    }

    protected String getColumnNameForSelect(ColumnData columnData) {
        if (columnData.getColType().equalsIgnoreCase("varbinary")) {
            return "convert(varchar(1000)," + columnData.getColName() + ",2) as " + columnData.getColName();
        }
        return columnData.getColName();
    }
}

