/*
 * Decompiled with CFR 0.152.
 */
package com.sqream.sqloaderService.dbhandler;

import com.sqream.sqloader.common.enums.DBType;
import com.sqream.sqloader.common.enums.LoadType;
import com.sqream.sqloaderService.configuration.JdbcConnectorFactory;
import com.sqream.sqloaderService.dbhandler.DbHandlerFactory;
import com.sqream.sqloaderService.dbhandler.MssqlSourceDbHandler;
import com.sqream.sqloaderService.dbhandler.OracleSourceDbHandler;
import com.sqream.sqloaderService.dbhandler.PostgresSourceDbHandler;
import com.sqream.sqloaderService.dbhandler.SapSourceDbHandler;
import com.sqream.sqloaderService.dbhandler.SourceDbHandler;
import com.sqream.sqloaderService.dbhandler.SqreamDbHandler;
import com.sqream.sqloaderService.dbhandler.SqreamSourceDbHandler;
import com.sqream.sqloaderService.dbhandler.SybaseSourceDbHandler;
import com.sqream.sqloaderService.dbhandler.TeradataSourceDbHandler;
import com.sqream.sqloaderService.dbhandler.cdc.AbstractCatalogHandler;
import com.sqream.sqloaderService.dbhandler.cdc.CdcHandler;
import com.sqream.sqloaderService.dbhandler.cdc.IncHandler;
import com.sqream.sqloaderService.dbhandler.cdc.StdHandler;
import com.sqream.sqloaderService.dbhandler.connectors.JDBCConnector;
import com.sqream.sqloaderService.dto.Params;
import com.sqream.sqloaderService.dto.dbconfigdata.SourceConfigData;
import com.sqream.sqloaderService.dto.dbconfigdata.TableConfigData;
import com.sqream.sqloaderService.enums.ExitCode;
import com.sqream.sqloaderService.enums.TableType;
import com.sqream.sqloaderService.exceptions.SqloadInitException;
import com.sqream.sqloaderService.querycomposer.AbstractQueryComposer;
import com.sqream.sqloaderService.querycomposer.CatalogQueryComposerFactory;
import java.sql.SQLException;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DbHandlerFactory {
    private static final Logger log = LoggerFactory.getLogger(DbHandlerFactory.class);
    @Autowired
    JdbcConnectorFactory jdbcConnectorFactory;
    @Autowired
    CatalogQueryComposerFactory catalogQueryComposerFactory;

    public AbstractCatalogHandler createCatalogHandler(SourceDbHandler sourceDbHandler, SqreamDbHandler sqreamDbHandler, Params params) throws SQLException {
        AbstractQueryComposer queryComposer = this.catalogQueryComposerFactory.getCatalogQueryComposer(params.getCatalogDbType(), params.getRequestId());
        JDBCConnector catalogConnector = this.jdbcConnectorFactory.createJdbcConnector(params.getConnectionStringCatalog(), "QUERY-CT", params.getRequestId());
        catalogConnector.connect();
        TableType catalogTableType = AbstractCatalogHandler.getCatalogTableType((String)params.getCdcCatalogTable(), (DBType)params.getCatalogDbType(), (DBType)params.getSourceDbType(), (String)params.getSourceDatabaseName(), (String)params.getSourceTableNameFull(), (boolean)params.getCaseSensitive(), (JDBCConnector)catalogConnector, (AbstractQueryComposer)queryComposer);
        switch (1.$SwitchMap$com$sqream$sqloaderService$enums$TableType[Objects.requireNonNull(catalogTableType).ordinal()]) {
            case 1: {
                return new CdcHandler(catalogConnector, sourceDbHandler, sqreamDbHandler, queryComposer, params);
            }
            case 2: {
                return new IncHandler(catalogConnector, sourceDbHandler, sqreamDbHandler, queryComposer, params);
            }
        }
        params.setLockCheck(Boolean.valueOf(false));
        params.setLockTable(Boolean.valueOf(false));
        return new StdHandler(catalogConnector, sourceDbHandler, sqreamDbHandler, queryComposer, params);
    }

    public SourceDbHandler createSourceDbHandler(Params params) throws SQLException {
        SourceConfigData sourceConfigData = this.getSourceConfigData(params);
        TableConfigData sourceTableConfigData = new TableConfigData(params.getSourceTableNameFull(), params.getSourceTable(), params.getSourceSchema(), params.getColumnList(), params.getConnectionStringSource());
        if (params.getSourceDbType() == DBType.ORCL) {
            return new OracleSourceDbHandler(sourceTableConfigData, sourceConfigData, this.jdbcConnectorFactory, params.getTypeMapping(), params.getRequestId());
        }
        if (params.getSourceDbType() == DBType.POSTGRES) {
            return new PostgresSourceDbHandler(sourceTableConfigData, sourceConfigData, this.jdbcConnectorFactory, params.getTypeMapping(), params.getRequestId());
        }
        if (params.getSourceDbType() == DBType.MSSQL) {
            return new MssqlSourceDbHandler(sourceTableConfigData, sourceConfigData, this.jdbcConnectorFactory, params.getTypeMapping(), params.getRequestId());
        }
        if (params.getSourceDbType() == DBType.SAP) {
            return new SapSourceDbHandler(sourceTableConfigData, sourceConfigData, this.jdbcConnectorFactory, params.getTypeMapping(), params.getRequestId());
        }
        if (params.getSourceDbType() == DBType.TERADATA) {
            return new TeradataSourceDbHandler(sourceTableConfigData, sourceConfigData, this.jdbcConnectorFactory, params.getTypeMapping(), params.getRequestId());
        }
        if (params.getSourceDbType() == DBType.SYBASE) {
            return new SybaseSourceDbHandler(sourceTableConfigData, sourceConfigData, this.jdbcConnectorFactory, params.getTypeMapping(), params.getRequestId());
        }
        if (params.getSourceDbType() == DBType.SQREAM) {
            return new SqreamSourceDbHandler(sourceTableConfigData, sourceConfigData, this.jdbcConnectorFactory, params.getTypeMapping(), params.getRequestId());
        }
        throw new SqloadInitException("Source DB is not supported. The supported source DB are: {SQREAM, ORACLE, POSTGRES, MSSQL, SAP, TERADATA, SYBASE}", ExitCode.NOT_SUPPORTED_DB, params.getRequestId());
    }

    public SqreamDbHandler createSqreamDbHandler(Params params) throws SQLException {
        String tableName;
        String tableFullName;
        if (params.getLoadType() == LoadType.FULL) {
            if (params.getDrop().booleanValue() || params.getTruncate().booleanValue()) {
                tableFullName = params.getSqreamTableNameFullTemp();
                tableName = params.getSqreamTableTemp();
            } else {
                tableFullName = params.getSqreamTableNameFull();
                tableName = params.getSqreamTable();
            }
        } else {
            tableFullName = params.getSqreamTableNameFullStg();
            tableName = params.getSqreamTableStg();
        }
        TableConfigData targetTableConfigData = new TableConfigData(tableFullName, tableName, params.getSqreamSchema(), params.getColumnList(), params.getConnectionStringSqream());
        return new SqreamDbHandler(targetTableConfigData, this.jdbcConnectorFactory, params.getTypeMapping(), params.getCaseSensitive().booleanValue(), params.getSqreamTable(), params.getSqreamDatabaseName(), params.getLoadDttmColumnName(), params.getRequestId());
    }

    private SourceConfigData getSourceConfigData(Params params) {
        boolean usePartitions = false;
        String partitionName = null;
        if (params.getSourceDbType() == DBType.ORCL) {
            usePartitions = params.getUsePartitions();
            partitionName = params.getPartitionName();
        }
        return new SourceConfigData(params.getLimit().intValue(), params.getFilter(), params.getCount().booleanValue(), params.getSplitByColumn(), params.getThreadCount().intValue(), params.getUseDbmsLob().booleanValue(), params.getRowid().booleanValue(), params.getLoadDttm().booleanValue(), params.getLoadDttmColumnName(), usePartitions, partitionName, params.getSourceDatabaseName(), params.getValidateSourceTable().booleanValue());
    }
}

