/*
 * Decompiled with CFR 0.152.
 */
package com.sqream.sqloaderService.dbhandler;

import com.sqream.sqloader.common.enums.DBType;
import com.sqream.sqloaderService.configuration.BeanUtil;
import com.sqream.sqloaderService.configuration.JdbcConnectorFactory;
import com.sqream.sqloaderService.dbhandler.DbHandler;
import com.sqream.sqloaderService.dbhandler.connectors.JDBCConnector;
import com.sqream.sqloaderService.dbhandler.connectors.QueryResultData;
import com.sqream.sqloaderService.dto.ColumnData;
import com.sqream.sqloaderService.dto.CreationColumnData;
import com.sqream.sqloaderService.dto.SelectColumnData;
import com.sqream.sqloaderService.dto.dbconfigdata.TableConfigData;
import com.sqream.sqloaderService.enums.ExitCode;
import com.sqream.sqloaderService.enums.QueryResultType;
import com.sqream.sqloaderService.exceptions.SqloadRuntimeException;
import com.sqream.sqloaderService.querycomposer.AbstractQueryComposer;
import com.sqream.sqloaderService.typemapping.TypeMappingService;
import com.sqream.sqloaderService.utils.LogUtils;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractDbHandler
implements DbHandler,
AutoCloseable {
    private static final Logger log = LoggerFactory.getLogger(AbstractDbHandler.class);
    protected final JDBCConnector jdbcConnector;
    protected AbstractQueryComposer queryComposer;
    TableConfigData tableConfigData;
    LogUtils logUtils;
    TypeMappingService typeMapping;
    String requestId;
    List<ColumnData> columnDataList;

    public AbstractDbHandler(TableConfigData tableConfigData, JdbcConnectorFactory jdbcConnectorFactory, String logHeader, TypeMappingService typeMapping, String requestId) {
        this.jdbcConnector = jdbcConnectorFactory.createJdbcConnector(tableConfigData.getConnectionString(), logHeader, requestId);
        this.typeMapping = typeMapping;
        this.tableConfigData = tableConfigData;
        this.logUtils = (LogUtils)BeanUtil.getBean(LogUtils.class);
        this.requestId = requestId;
    }

    protected abstract String getLoadDttmColumnName();

    public String getFullTableName() {
        return this.tableConfigData.getTableFullName();
    }

    public abstract DBType getDbType();

    public List<ColumnData> getCdcColumnsData(List<ColumnData> cdcColumnDataList) throws SQLException {
        return cdcColumnDataList;
    }

    public void init() throws SQLException {
        this.jdbcConnector.connect();
    }

    public void createTable(List<CreationColumnData> columnDataList, String tableFullName, boolean replace) throws SQLException {
        try {
            String createTableQuery = this.queryComposer.composeCreateTableQuery(tableFullName, columnDataList, replace);
            log.info("Creating table {} in {} DB {}", new Object[]{tableFullName, this.getDbType(), createTableQuery});
            this.jdbcConnector.executeCommand(createTableQuery, QueryResultType.IGNORE);
            log.info("Table {} created successfully in {} DB", (Object)tableFullName, (Object)this.getDbType());
        }
        catch (SQLException e) {
            String errMsg = MessageFormat.format("Table {0} creation failed in {1} DB. Error is: {2}", tableFullName, this.getDbType(), LogUtils.exceptionFormat((String)e.getMessage()));
            throw new SqloadRuntimeException(errMsg, ExitCode.TARGET_TABLE_CREATION_ERROR, this.requestId);
        }
    }

    public void truncateTable(String tableFullName) {
        try {
            String truncateTableQuery = this.queryComposer.composeTruncateTable(tableFullName);
            this.jdbcConnector.executeCommand(truncateTableQuery, QueryResultType.IGNORE);
            log.info("Table {} truncated successfully in {} DB", (Object)this.getFullTableName(), (Object)this.getDbType());
        }
        catch (SQLException e) {
            String errMsg = MessageFormat.format("Table {0} truncate didn''t succeed in {1} DB", this.getFullTableName(), this.getDbType());
            throw new SqloadRuntimeException(errMsg, ExitCode.TARGET_TABLE_TRUNCATE_ERROR, this.requestId);
        }
    }

    public List<ColumnData> getColumnsData() throws SQLException {
        if (this.columnDataList != null) {
            return this.columnDataList;
        }
        this.columnDataList = this.getColumnsData(this.tableConfigData.getSchemaName(), this.tableConfigData.getTableName(), this.tableConfigData.getConfigColumnList());
        return this.columnDataList;
    }

    public List<ColumnData> getColumnsData(String schemaName, String tableName, List<String> configColumnList) throws SQLException {
        String columnListQuery = this.queryComposer.composeColumnListQuery(schemaName, tableName, configColumnList, "0.0.0");
        try (QueryResultData queryResultData = this.jdbcConnector.executeCommandWithoutClosingStatement(columnListQuery);){
            List columnDataList = this.getColumns(queryResultData.getResultSet());
            if (columnDataList.isEmpty()) {
                throw new SqloadRuntimeException("Requested columns were not found in source table.", ExitCode.GET_COLUMNS_ERROR, this.requestId);
            }
            List list = columnDataList;
            return list;
        }
    }

    public void createTable(List<CreationColumnData> columnDataList, boolean replace) throws SQLException {
        this.createTable(columnDataList, this.getFullTableName(), replace);
    }

    public void dropTable(String tableName) {
        try {
            String dropQuery = this.queryComposer.composeDropTable(tableName);
            this.jdbcConnector.executeCommand(dropQuery, QueryResultType.IGNORE);
            log.info("Table name {} dropped successfully in {} DB", (Object)tableName, (Object)this.getDbType());
        }
        catch (SQLException e) {
            String errMsg = MessageFormat.format("Table {0} didn''t succeed to be dropped in DB {1}. Error is: {2}", tableName, this.getDbType(), LogUtils.exceptionFormat((String)e.getMessage()));
            throw new SqloadRuntimeException(errMsg, ExitCode.TARGET_TABLE_DROP_ERROR, this.requestId);
        }
    }

    public void alterTable(String name, String alteredName) {
        try {
            String alterQuery = this.queryComposer.composeAlterTableName(name, alteredName);
            this.jdbcConnector.executeCommand(alterQuery, QueryResultType.IGNORE);
            log.info("Table name {} altered successfully into {} in {} DB", new Object[]{name, alteredName, this.getDbType()});
        }
        catch (SQLException e) {
            String errMsg = MessageFormat.format("Altering table name {0} into {1} didn''t succeed in {2} DB. Error is: {3}", name, alteredName, this.getDbType(), LogUtils.exceptionFormat((String)e.getMessage()));
            throw new SqloadRuntimeException(errMsg, ExitCode.TARGET_TABLE_ALTER_ERROR, this.requestId);
        }
    }

    public boolean tryAlterTable(String name, String alteredName) {
        try {
            String alterQuery = this.queryComposer.composeAlterTableName(name, alteredName);
            this.jdbcConnector.executeCommand(alterQuery, QueryResultType.IGNORE);
            log.info("Table name {} altered successfully into {} in {} DB", new Object[]{name, alteredName, this.getDbType()});
            return true;
        }
        catch (SQLException e) {
            log.info("Altering table name {} into {} didn't succeed in {} DB. Error is: {}", new Object[]{name, alteredName, this.getDbType(), LogUtils.exceptionFormat((String)e.getMessage())});
            return false;
        }
    }

    protected List<ColumnData> getColumns(ResultSet columnsRs) {
        try {
            ArrayList<ColumnData> columnList = new ArrayList<ColumnData>();
            while (columnsRs.next()) {
                String colName = columnsRs.getString("col_name").trim();
                String colType = columnsRs.getString("col_type").trim();
                colType = this.getColType(colType);
                String colLen = columnsRs.getString("col_length");
                String colPrec = columnsRs.getString("col_prec");
                String colFrac = columnsRs.getString("col_frac");
                String colNullable = columnsRs.getString("is_nullable");
                boolean isNullable = !colNullable.equals("FALSE") && !colNullable.equals("NO") && !colNullable.equals("N");
                boolean isArray = colType.startsWith("ARRAY-");
                ColumnData columnData = new ColumnData(colName, colType, colLen, colPrec, colFrac, isNullable, null, isArray);
                log.trace("column data: {}", (Object)columnData);
                columnList.add(columnData);
            }
            return columnList;
        }
        catch (SQLException e) {
            String errMsg = MessageFormat.format("Get columns details error for table {0}. Error is: {1}", this.getFullTableName(), LogUtils.exceptionFormat((String)e.toString()));
            throw new SqloadRuntimeException(errMsg, ExitCode.GET_COLUMNS_ERROR, this.requestId);
        }
    }

    protected String getColType(String colType) {
        return colType;
    }

    public String getSelectQuery(SelectColumnData selectColumnData, String loadDttmColumnName) {
        return this.queryComposer.composeSelectQuery(selectColumnData, loadDttmColumnName);
    }

    public Object executeQuery(String queryToExecute, QueryResultType queryResultType) throws SQLException {
        return this.jdbcConnector.executeCommand(queryToExecute, queryResultType);
    }

    public boolean isTableExist(String schemaName, String tableName) {
        String query = this.queryComposer.composeIsTableExistQuery(schemaName, tableName, "0.0.0");
        return this.jdbcConnector.isExist(query);
    }

    public boolean isViewExist(String schemaName, String tableName) {
        String query = this.queryComposer.composeIsViewExistQuery(schemaName, tableName, "0.0.0");
        return this.jdbcConnector.isExist(query);
    }

    public List<String> getColumnList() throws SQLException {
        return this.getColumnList(this.tableConfigData.getTableFullName(), this.tableConfigData.getConfigColumnList());
    }

    public List<String> getColumnList(String tableName, List<String> configColumnList) throws SQLException {
        ArrayList<String> columns = new ArrayList<String>();
        SelectColumnData selectColumnData = new SelectColumnData(tableName, configColumnList, "1=0", 1, null, null, null);
        String query = this.queryComposer.composeSelectQuery(selectColumnData, this.getLoadDttmColumnName());
        try (QueryResultData queryResultData = this.jdbcConnector.executeCommandWithoutClosingStatement(query);){
            ResultSet resultSet = queryResultData.getResultSet();
            ResultSetMetaData meta = resultSet.getMetaData();
            for (int i = 1; i <= meta.getColumnCount(); ++i) {
                columns.add(meta.getColumnName(i));
            }
            ArrayList<String> arrayList = columns;
            return arrayList;
        }
    }

    public void dropView(String tableName) {
        try {
            String dropQuery = this.queryComposer.composeDropViewQuery(tableName);
            this.jdbcConnector.executeCommand(dropQuery, QueryResultType.IGNORE);
            log.info("View table name {} dropped successfully in {} DB", (Object)tableName, (Object)this.getDbType());
        }
        catch (SQLException e) {
            String errMsg = MessageFormat.format("View table {0} didn''t succeed to be dropped in DB {1}", this.getFullTableName(), this.getDbType());
            throw new SqloadRuntimeException(errMsg, ExitCode.TARGET_TABLE_DROP_ERROR, this.requestId);
        }
    }

    public String getConnectionString() {
        return this.tableConfigData.getConnectionString();
    }

    public List<CreationColumnData> getColumnsName() throws SQLException {
        log.warn("SHOULD BE IMPLEMENTED FOR {} DB", (Object)this.getDbType().name());
        return null;
    }

    @Override
    public void close() throws SQLException {
        log.info("Close {} connection", (Object)this.getDbType().name());
        this.jdbcConnector.close();
    }

    public TableConfigData getTableConfigData() {
        return this.tableConfigData;
    }
}

