/*
 * Decompiled with CFR 0.152.
 */
package com.sqream.sqloaderService.controller;

import com.sqream.sqloader.common.client.ActiveLoadsResponse;
import com.sqream.sqloader.common.client.LoaderRequests;
import com.sqream.sqloaderService.client.CancelResponse;
import com.sqream.sqloaderService.client.LoadResponse;
import com.sqream.sqloaderService.client.SyncLoadResponse;
import com.sqream.sqloaderService.dto.LogFilterRequest;
import com.sqream.sqloaderService.dto.Params;
import com.sqream.sqloaderService.logging.LogFilterService;
import com.sqream.sqloaderService.service.SqloaderService;
import jakarta.servlet.http.HttpServletRequest;
import java.net.URI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class Controller {
    private static final Logger log = LoggerFactory.getLogger(Controller.class);
    @Autowired
    SqloaderService sqloaderService;
    @Autowired
    LogFilterService logFilterService;
    @Autowired
    LoaderRequests loaderRequests;

    @PostMapping(value={"/load"}, consumes={"application/json"}, produces={"application/json"})
    public LoadResponse load(@RequestBody Params params, HttpServletRequest request) throws Exception {
        return this.sqloaderService.load(params, request);
    }

    @PostMapping(value={"/syncLoad"}, consumes={"application/json"}, produces={"application/json"})
    public SyncLoadResponse syncLoad(@RequestBody Params params, HttpServletRequest request) throws Exception {
        return this.sqloaderService.syncLoad(params, request);
    }

    @PostMapping(value={"/filterLogs"}, consumes={"application/json"}, produces={"application/json"})
    public void filterLogs(@RequestBody LogFilterRequest logFilterRequest) throws Exception {
        this.logFilterService.filterLogs(logFilterRequest);
    }

    @GetMapping(value={"/getActiveLoads"}, produces={"application/json"})
    public ActiveLoadsResponse getActiveLoads(URI url) throws Exception {
        return this.loaderRequests.getActiveLoads(url);
    }

    @GetMapping(value={"/cancelRequest/{requestId}"})
    public CancelResponse cancelRequest(@PathVariable(value="requestId") String requestId) throws Exception {
        return this.sqloaderService.cancelRequest(requestId);
    }
}

